/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.authentication.standard.ed25519.math.ed25519;

import org.mariadb.jdbc.plugin.authentication.standard.ed25519.math.Encoding;
import org.mariadb.jdbc.plugin.authentication.standard.ed25519.math.FieldElement;
import org.mariadb.jdbc.plugin.authentication.standard.ed25519.math.ed25519.Ed25519FieldElement;

public class Ed25519LittleEndianEncoding
extends Encoding {
    @Override
    public byte[] encode(FieldElement x2) {
        int[] h2 = ((Ed25519FieldElement)x2).t;
        int h0 = h2[0];
        int h1 = h2[1];
        int h22 = h2[2];
        int h3 = h2[3];
        int h4 = h2[4];
        int h5 = h2[5];
        int h6 = h2[6];
        int h7 = h2[7];
        int h8 = h2[8];
        int h9 = h2[9];
        int q2 = 19 * h9 + 0x1000000 >> 25;
        q2 = h0 + q2 >> 26;
        q2 = h1 + q2 >> 25;
        q2 = h22 + q2 >> 26;
        q2 = h3 + q2 >> 25;
        q2 = h4 + q2 >> 26;
        q2 = h5 + q2 >> 25;
        q2 = h6 + q2 >> 26;
        q2 = h7 + q2 >> 25;
        q2 = h8 + q2 >> 26;
        q2 = h9 + q2 >> 25;
        int carry0 = (h0 += 19 * q2) >> 26;
        h0 -= carry0 << 26;
        int carry1 = (h1 += carry0) >> 25;
        h1 -= carry1 << 25;
        int carry2 = (h22 += carry1) >> 26;
        h22 -= carry2 << 26;
        int carry3 = (h3 += carry2) >> 25;
        h3 -= carry3 << 25;
        int carry4 = (h4 += carry3) >> 26;
        h4 -= carry4 << 26;
        int carry5 = (h5 += carry4) >> 25;
        h5 -= carry5 << 25;
        int carry6 = (h6 += carry5) >> 26;
        int carry7 = (h7 += carry6) >> 25;
        int carry8 = (h8 += carry7) >> 26;
        int carry9 = (h9 += carry8) >> 25;
        byte[] s2 = new byte[]{(byte)h0, (byte)(h0 >> 8), (byte)(h0 >> 16), (byte)(h0 >> 24 | h1 << 2), (byte)(h1 >> 6), (byte)(h1 >> 14), (byte)(h1 >> 22 | h22 << 3), (byte)(h22 >> 5), (byte)(h22 >> 13), (byte)(h22 >> 21 | h3 << 5), (byte)(h3 >> 3), (byte)(h3 >> 11), (byte)(h3 >> 19 | h4 << 6), (byte)(h4 >> 2), (byte)(h4 >> 10), (byte)(h4 >> 18), (byte)h5, (byte)(h5 >> 8), (byte)(h5 >> 16), (byte)(h5 >> 24 | (h6 -= carry6 << 26) << 1), (byte)(h6 >> 7), (byte)(h6 >> 15), (byte)(h6 >> 23 | (h7 -= carry7 << 25) << 3), (byte)(h7 >> 5), (byte)(h7 >> 13), (byte)(h7 >> 21 | (h8 -= carry8 << 26) << 4), (byte)(h8 >> 4), (byte)(h8 >> 12), (byte)(h8 >> 20 | (h9 -= carry9 << 25) << 6), (byte)(h9 >> 2), (byte)(h9 >> 10), (byte)(h9 >> 18)};
        return s2;
    }

    static int load_3(byte[] in, int offset) {
        int result = in[offset++] & 0xFF;
        result |= (in[offset++] & 0xFF) << 8;
        return result |= (in[offset] & 0xFF) << 16;
    }

    static long load_4(byte[] in, int offset) {
        int result = in[offset++] & 0xFF;
        result |= (in[offset++] & 0xFF) << 8;
        result |= (in[offset++] & 0xFF) << 16;
        return (long)(result |= in[offset] << 24) & 0xFFFFFFFFL;
    }

    @Override
    public FieldElement decode(byte[] in) {
        long h0 = Ed25519LittleEndianEncoding.load_4(in, 0);
        long h1 = Ed25519LittleEndianEncoding.load_3(in, 4) << 6;
        long h2 = Ed25519LittleEndianEncoding.load_3(in, 7) << 5;
        long h3 = Ed25519LittleEndianEncoding.load_3(in, 10) << 3;
        long h4 = Ed25519LittleEndianEncoding.load_3(in, 13) << 2;
        long h5 = Ed25519LittleEndianEncoding.load_4(in, 16);
        long h6 = Ed25519LittleEndianEncoding.load_3(in, 20) << 7;
        long h7 = Ed25519LittleEndianEncoding.load_3(in, 23) << 5;
        long h8 = Ed25519LittleEndianEncoding.load_3(in, 26) << 4;
        long h9 = (Ed25519LittleEndianEncoding.load_3(in, 29) & 0x7FFFFF) << 2;
        long carry9 = h9 + 0x1000000L >> 25;
        h0 += carry9 * 19L;
        h9 -= carry9 << 25;
        long carry1 = h1 + 0x1000000L >> 25;
        h2 += carry1;
        h1 -= carry1 << 25;
        long carry3 = h3 + 0x1000000L >> 25;
        h4 += carry3;
        h3 -= carry3 << 25;
        long carry5 = h5 + 0x1000000L >> 25;
        h6 += carry5;
        h5 -= carry5 << 25;
        long carry7 = h7 + 0x1000000L >> 25;
        h8 += carry7;
        h7 -= carry7 << 25;
        long carry0 = h0 + 0x2000000L >> 26;
        h1 += carry0;
        h0 -= carry0 << 26;
        long carry2 = h2 + 0x2000000L >> 26;
        h3 += carry2;
        h2 -= carry2 << 26;
        long carry4 = h4 + 0x2000000L >> 26;
        long carry6 = h6 + 0x2000000L >> 26;
        long carry8 = h8 + 0x2000000L >> 26;
        int[] h10 = new int[]{(int)h0, (int)h1, (int)h2, (int)h3, (int)(h4 -= carry4 << 26), (int)(h5 += carry4), (int)(h6 -= carry6 << 26), (int)(h7 += carry6), (int)(h8 -= carry8 << 26), (int)(h9 += carry8)};
        return new Ed25519FieldElement(this.f, h10);
    }

    @Override
    public boolean isNegative(FieldElement x2) {
        byte[] s2 = this.encode(x2);
        return (s2[0] & 1) != 0;
    }
}

