/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;
import org.mariadb.jdbc.plugin.codec.ByteCodec;

public class BooleanCodec
implements Codec<Boolean> {
    public static final BooleanCodec INSTANCE = new BooleanCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.VARCHAR, new DataType[]{DataType.VARSTRING, DataType.STRING, DataType.BIGINT, DataType.INTEGER, DataType.MEDIUMINT, DataType.SMALLINT, DataType.YEAR, DataType.TINYINT, DataType.DECIMAL, DataType.OLDDECIMAL, DataType.FLOAT, DataType.DOUBLE, DataType.BIT, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Boolean.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Boolean.TYPE || type.isAssignableFrom(Boolean.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Boolean;
    }

    @Override
    public Boolean decodeText(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeTextBoolean(buffer, length, column);
    }

    public boolean decodeTextBoolean(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        switch (column.getType()) {
            case BIT: {
                return ByteCodec.parseBit(buf, length) != 0L;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: 
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INTEGER: 
            case BIGINT: 
            case YEAR: {
                String s2 = buf.readAscii(length);
                return !"0".equals(s2);
            }
            case DECIMAL: 
            case OLDDECIMAL: 
            case FLOAT: 
            case DOUBLE: {
                return new BigDecimal(buf.readAscii(length)).intValue() != 0;
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{column.getType()}));
    }

    @Override
    public Boolean decodeBinary(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeBinaryBoolean(buffer, length, column);
    }

    public boolean decodeBinaryBoolean(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        switch (column.getType()) {
            case BIT: {
                return ByteCodec.parseBit(buf, length) != 0L;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{column.getType()}));
                }
            }
            case VARCHAR: 
            case VARSTRING: 
            case STRING: {
                return !"0".equals(buf.readAscii(length));
            }
            case DECIMAL: 
            case OLDDECIMAL: {
                return new BigDecimal(buf.readAscii(length)).intValue() != 0;
            }
            case FLOAT: {
                return (int)buf.readFloat() != 0;
            }
            case DOUBLE: {
                return (int)buf.readDouble() != 0;
            }
            case TINYINT: {
                return buf.readByte() != 0;
            }
            case SMALLINT: 
            case YEAR: {
                return buf.readShort() != 0;
            }
            case MEDIUMINT: 
            case INTEGER: {
                return buf.readInt() != 0;
            }
            case BIGINT: {
                return buf.readLong() != 0L;
            }
        }
        buf.skip(length);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{column.getType()}));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeAscii((Boolean)value != false ? "1" : "0");
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeByte((Boolean)value != false ? 1 : 0);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.TINYINT.get();
    }
}

