/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;

public class IntCodec
implements Codec<Integer> {
    public static final IntCodec INSTANCE = new IntCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.FLOAT, new DataType[]{DataType.DOUBLE, DataType.OLDDECIMAL, DataType.VARCHAR, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.TINYINT, DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.BIT, DataType.YEAR, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return Integer.class.getName();
    }

    @Override
    public boolean canDecode(Column column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Integer.TYPE || type.isAssignableFrom(Integer.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Integer;
    }

    @Override
    public Integer decodeText(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeTextInt(buffer, length, column);
    }

    public int decodeTextInt(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        long result;
        switch (column.getType()) {
            case INTEGER: 
            case BIGINT: {
                result = buf.atoi(length);
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case YEAR: {
                return (int)buf.atoi(length);
            }
            case BIT: {
                result = 0L;
                for (int i2 = 0; i2 < length; ++i2) {
                    byte b2 = buf.readByte();
                    result = (result << 8) + (long)(b2 & 0xFF);
                }
                break;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{column.getType()}));
                }
            }
            case FLOAT: 
            case DOUBLE: 
            case OLDDECIMAL: 
            case VARCHAR: 
            case DECIMAL: 
            case ENUM: 
            case VARSTRING: 
            case STRING: {
                String str = buf.readString(length);
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Integer", str));
                }
            }
            default: {
                buf.skip(length);
                throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{column.getType()}));
            }
        }
        int res = (int)result;
        if ((long)res != result || result < 0L && !column.isSigned()) {
            throw new SQLDataException("integer overflow");
        }
        return res;
    }

    @Override
    public Integer decodeBinary(ReadableByteBuf buffer, int length, Column column, Calendar cal) throws SQLDataException {
        return this.decodeBinaryInt(buffer, length, column);
    }

    public int decodeBinaryInt(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        long result;
        switch (column.getType()) {
            case TINYINT: {
                return column.isSigned() ? (short)buf.readByte() : buf.readUnsignedByte();
            }
            case SMALLINT: 
            case YEAR: {
                return column.isSigned() ? buf.readShort() : buf.readUnsignedShort();
            }
            case MEDIUMINT: {
                int res = column.isSigned() ? buf.readMedium() : buf.readUnsignedMedium();
                buf.skip();
                return res;
            }
            case INTEGER: {
                if (column.isSigned()) {
                    return buf.readInt();
                }
                result = buf.readUnsignedInt();
                break;
            }
            case BIGINT: {
                if (column.isSigned()) {
                    result = buf.readLong();
                    break;
                }
                byte[] bb = new byte[8];
                for (int i2 = 7; i2 >= 0; --i2) {
                    bb[i2] = buf.readByte();
                }
                BigInteger val = new BigInteger(1, bb);
                try {
                    return val.intValueExact();
                }
                catch (ArithmeticException ae2) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Integer", val));
                }
            }
            case BIT: {
                result = 0L;
                for (int i3 = 0; i3 < length; ++i3) {
                    byte b2 = buf.readByte();
                    result = (result << 8) + (long)(b2 & 0xFF);
                }
                break;
            }
            case FLOAT: {
                result = (long)buf.readFloat();
                break;
            }
            case DOUBLE: {
                result = (long)buf.readDouble();
                break;
            }
            case BLOB: 
            case TINYBLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                if (column.isBinary()) {
                    buf.skip(length);
                    throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{column.getType()}));
                }
            }
            case OLDDECIMAL: 
            case VARCHAR: 
            case DECIMAL: 
            case ENUM: 
            case VARSTRING: 
            case STRING: {
                String str = buf.readString(length);
                try {
                    result = new BigDecimal(str).setScale(0, RoundingMode.DOWN).longValueExact();
                    break;
                }
                catch (ArithmeticException | NumberFormatException nfe) {
                    throw new SQLDataException(String.format("value '%s' cannot be decoded as Integer", str));
                }
            }
            default: {
                buf.skip(length);
                throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{column.getType()}));
            }
        }
        int res = (int)result;
        if ((long)res != result) {
            throw new SQLDataException("integer overflow");
        }
        return res;
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeAscii(value.toString());
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeInt((Integer)value);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.INTEGER.get();
    }
}

