/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.type;

import java.sql.SQLDataException;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.type.GeometryCollection;
import org.mariadb.jdbc.type.LineString;
import org.mariadb.jdbc.type.MultiLineString;
import org.mariadb.jdbc.type.MultiPoint;
import org.mariadb.jdbc.type.MultiPolygon;
import org.mariadb.jdbc.type.Point;
import org.mariadb.jdbc.type.Polygon;

public interface Geometry {
    public static Point parsePoint(boolean littleEndian, ReadableByteBuf buf) {
        double x2 = littleEndian ? buf.readDouble() : buf.readDoubleBE();
        double y2 = littleEndian ? buf.readDouble() : buf.readDoubleBE();
        return new Point(x2, y2);
    }

    public static Geometry getGeometry(ReadableByteBuf buf, int length, Column column) throws SQLDataException {
        if (length == 0) {
            return null;
        }
        boolean littleEndian = buf.readByte() == 1;
        int dataType = littleEndian ? buf.readInt() : buf.readIntBE();
        switch (dataType) {
            case 1: {
                return Geometry.parsePoint(littleEndian, buf);
            }
            case 2: {
                int pointNumber = littleEndian ? buf.readInt() : buf.readIntBE();
                Point[] points = new Point[pointNumber];
                for (int i2 = 0; i2 < pointNumber; ++i2) {
                    points[i2] = Geometry.parsePoint(littleEndian, buf);
                }
                return new LineString(points, true);
            }
            case 3: {
                int numRings = littleEndian ? buf.readInt() : buf.readIntBE();
                LineString[] lines = new LineString[numRings];
                for (int i3 = 0; i3 < numRings; ++i3) {
                    int pointNb = littleEndian ? buf.readInt() : buf.readIntBE();
                    Point[] lsPoints = new Point[pointNb];
                    for (int j2 = 0; j2 < pointNb; ++j2) {
                        lsPoints[j2] = Geometry.parsePoint(littleEndian, buf);
                    }
                    lines[i3] = new LineString(lsPoints, false);
                }
                return new Polygon(lines);
            }
            case 4: {
                int pointNb = littleEndian ? buf.readInt() : buf.readIntBE();
                Point[] pointArr = new Point[pointNb];
                for (int i4 = 0; i4 < pointNb; ++i4) {
                    pointArr[i4] = (Point)Geometry.getGeometry(buf, length, column);
                }
                return new MultiPoint(pointArr);
            }
            case 5: {
                int multiNb = littleEndian ? buf.readInt() : buf.readIntBE();
                LineString[] multiLines = new LineString[multiNb];
                for (int i5 = 0; i5 < multiNb; ++i5) {
                    multiLines[i5] = (LineString)Geometry.getGeometry(buf, length, column);
                }
                return new MultiLineString(multiLines);
            }
            case 6: {
                int multiPolyNb = littleEndian ? buf.readInt() : buf.readIntBE();
                Polygon[] multiPolygons = new Polygon[multiPolyNb];
                for (int i6 = 0; i6 < multiPolyNb; ++i6) {
                    multiPolygons[i6] = (Polygon)Geometry.getGeometry(buf, length, column);
                }
                return new MultiPolygon(multiPolygons);
            }
            case 7: {
                int multiCollNb = littleEndian ? buf.readInt() : buf.readIntBE();
                Geometry[] multiGeos = new Geometry[multiCollNb];
                for (int i7 = 0; i7 < multiCollNb; ++i7) {
                    multiGeos[i7] = Geometry.getGeometry(buf, length, column);
                }
                return new GeometryCollection(multiGeos);
            }
        }
        buf.skip(length - 5);
        throw new SQLDataException(String.format("Data type %s cannot be decoded as Geometry", new Object[]{column.getType()}));
    }
}

