/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.jdbc.util.PrepareResult;

public final class ClientParser
implements PrepareResult {
    private final String sql;
    private final byte[] query;
    private List<Integer> paramPositions;
    private int paramCount;

    private ClientParser(String sql, byte[] query, List<Integer> paramPositions) {
        this.sql = sql;
        this.query = query;
        this.paramPositions = paramPositions;
        this.paramCount = paramPositions.size();
    }

    public static ClientParser parameterParts(String queryString, boolean noBackslashEscapes) {
        ArrayList<Integer> paramPositions = new ArrayList<Integer>();
        LexState state = LexState.Normal;
        byte lastChar = 0;
        boolean singleQuotes = false;
        byte[] query = queryString.getBytes(StandardCharsets.UTF_8);
        int queryLength = query.length;
        for (int i2 = 0; i2 < queryLength; ++i2) {
            byte car = query[i2];
            if (!(state != LexState.Escape || car == 39 && singleQuotes || car == 34 && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case 42: {
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case 47: {
                    if (state == LexState.SlashStarComment && lastChar == 42) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 35: {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 45: {
                    if (state != LexState.Normal || lastChar != 45) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 10: {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case 34: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 39: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 92: {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case 63: {
                    if (state != LexState.Normal) break;
                    paramPositions.add(i2);
                    break;
                }
                case 96: {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                }
            }
            lastChar = car;
        }
        return new ClientParser(queryString, query, paramPositions);
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    public byte[] getQuery() {
        return this.query;
    }

    public List<Integer> getParamPositions() {
        return this.paramPositions;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        EOLComment,
        Backtick;

    }
}

