/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.IOException;
import java.io.InputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.FilterEncoder;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.LZMA2Encoder;
import org.tukaani.xz.LZMA2InputStream;
import org.tukaani.xz.LZMA2OutputStream;
import org.tukaani.xz.UncompressedLZMA2OutputStream;
import org.tukaani.xz.UnsupportedOptionsException;

public class LZMA2Options
extends FilterOptions {
    public static final int PRESET_MIN = 0;
    public static final int PRESET_MAX = 9;
    public static final int PRESET_DEFAULT = 6;
    public static final int DICT_SIZE_MIN = 4096;
    public static final int DICT_SIZE_MAX = 0x30000000;
    public static final int DICT_SIZE_DEFAULT = 0x800000;
    public static final int LC_LP_MAX = 4;
    public static final int LC_DEFAULT = 3;
    public static final int LP_DEFAULT = 0;
    public static final int PB_MAX = 4;
    public static final int PB_DEFAULT = 2;
    public static final int MODE_UNCOMPRESSED = 0;
    public static final int MODE_FAST = 1;
    public static final int MODE_NORMAL = 2;
    public static final int NICE_LEN_MIN = 8;
    public static final int NICE_LEN_MAX = 273;
    public static final int MF_HC4 = 4;
    public static final int MF_BT4 = 20;
    private static final int[] presetToDictSize = new int[]{262144, 0x100000, 0x200000, 0x400000, 0x400000, 0x800000, 0x800000, 0x1000000, 0x2000000, 0x4000000};
    private static final int[] presetToDepthLimit = new int[]{4, 8, 24, 48};
    private int dictSize;
    private byte[] presetDict = null;
    private int lc;
    private int lp;
    private int pb;
    private int mode;
    private int niceLen;
    private int mf;
    private int depthLimit;

    public LZMA2Options() {
        try {
            this.setPreset(6);
        }
        catch (UnsupportedOptionsException unsupportedOptionsException) {
            assert (false);
            throw new RuntimeException();
        }
    }

    public LZMA2Options(int n2) throws UnsupportedOptionsException {
        this.setPreset(n2);
    }

    public LZMA2Options(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) throws UnsupportedOptionsException {
        this.setDictSize(n2);
        this.setLcLp(n3, n4);
        this.setPb(n5);
        this.setMode(n6);
        this.setNiceLen(n7);
        this.setMatchFinder(n8);
        this.setDepthLimit(n9);
    }

    public void setPreset(int n2) throws UnsupportedOptionsException {
        if (n2 < 0 || n2 > 9) {
            throw new UnsupportedOptionsException("Unsupported preset: " + n2);
        }
        this.lc = 3;
        this.lp = 0;
        this.pb = 2;
        this.dictSize = presetToDictSize[n2];
        if (n2 <= 3) {
            this.mode = 1;
            this.mf = 4;
            this.niceLen = n2 <= 1 ? 128 : 273;
            this.depthLimit = presetToDepthLimit[n2];
        } else {
            this.mode = 2;
            this.mf = 20;
            this.niceLen = n2 == 4 ? 16 : (n2 == 5 ? 32 : 64);
            this.depthLimit = 0;
        }
    }

    public void setDictSize(int n2) throws UnsupportedOptionsException {
        if (n2 < 4096) {
            throw new UnsupportedOptionsException("LZMA2 dictionary size must be at least 4 KiB: " + n2 + " B");
        }
        if (n2 > 0x30000000) {
            throw new UnsupportedOptionsException("LZMA2 dictionary size must not exceed 768 MiB: " + n2 + " B");
        }
        this.dictSize = n2;
    }

    public int getDictSize() {
        return this.dictSize;
    }

    public void setPresetDict(byte[] byArray) {
        this.presetDict = byArray;
    }

    public byte[] getPresetDict() {
        return this.presetDict;
    }

    public void setLcLp(int n2, int n3) throws UnsupportedOptionsException {
        if (n2 < 0 || n3 < 0 || n2 > 4 || n3 > 4 || n2 + n3 > 4) {
            throw new UnsupportedOptionsException("lc + lp must not exceed 4: " + n2 + " + " + n3);
        }
        this.lc = n2;
        this.lp = n3;
    }

    public void setLc(int n2) throws UnsupportedOptionsException {
        this.setLcLp(n2, this.lp);
    }

    public void setLp(int n2) throws UnsupportedOptionsException {
        this.setLcLp(this.lc, n2);
    }

    public int getLc() {
        return this.lc;
    }

    public int getLp() {
        return this.lp;
    }

    public void setPb(int n2) throws UnsupportedOptionsException {
        if (n2 < 0 || n2 > 4) {
            throw new UnsupportedOptionsException("pb must not exceed 4: " + n2);
        }
        this.pb = n2;
    }

    public int getPb() {
        return this.pb;
    }

    public void setMode(int n2) throws UnsupportedOptionsException {
        if (n2 < 0 || n2 > 2) {
            throw new UnsupportedOptionsException("Unsupported compression mode: " + n2);
        }
        this.mode = n2;
    }

    public int getMode() {
        return this.mode;
    }

    public void setNiceLen(int n2) throws UnsupportedOptionsException {
        if (n2 < 8) {
            throw new UnsupportedOptionsException("Minimum nice length of matches is 8 bytes: " + n2);
        }
        if (n2 > 273) {
            throw new UnsupportedOptionsException("Maximum nice length of matches is 273: " + n2);
        }
        this.niceLen = n2;
    }

    public int getNiceLen() {
        return this.niceLen;
    }

    public void setMatchFinder(int n2) throws UnsupportedOptionsException {
        if (n2 != 4 && n2 != 20) {
            throw new UnsupportedOptionsException("Unsupported match finder: " + n2);
        }
        this.mf = n2;
    }

    public int getMatchFinder() {
        return this.mf;
    }

    public void setDepthLimit(int n2) throws UnsupportedOptionsException {
        if (n2 < 0) {
            throw new UnsupportedOptionsException("Depth limit cannot be negative: " + n2);
        }
        this.depthLimit = n2;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    @Override
    public int getEncoderMemoryUsage() {
        return this.mode == 0 ? UncompressedLZMA2OutputStream.getMemoryUsage() : LZMA2OutputStream.getMemoryUsage(this);
    }

    @Override
    public FinishableOutputStream getOutputStream(FinishableOutputStream finishableOutputStream, ArrayCache arrayCache) {
        if (this.mode == 0) {
            return new UncompressedLZMA2OutputStream(finishableOutputStream, arrayCache);
        }
        return new LZMA2OutputStream(finishableOutputStream, this, arrayCache);
    }

    @Override
    public int getDecoderMemoryUsage() {
        int n2 = this.dictSize - 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 3;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        n2 |= n2 >>> 16;
        return LZMA2InputStream.getMemoryUsage(n2 + 1);
    }

    @Override
    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) throws IOException {
        return new LZMA2InputStream(inputStream, this.dictSize, this.presetDict, arrayCache);
    }

    @Override
    FilterEncoder getFilterEncoder() {
        return new LZMA2Encoder(this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            throw new RuntimeException();
        }
    }
}

