/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.configuration.deployers;

import java.io.File;
import org.jahia.configuration.deployers.AbstractServerDeploymentImpl;
import org.jahia.configuration.deployers.ServerDeploymentInterface;
import org.jahia.configuration.deployers.TomcatServerDeploymentImpl;
import org.jahia.configuration.deployers.WebsphereServerDeploymentImpl;
import org.jahia.configuration.deployers.jboss.JBossServerDeploymentImpl;

public final class ServerDeploymentFactory {
    public static ServerDeploymentInterface getImplementation(String serverType, File targetServerDir, File configDir, File dataDir) {
        if (serverType == null || serverType.length() == 0) {
            throw new IllegalArgumentException("Server type is not provided");
        }
        serverType = serverType.trim().toLowerCase();
        AbstractServerDeploymentImpl deployer = null;
        if (serverType.startsWith("tomcat")) {
            deployer = new TomcatServerDeploymentImpl("tomcat", "Apache Tomcat 8.x", targetServerDir);
        } else if (serverType.startsWith("jboss")) {
            deployer = new JBossServerDeploymentImpl("jboss", "Red Hat JBoss EAP 6.x", targetServerDir);
        } else if (serverType.startsWith("was") || serverType.startsWith("websphere")) {
            deployer = new WebsphereServerDeploymentImpl("websphere", "IBM WebSphere Application Server 8.5.5.x", targetServerDir);
        } else {
            throw new IllegalArgumentException("Unsupported server type: " + serverType);
        }
        deployer.setConfigDir(configDir);
        deployer.setDataDir(dataDir);
        deployer.init();
        return deployer;
    }

    public static ServerDeploymentInterface getImplementation(String serverType, String serverVersion, File targetServerDir, File configDir, File dataDir) {
        return ServerDeploymentFactory.getImplementation(serverVersion != null ? serverType + serverVersion : serverType, targetServerDir, configDir, dataDir);
    }
}

