/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.api.forms;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldValue;
import org.jahia.modules.contenteditor.api.forms.EditorFormProperty;

public class EditorFormFieldValueConstraint {
    private String displayValue;
    private String displayValueKey;
    private EditorFormFieldValue value;
    private List<EditorFormProperty> propertyList;

    public EditorFormFieldValueConstraint() {
    }

    public EditorFormFieldValueConstraint(String displayValue, String displayValueKey, EditorFormFieldValue value, List<EditorFormProperty> propertyList) {
        this.displayValue = displayValue;
        this.displayValueKey = displayValueKey;
        this.value = value;
        this.propertyList = propertyList;
    }

    public EditorFormFieldValueConstraint(EditorFormFieldValueConstraint constraint) {
        this(constraint.displayValue, constraint.displayValueKey, constraint.value, constraint.propertyList == null ? null : constraint.propertyList.stream().map(property -> new EditorFormProperty((EditorFormProperty)property)).collect(Collectors.toList()));
    }

    @GraphQLField
    @GraphQLDescription(value="The value as it is intended to be displayed in UIs")
    public String getDisplayValue() {
        return this.displayValue;
    }

    public void setDisplayValue(String displayValue) {
        this.displayValue = displayValue;
    }

    @GraphQLField
    @GraphQLDescription(value="The key of the value to get the translated value from the client side")
    public String getDisplayValueKey() {
        return this.displayValueKey;
    }

    public void setDisplayValueKey(String displayValueKey) {
        this.displayValueKey = displayValueKey;
    }

    @GraphQLField
    @GraphQLDescription(value="The actual value to be used in storage")
    public EditorFormFieldValue getValue() {
        return this.value;
    }

    public void setValue(EditorFormFieldValue value) {
        this.value = value;
    }

    @GraphQLField
    @GraphQLName(value="properties")
    @GraphQLDescription(value="The properties for the value")
    public List<EditorFormProperty> getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(List<EditorFormProperty> propertyList) {
        this.propertyList = propertyList;
    }

    public String toString() {
        return "EditorFormFieldValueConstraint{displayValue='" + this.displayValue + '\'' + ", value=" + this.value + ", propertyList=" + this.propertyList + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditorFormFieldValueConstraint that = (EditorFormFieldValueConstraint)o;
        return Objects.equals(this.displayValue, that.displayValue) && Objects.equals(this.value, that.value) && Objects.equals(this.propertyList, that.propertyList);
    }

    public int hashCode() {
        return Objects.hash(this.displayValue, this.value, this.propertyList);
    }
}

