/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.api.forms;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.ArrayList;
import java.util.List;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldSet;

public class EditorFormSection {
    private String name;
    List<EditorFormFieldSet> fieldSets = new ArrayList<EditorFormFieldSet>();
    private String displayName;
    private Double rank;
    private Double priority;
    private String description;
    private boolean hide = false;
    private boolean expanded;

    public EditorFormSection() {
    }

    public EditorFormSection(String name, String displayName, String description, Double rank, Double priority, List<EditorFormFieldSet> fieldSets, boolean expanded) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.rank = rank;
        this.priority = priority;
        this.fieldSets = fieldSets;
        this.expanded = expanded;
    }

    @GraphQLField
    @GraphQLDescription(value="Retrieve the name (aka identifier) of the section")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @GraphQLField
    @GraphQLDescription(value="Retrieve the displayable name of the section")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @GraphQLField
    @GraphQLDescription(value="Returns the description of the section")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Double getRank() {
        return this.rank;
    }

    public void setRank(Double rank) {
        this.rank = rank;
    }

    public Double getPriority() {
        return this.priority;
    }

    public void setPriority(Double priority) {
        this.priority = priority;
    }

    @GraphQLField
    @GraphQLName(value="hide")
    @GraphQLDescription(value="Check if this section should be hide")
    public boolean isHide() {
        return this.hide;
    }

    public void setHide(boolean hide) {
        this.hide = hide;
    }

    @GraphQLField
    @GraphQLName(value="fieldSets")
    @GraphQLDescription(value="Returns the field sets contained in this section")
    public List<EditorFormFieldSet> getFieldSets() {
        return this.fieldSets;
    }

    public void setFieldSets(List<EditorFormFieldSet> fieldSets) {
        this.fieldSets = fieldSets;
    }

    @GraphQLField
    @GraphQLName(value="expanded")
    @GraphQLDescription(value="Is the section expanded")
    public boolean expanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public EditorFormFieldSet getFieldSetByName(String fieldSetName) {
        if (fieldSetName == null || fieldSetName.isEmpty()) {
            return null;
        }
        return this.getFieldSets().stream().filter(fs -> fs.getName().equals(fieldSetName)).findFirst().orElse(null);
    }
}

