/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.api.forms.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.api.templates.JahiaTemplateManagerService;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.modules.contenteditor.api.forms.EditorForm;
import org.jahia.modules.contenteditor.api.forms.EditorFormDefinition;
import org.jahia.modules.contenteditor.api.forms.EditorFormException;
import org.jahia.modules.contenteditor.api.forms.EditorFormField;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldSet;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldTarget;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldValue;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldValueConstraint;
import org.jahia.modules.contenteditor.api.forms.EditorFormProperty;
import org.jahia.modules.contenteditor.api.forms.EditorFormSection;
import org.jahia.modules.contenteditor.api.forms.EditorFormSectionDefinition;
import org.jahia.modules.contenteditor.api.forms.EditorFormService;
import org.jahia.modules.contenteditor.api.forms.impl.StaticDefinitionsRegistry;
import org.jahia.modules.contenteditor.graphql.api.types.ContextEntryInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyType;
import org.jahia.services.content.ComplexPublicationService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.PublicationJob;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedItemDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.content.nodetypes.SelectorType;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializer;
import org.jahia.services.content.nodetypes.initializers.ChoiceListInitializerService;
import org.jahia.services.content.nodetypes.initializers.ChoiceListValue;
import org.jahia.services.scheduler.BackgroundJob;
import org.jahia.services.scheduler.SchedulerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.i18n.Messages;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.owasp.html.Sanitizers;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class EditorFormServiceImpl
implements EditorFormService {
    private static final Logger logger = LoggerFactory.getLogger(EditorFormServiceImpl.class);
    private static final String EDIT = "edit";
    private static final String CREATE = "create";
    public static final String DEFAULT_SECTION = "content";
    private NodeTypeRegistry nodeTypeRegistry;
    private ChoiceListInitializerService choiceListInitializerService;
    private StaticDefinitionsRegistry staticDefinitionsRegistry;
    private ComplexPublicationService publicationService;
    private SchedulerService schedulerService;
    private JahiaTemplateManagerService jahiaTemplateManagerService;
    private static Map<Integer, Integer> defaultSelectors = new HashMap<Integer, Integer>();
    private static final Pattern RANGE_PATTERN = Pattern.compile("([\\(\\[]) *(\\-?\\d+\\.?\\d*)? *, *(\\-?\\d+\\.?\\d*)? *([\\)\\]])");
    private static final int LOWER_LIMIT_RANGE_IDX = 2;
    private static final List<String> PUBLISHED_TECHNICAL_NODES;

    @Reference
    public void setChoiceListInitializerService(ChoiceListInitializerService choiceListInitializerService) {
        this.choiceListInitializerService = choiceListInitializerService;
    }

    @Reference
    public void setNodeTypeRegistry(NodeTypeRegistry nodeTypeRegistry) {
        this.nodeTypeRegistry = nodeTypeRegistry;
    }

    @Reference
    public void setJahiaTemplateManagerService(JahiaTemplateManagerService jahiaTemplateManagerService) {
        this.jahiaTemplateManagerService = jahiaTemplateManagerService;
    }

    @Reference
    public void setStaticDefinitionsRegistry(StaticDefinitionsRegistry staticDefinitionsRegistry) {
        this.staticDefinitionsRegistry = staticDefinitionsRegistry;
    }

    @Reference
    public void setPublicationService(ComplexPublicationService publicationService) {
        this.publicationService = publicationService;
    }

    @Reference
    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    @Override
    public EditorForm getCreateForm(String primaryNodeTypeName, Locale uiLocale, Locale locale, String uuidOrPath) throws EditorFormException {
        try {
            return this.getEditorForm(this.nodeTypeRegistry.getNodeType(primaryNodeTypeName), uiLocale, locale, null, this.resolveNodeFromPathorUUID(uuidOrPath, locale));
        }
        catch (RepositoryException e) {
            throw new EditorFormException("Error while building create form definition for node: " + uuidOrPath + " and nodeType: " + primaryNodeTypeName, e);
        }
    }

    @Override
    public EditorForm getEditForm(Locale uiLocale, Locale locale, String uuidOrPath) throws EditorFormException {
        try {
            JCRNodeWrapper node = this.resolveNodeFromPathorUUID(uuidOrPath, locale);
            return this.getEditorForm(node.getPrimaryNodeType(), uiLocale, locale, node, node.getParent());
        }
        catch (RepositoryException e) {
            throw new EditorFormException("Error while building edit form definition for node: " + uuidOrPath, e);
        }
    }

    @Override
    public List<EditorFormFieldValueConstraint> getFieldConstraints(String nodeUuidOrPath, String parentNodeUuidOrPath, String primaryNodeTypeName, String fieldNodeType, String fieldName, List<ContextEntryInput> context, Locale uiLocale, Locale locale) throws EditorFormException {
        try {
            JCRNodeWrapper node = nodeUuidOrPath != null ? this.resolveNodeFromPathorUUID(nodeUuidOrPath, locale) : null;
            JCRNodeWrapper parentNode = this.resolveNodeFromPathorUUID(parentNodeUuidOrPath, locale);
            ExtendedPropertyDefinition fieldPropertyDefinition = this.nodeTypeRegistry.getNodeType(fieldNodeType).getPropertyDefinition(fieldName);
            if (fieldPropertyDefinition != null) {
                ExtendedNodeType primaryNodeType = this.nodeTypeRegistry.getNodeType(primaryNodeTypeName);
                EditorFormField editorFormField = this.generateEditorFormField((ExtendedItemDefinition)fieldPropertyDefinition, primaryNodeType, node, parentNode, uiLocale, locale, 0.0);
                editorFormField = this.mergeWithStaticFormField(fieldNodeType, editorFormField);
                HashMap<String, Object> extendContext = new HashMap<String, Object>();
                editorFormField.getSelectorOptions().forEach(option -> extendContext.put(option.getName(), option.getValue()));
                for (ContextEntryInput contextEntry : context) {
                    if (contextEntry.getValue() == null) continue;
                    extendContext.put(contextEntry.getKey(), contextEntry.getValue());
                }
                return this.getValueConstraints(primaryNodeType, editorFormField, node, parentNode, locale, extendContext);
            }
            return Collections.emptyList();
        }
        catch (RepositoryException e) {
            throw new EditorFormException("Error while building field constraints for node: " + nodeUuidOrPath + ", node type: " + primaryNodeTypeName + ", parent node: " + parentNodeUuidOrPath + ", field node type: " + fieldNodeType + ", field name: " + fieldName, e);
        }
    }

    @Override
    public boolean publishForm(Locale locale, String uuidOrPath) throws EditorFormException {
        JCRSessionWrapper session;
        String path;
        String uuid;
        try {
            JCRNodeWrapper nodeToPublish = this.resolveNodeFromPathorUUID(uuidOrPath, locale);
            uuid = nodeToPublish.getIdentifier();
            path = nodeToPublish.getPath();
            session = JCRSessionFactory.getInstance().getCurrentUserSession();
        }
        catch (RepositoryException e) {
            throw new EditorFormException("Cannot found node: " + uuidOrPath, e);
        }
        Collection filteredInfos = this.publicationService.getFullPublicationInfos(Collections.singleton(uuid), Collections.singletonList(locale.toString()), false, session).stream().filter(info -> info.getPublicationStatus() != 11).filter(ComplexPublicationService.FullPublicationInfo::isAllowedToPublishWithoutWorkflow).filter(info -> path.equals(info.getNodePath()) || PUBLISHED_TECHNICAL_NODES.stream().anyMatch(technicalNodeName -> {
            String technicalNodePath = path + "/" + technicalNodeName;
            String technicalNodeChildPath = technicalNodePath + "/";
            return technicalNodePath.equals(info.getNodePath()) || info.getNodePath().startsWith(technicalNodeChildPath);
        })).collect(Collectors.toList());
        LinkedList<String> uuids = new LinkedList<String>();
        for (ComplexPublicationService.FullPublicationInfo info2 : filteredInfos) {
            if (info2.getNodeIdentifier() != null) {
                uuids.add(info2.getNodeIdentifier());
            }
            if (info2.getTranslationNodeIdentifier() != null) {
                uuids.add(info2.getTranslationNodeIdentifier());
            }
            uuids.addAll(info2.getDeletedTranslationNodeIdentifiers());
        }
        String workspaceName = session.getWorkspace().getName();
        ArrayList<String> paths = new ArrayList<String>();
        for (String uuidToPublish : uuids) {
            try {
                paths.add(session.getNodeByIdentifier(uuidToPublish).getPath());
            }
            catch (RepositoryException e) {
                throw new EditorFormException(e);
            }
        }
        JobDetail jobDetail = BackgroundJob.createJahiaJob((String)"Publication", PublicationJob.class);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put((Object)"publicationInfos", uuids);
        jobDataMap.put((Object)"publicationPaths", paths);
        jobDataMap.put("source", workspaceName);
        jobDataMap.put("destination", "live");
        jobDataMap.put("checkPermissions", true);
        try {
            this.schedulerService.scheduleJobNow(jobDetail);
        }
        catch (SchedulerException e) {
            throw new EditorFormException(e);
        }
        return true;
    }

    @Override
    public SortedSet<EditorFormDefinition> getFormOverrides(String primaryNodeTypeName) {
        try {
            return this.staticDefinitionsRegistry.getFormDefinitionsForType(this.nodeTypeRegistry.getNodeType(primaryNodeTypeName));
        }
        catch (NoSuchNodeTypeException e) {
            throw new RuntimeException(e);
        }
    }

    private JCRNodeWrapper resolveNodeFromPathorUUID(String uuidOrPath, Locale locale) throws RepositoryException {
        if (StringUtils.startsWith((String)uuidOrPath, (String)"/")) {
            return this.getSession(locale, uuidOrPath).getNode(uuidOrPath);
        }
        return this.getSession(locale, uuidOrPath).getNodeByIdentifier(uuidOrPath);
    }

    private EditorForm getEditorForm(ExtendedNodeType primaryNodeType, Locale uiLocale, Locale locale, JCRNodeWrapper existingNode, JCRNodeWrapper parentNode) throws EditorFormException {
        String mode = existingNode == null ? CREATE : EDIT;
        JCRNodeWrapper currentNode = EDIT.equals(mode) ? existingNode : parentNode;
        try {
            String primaryNodeTypeName = primaryNodeType.getName();
            HashMap<String, EditorFormSection> formSectionsByName = new HashMap<String, EditorFormSection>();
            HashSet<String> processedProperties = new HashSet<String>();
            HashSet<String> processedNodeTypes = new HashSet<String>();
            this.generateAndMergeFieldSetForType(primaryNodeType, uiLocale, locale, existingNode, parentNode, primaryNodeType, formSectionsByName, false, false, true, processedProperties, false);
            processedNodeTypes.add(primaryNodeTypeName);
            Set nodeTypesToProcess = Arrays.stream(primaryNodeType.getSupertypes()).collect(Collectors.toCollection(LinkedHashSet::new));
            for (ExtendedNodeType superType : nodeTypesToProcess) {
                this.generateAndMergeFieldSetForType(superType, uiLocale, locale, existingNode, parentNode, primaryNodeType, formSectionsByName, false, false, true, processedProperties, false);
                processedNodeTypes.add(superType.getName());
            }
            this.checkIfListOrderingSectionIsRequired(primaryNodeType, currentNode, formSectionsByName);
            JCRSiteNode resolvedSite = EDIT.equals(mode) && existingNode.isNodeType("jnt:virtualsite") ? (JCRSiteNode)existingNode : parentNode.getResolveSite();
            List<ExtendedNodeType> extendMixins = this.getExtendMixins(primaryNodeType, resolvedSite);
            for (ExtendedNodeType extendMixinNodeType : extendMixins) {
                if (processedNodeTypes.contains(extendMixinNodeType.getName())) continue;
                boolean activated = EDIT.equals(mode) && existingNode.isNodeType(extendMixinNodeType.getName());
                this.generateAndMergeFieldSetForType(extendMixinNodeType, uiLocale, locale, existingNode, parentNode, primaryNodeType, formSectionsByName, false, true, activated, processedProperties, true);
                processedNodeTypes.add(extendMixinNodeType.getName());
            }
            SortedSet<EditorFormDefinition> formDefinitionsToMerge = this.staticDefinitionsRegistry.getFormDefinitionsForType(primaryNodeType);
            this.addMixinsNodeType(primaryNodeType, uiLocale, locale, existingNode, parentNode, mode, formSectionsByName, processedProperties, processedNodeTypes, formDefinitionsToMerge);
            JCRSiteNode site = existingNode != null ? existingNode.getResolveSite() : parentNode.getResolveSite();
            EditorFormDefinition mergedFormDefinition = this.mergeFormDefinitions(formDefinitionsToMerge, site);
            if (mergedFormDefinition.getSections() != null) {
                List<EditorFormSectionDefinition> filteredSections = mergedFormDefinition.getSections().stream().map(editorFormSectionDefinition -> {
                    editorFormSectionDefinition.setHide(this.shouldHideSection((EditorFormSectionDefinition)editorFormSectionDefinition, mode));
                    return editorFormSectionDefinition;
                }).collect(Collectors.toList());
                mergedFormDefinition.setSections(filteredSections);
            }
            List<EditorFormSection> sortedSections = this.sortSections(formSectionsByName, mergedFormDefinition, uiLocale, parentNode.getResolveSite());
            this.moveSystemName(sortedSections, primaryNodeType, currentNode, locale, mode, site);
            sortedSections = sortedSections.stream().filter(section -> {
                EditorFormSectionDefinition sectionDefinition = mergedFormDefinition.getSections().stream().filter(s -> s.getName().equals(section.getName())).findFirst().orElse(null);
                return sectionDefinition != null && (sectionDefinition.getRequiredPermission() == null || site.hasPermission(sectionDefinition.getRequiredPermission()));
            }).collect(Collectors.toList());
            String formDisplayName = primaryNodeType.getLabel(uiLocale);
            String formDescription = primaryNodeType.getDescription(uiLocale);
            return new EditorForm(primaryNodeTypeName, formDisplayName, formDescription, mergedFormDefinition.hasPreview(), sortedSections);
        }
        catch (RepositoryException e) {
            throw new EditorFormException("Error while building edit form definition for node: " + currentNode.getPath() + " and nodeType: " + primaryNodeType.getName(), e);
        }
    }

    private void addMixinsNodeType(ExtendedNodeType primaryNodeType, Locale uiLocale, Locale locale, JCRNodeWrapper existingNode, JCRNodeWrapper parentNode, String mode, Map<String, EditorFormSection> formSectionsByName, Set<String> processedProperties, Set<String> processedNodeTypes, SortedSet<EditorFormDefinition> formDefinitionsToMerge) throws RepositoryException {
        if (EDIT.equals(mode)) {
            Set addMixins = Arrays.stream(existingNode.getMixinNodeTypes()).filter(nodetype -> !processedNodeTypes.contains(nodetype.getName())).collect(Collectors.toSet());
            for (ExtendedNodeType addMixin : addMixins) {
                if (processedNodeTypes.contains(addMixin.getName())) continue;
                this.generateAndMergeFieldSetForType(addMixin, uiLocale, locale, existingNode, parentNode, primaryNodeType, formSectionsByName, false, false, true, processedProperties, false);
                processedNodeTypes.add(addMixin.getName());
                Set nodeTypesToProcess = Arrays.stream(addMixin.getSupertypes()).collect(Collectors.toCollection(LinkedHashSet::new));
                for (ExtendedNodeType superType : nodeTypesToProcess) {
                    if (processedNodeTypes.contains(superType.getName())) continue;
                    this.generateAndMergeFieldSetForType(superType, uiLocale, locale, existingNode, parentNode, primaryNodeType, formSectionsByName, false, false, true, processedProperties, false);
                    processedNodeTypes.add(superType.getName());
                }
                formDefinitionsToMerge.addAll(this.staticDefinitionsRegistry.getFormDefinitionsForType(addMixin));
            }
        }
    }

    private boolean shouldHideSection(EditorFormSectionDefinition section, String mode) {
        return section.isHide() || !section.getDisplayModes().isEmpty() && !section.getDisplayModes().contains(mode);
    }

    private void checkIfListOrderingSectionIsRequired(ExtendedNodeType primaryNodeType, JCRNodeWrapper existingNode, Map<String, EditorFormSection> formSectionsByName) throws RepositoryException {
        if (formSectionsByName.containsKey("listOrdering")) {
            return;
        }
        if (primaryNodeType.hasOrderableChildNodes() || existingNode.isNodeType("jmix:orderedList")) {
            EditorFormSection editorFormSection = new EditorFormSection();
            editorFormSection.setName("listOrdering");
            formSectionsByName.put("listOrdering", editorFormSection);
        }
    }

    private void generateAndMergeFieldSetForType(ExtendedNodeType fieldSetNodeType, Locale uiLocale, Locale locale, JCRNodeWrapper existingNode, JCRNodeWrapper parentNode, ExtendedNodeType primaryNodeType, Map<String, EditorFormSection> formSectionsByName, boolean removed, boolean dynamic, boolean activated, Set<String> processedProperties, boolean isForExtendMixin) throws RepositoryException {
        boolean displayFieldSet = !fieldSetNodeType.isNodeType("jmix:templateMixin") || primaryNodeType.isNodeType("jmix:templateMixin");
        EditorFormFieldSet nodeTypeFieldSet = this.generateEditorFormFieldSet(processedProperties, fieldSetNodeType, primaryNodeType, existingNode, parentNode, locale, uiLocale, removed, dynamic, activated, displayFieldSet, isForExtendMixin);
        JCRSiteNode site = existingNode != null ? existingNode.getResolveSite() : parentNode.getResolveSite();
        nodeTypeFieldSet = this.mergeWithStaticFormFieldSets(fieldSetNodeType.getName(), nodeTypeFieldSet, processedProperties, site);
        if (!nodeTypeFieldSet.isRemoved()) {
            this.addFieldSetToSections(formSectionsByName, nodeTypeFieldSet, locale, processedProperties, existingNode, parentNode, primaryNodeType);
        }
    }

    private EditorFormDefinition mergeFormDefinitions(SortedSet<EditorFormDefinition> editorFormDefinitions, JCRSiteNode site) {
        EditorFormDefinition mergedEditorFormDefinition = null;
        for (EditorFormDefinition editorFormDefinition : editorFormDefinitions) {
            if (!this.isApplicable(editorFormDefinition.getOriginBundle(), site)) continue;
            if (mergedEditorFormDefinition == null) {
                mergedEditorFormDefinition = new EditorFormDefinition(editorFormDefinition.getNodeType(), editorFormDefinition.getPriority(), editorFormDefinition.hasPreview(), editorFormDefinition.getSections(), editorFormDefinition.getOriginBundle());
                continue;
            }
            mergedEditorFormDefinition = mergedEditorFormDefinition.mergeWith(editorFormDefinition);
        }
        return mergedEditorFormDefinition != null ? mergedEditorFormDefinition : new EditorFormDefinition();
    }

    private List<EditorFormSection> sortSections(Map<String, EditorFormSection> formSectionsByName, EditorFormDefinition editorFormDefinition, Locale uiLocale, JCRSiteNode site) {
        ArrayList<EditorFormSection> sortedFormSections = new ArrayList<EditorFormSection>();
        if (editorFormDefinition.getSections() == null) {
            return sortedFormSections;
        }
        for (EditorFormSectionDefinition sectionDefinition : editorFormDefinition.getSections()) {
            String description;
            EditorFormSection formSection = formSectionsByName.get(sectionDefinition.getName());
            if (formSection == null) continue;
            String displayName = EditorFormServiceImpl.resolveResourceKey(sectionDefinition.getLabelKey(), uiLocale, site);
            if (displayName != null) {
                formSection.setDisplayName(displayName);
            }
            if ((description = EditorFormServiceImpl.resolveResourceKey(sectionDefinition.getDescriptionKey(), uiLocale, site)) != null) {
                formSection.setDescription(description);
            }
            formSection.setHide(sectionDefinition.isHide());
            formSection.setExpanded(sectionDefinition.expanded());
            for (EditorFormFieldSet formFieldSet : formSection.getFieldSets()) {
                for (EditorFormFieldSet formDefinitionFieldSet : sectionDefinition.getFieldSets()) {
                    String fieldSetDisplayName;
                    if (!formFieldSet.getName().equals(formDefinitionFieldSet.getName())) continue;
                    formFieldSet.setRank(formDefinitionFieldSet.getRank());
                    String key = formDefinitionFieldSet.getDisplayName();
                    if (key != null && formFieldSet.getOriginBundle() != null && !key.contains("@")) {
                        String resourceBundleName = this.jahiaTemplateManagerService.getTemplatePackageById(formFieldSet.getOriginBundle().getSymbolicName()).getResourceBundleName();
                        key = key + "@" + resourceBundleName;
                    }
                    if ((fieldSetDisplayName = EditorFormServiceImpl.resolveResourceKey(key, uiLocale, site)) != null) {
                        formFieldSet.setDisplayName(fieldSetDisplayName);
                        continue;
                    }
                    if (formDefinitionFieldSet.getDisplayName() == null) continue;
                    formFieldSet.setDisplayName(formDefinitionFieldSet.getDisplayName());
                }
            }
            Collections.sort(formSection.getFieldSets());
            sortedFormSections.add(formSection);
        }
        return sortedFormSections;
    }

    private void moveSystemName(List<EditorFormSection> sections, ExtendedNodeType primaryNodeType, JCRNodeWrapper currentNode, Locale locale, String mode, JCRSiteNode site) throws RepositoryException {
        EditorFormSection sectionWithNtBase = sections.stream().filter(s -> s.getFieldSets().stream().anyMatch(fs -> fs.getName().equals("nt:base"))).findFirst().orElse(null);
        if (sectionWithNtBase == null) {
            return;
        }
        EditorFormFieldSet ntBaseFieldSet = sectionWithNtBase.getFieldSets().stream().filter(fs -> fs.getName().equals("nt:base")).findFirst().orElseThrow(() -> new RuntimeException("Could not find nt:base field set"));
        EditorFormField systemNameField = ntBaseFieldSet.getEditorFormFields().stream().filter(ff -> ff.getName().equals("ce:systemName")).findFirst().orElseThrow(() -> new RuntimeException("Could not find ce:systemName field"));
        EditorFormProperty maxLength = new EditorFormProperty();
        maxLength.setName("maxLength");
        maxLength.setValue(String.valueOf(SettingsBean.getInstance().getMaxNameSize()));
        systemNameField.setSelectorOptions(Collections.singletonList(maxLength));
        List<String> readOnlyNodeTypes = Arrays.asList("jnt:group", "jnt:groupsFolder", "jnt:mounts", "jnt:remotePublications", "jnt:modules", "jnt:module", "jnt:moduleVersion", "jnt:templateSets", "jnt:user", "jnt:usersFolder", "jnt:virtualsite", "jnt:virtualsitesFolder");
        List<String> systemNameOnTopNodeTypes = Arrays.asList("jnt:page", "jnt:contentFolder", "jnt:folder", "jnt:file", "jnt:category", "jmix:mainResource");
        Pattern pathPattern = Pattern.compile("^/sites/[^/]*/(contents|files)$");
        if (readOnlyNodeTypes.contains(primaryNodeType.getName()) || EDIT.equals(mode) && currentNode.isNodeType("jmix:systemNameReadonly") || EDIT.equals(mode) && pathPattern.matcher(currentNode.getPath()).matches() || EDIT.equals(mode) && !currentNode.hasPermission("jcr:modifyProperties_default_" + locale.getLanguage()) || JCRContentUtils.isLockedAndCannotBeEdited((JCRNodeWrapper)currentNode)) {
            systemNameField.setReadOnly(true);
        } else {
            systemNameField.setReadOnly(false);
        }
        boolean movedSystemNameField = this.moveSystemNameFieldUnderTitleField(sections, systemNameField);
        if (!movedSystemNameField && systemNameOnTopNodeTypes.contains(primaryNodeType.getName())) {
            movedSystemNameField = this.moveSystemNameToTheTopOfTheForm(sections, systemNameField, primaryNodeType, site);
        }
        if (movedSystemNameField) {
            sectionWithNtBase.getFieldSets().remove(ntBaseFieldSet);
        }
        sections.removeIf(s -> !s.getName().equals("listOrdering") && s.getFieldSets().isEmpty());
    }

    private boolean moveSystemNameFieldUnderTitleField(List<EditorFormSection> sections, EditorFormField systemNameField) {
        boolean moved = false;
        for (EditorFormSection s : sections) {
            for (EditorFormFieldSet fs : s.getFieldSets()) {
                LinkedHashSet<EditorFormField> newSet = new LinkedHashSet<EditorFormField>();
                for (EditorFormField f : fs.getEditorFormFields()) {
                    newSet.add(f);
                    if (!f.getName().equals("jcr:title")) continue;
                    newSet.add(systemNameField);
                    moved = true;
                }
                if (!moved) continue;
                fs.setEditorFormFields(newSet);
                return true;
            }
        }
        return false;
    }

    private boolean moveSystemNameToTheTopOfTheForm(List<EditorFormSection> sections, EditorFormField systemNameField, ExtendedNodeType primaryNodeType, JCRSiteNode site) {
        EditorFormSection contentSection = sections.stream().filter(s -> s.getName().equals(DEFAULT_SECTION)).findFirst().orElse(new EditorFormSection());
        EditorFormFieldSet nodeTypeFiledSet = contentSection.getFieldSets().stream().filter(fs -> fs.getName().equals(primaryNodeType.getName())).findFirst().orElse(new EditorFormFieldSet());
        if (contentSection.getName() == null && !site.hasPermission("viewContentTab")) {
            return false;
        }
        if (contentSection.getName() == null) {
            contentSection.setName(DEFAULT_SECTION);
            sections.add(0, contentSection);
        }
        if (nodeTypeFiledSet.getName() == null) {
            nodeTypeFiledSet.setName(primaryNodeType.getName());
            nodeTypeFiledSet.setDisplayName(primaryNodeType.getLocalName());
            nodeTypeFiledSet.setActivated(true);
            nodeTypeFiledSet.setDisplayed(true);
            nodeTypeFiledSet.setDynamic(false);
            contentSection.getFieldSets().add(0, nodeTypeFiledSet);
        }
        LinkedHashSet<EditorFormField> newSet = new LinkedHashSet<EditorFormField>();
        newSet.add(systemNameField);
        newSet.addAll(nodeTypeFiledSet.getEditorFormFields());
        nodeTypeFiledSet.setEditorFormFields(newSet);
        return true;
    }

    private static String resolveResourceKey(String key, Locale locale, JCRSiteNode site) {
        String value;
        if (key == null || key.isEmpty()) {
            return key;
        }
        logger.debug("Resources key: {}", (Object)key);
        String baseName = null;
        if (key.contains("@")) {
            baseName = StringUtils.substringAfter((String)key, (String)"@");
            key = StringUtils.substringBefore((String)key, (String)"@");
        }
        if ((value = Messages.get((String)baseName, (JahiaTemplatesPackage)(site != null ? site.getTemplatePackage() : null), (String)key, (Locale)locale, null)) == null) {
            value = Messages.getInternal((String)key, (Locale)locale);
        }
        if (value != null && value.startsWith("???") && baseName != null) {
            value = null;
        }
        return value;
    }

    private void addFieldSetToSections(Map<String, EditorFormSection> formSectionsByName, EditorFormFieldSet formFieldSet, Locale locale, Set<String> processedProperties, JCRNodeWrapper existingNode, JCRNodeWrapper parentNode, ExtendedNodeType primaryNodeType) {
        String fieldTargetSectionName;
        if (Boolean.FALSE.equals(formFieldSet.getDynamic()) && formFieldSet.getEditorFormFields().isEmpty()) {
            return;
        }
        ArrayList toBeRemoved = new ArrayList();
        formFieldSet.getEditorFormFields().forEach(editorFormField -> {
            EditorFormSection editorFormSection;
            String fieldSetName = editorFormField.getTarget().getFieldSetName();
            if (editorFormField.getTarget() != null && fieldSetName != null && !fieldSetName.equals(formFieldSet.getName()) && (editorFormSection = (EditorFormSection)formSectionsByName.get(editorFormField.getTarget().getSectionName())) != null) {
                if (fieldSetName.equals("<main>")) {
                    logger.debug("Moving field {} to <main> in fieldset {} of section {}", new Object[]{editorFormField.getName(), editorFormSection.getFieldSets().get(0).getName(), editorFormSection.getName()});
                    editorFormSection.getFieldSets().get(0).getEditorFormFields().add((EditorFormField)editorFormField);
                    toBeRemoved.add(editorFormField);
                } else {
                    editorFormSection.getFieldSets().forEach(editorFormFieldSet -> {
                        if (editorFormFieldSet.getName().equals(fieldSetName)) {
                            logger.debug("Moving field {} to fieldset {} of section {}", new Object[]{editorFormField.getName(), editorFormFieldSet.getName(), editorFormSection.getName()});
                            editorFormFieldSet.getEditorFormFields().add((EditorFormField)editorFormField);
                            toBeRemoved.add(editorFormField);
                        }
                    });
                }
            }
        });
        if (!toBeRemoved.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Removing {} fields from fieldset {}", (Object)toBeRemoved.stream().map(EditorFormField::getName).collect(Collectors.joining(",")), (Object)formFieldSet.getName());
            }
            toBeRemoved.forEach(formFieldSet.getEditorFormFields()::remove);
        }
        ArrayList<EditorFormField> editorFormFieldsToMove = new ArrayList<EditorFormField>();
        for (EditorFormField editorFormField2 : formFieldSet.getEditorFormFields()) {
            fieldTargetSectionName = editorFormField2.getTarget().getFieldSetName();
            if (fieldTargetSectionName == null || fieldTargetSectionName.equals(formFieldSet.getName())) continue;
            editorFormFieldsToMove.add(editorFormField2);
        }
        formFieldSet.getEditorFormFields().removeAll(editorFormFieldsToMove);
        for (EditorFormField editorFormField2 : editorFormFieldsToMove) {
            String fieldTargetFieldSetName;
            fieldTargetSectionName = editorFormField2.getTarget().getSectionName();
            EditorFormSection editorFormSection = this.getTargetSection(formSectionsByName, formFieldSet, fieldTargetSectionName);
            EditorFormFieldSet editorFormFieldSet2 = editorFormSection.getFieldSetByName(fieldTargetFieldSetName = editorFormField2.getTarget().getFieldSetName());
            if (editorFormFieldSet2 != null) continue;
            try {
                ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(fieldTargetFieldSetName, false);
                if (nodeType == null) {
                    logger.warn("Node type {} not found for form {}. Keeping {} field in {} fieldset.", new Object[]{fieldTargetFieldSetName, formFieldSet.getName(), editorFormField2.getName(), formFieldSet.getName()});
                    formFieldSet.getEditorFormFields().add(editorFormField2);
                    continue;
                }
                logger.debug("Moving field {} to new fieldset {} for section {}", new Object[]{editorFormField2, fieldTargetFieldSetName, editorFormSection.getName()});
                editorFormFieldSet2 = new EditorFormFieldSet();
                editorFormFieldSet2.setName(fieldTargetFieldSetName);
                editorFormFieldSet2.setDisplayName(nodeType.getLabel(locale));
                editorFormFieldSet2.setOriginBundle(formFieldSet.getOriginBundle());
                editorFormSection.getFieldSets().add(editorFormFieldSet2);
                editorFormFieldSet2.addField(editorFormField2);
                if (editorFormField2.getExtendedPropertyDefinition() == null) continue;
                processedProperties.add(editorFormField2.getName());
            }
            catch (NoSuchNodeTypeException ex) {
                logger.error(String.format("Impossible to retrieve display name for %s", fieldTargetFieldSetName), (Throwable)ex);
            }
        }
        String formFieldSetTargetSectionName = this.resolveMainSectionName(formFieldSet);
        EditorFormSection formFieldSetTargetSection = this.getTargetSection(formSectionsByName, formFieldSet, formFieldSetTargetSectionName);
        EditorFormFieldSet existingFieldSet = formFieldSetTargetSection.getFieldSetByName(formFieldSet.getName());
        if (existingFieldSet == null) {
            formFieldSetTargetSection.getFieldSets().add(formFieldSet);
        } else {
            logger.debug("Fieldset {} already exists in section {} we need to merge the fields", (Object)formFieldSet.getName(), (Object)formFieldSetTargetSection.getName());
            LinkedHashSet<EditorFormField> mergedEditorFormFields = new LinkedHashSet<EditorFormField>();
            existingFieldSet.getEditorFormFields().forEach(editorFormField -> {
                EditorFormField f = formFieldSet.getFieldByName(editorFormField.getName());
                if (f != null) {
                    EditorFormField mergedWith = f.mergeWith((EditorFormField)editorFormField);
                    logger.debug("Merging field {} with {}", (Object)f, editorFormField);
                    mergedEditorFormFields.add(mergedWith);
                }
            });
            existingFieldSet.setEditorFormFields(mergedEditorFormFields);
        }
        formFieldSetTargetSection.getFieldSets().forEach(editorFormFieldSet -> {
            try {
                this.processValueConstraints((EditorFormFieldSet)editorFormFieldSet, locale, existingNode, parentNode, primaryNodeType);
            }
            catch (RepositoryException e) {
                logger.error("Error while processing value constraints for {}", editorFormFieldSet, (Object)e);
            }
        });
    }

    private EditorFormSection getTargetSection(Map<String, EditorFormSection> formSectionsByName, EditorFormFieldSet formFieldSet, String targetSectionName) {
        EditorFormSection targetSection = formSectionsByName.get(targetSectionName);
        if (targetSection == null) {
            Double targetSectionRank = 1.0;
            Double targetSectionPriority = 1.0;
            targetSection = new EditorFormSection(targetSectionName, targetSectionName, null, targetSectionRank, targetSectionPriority, new ArrayList<EditorFormFieldSet>(), false);
        }
        if (formFieldSet.getRank().compareTo(0.0) == 0) {
            formFieldSet.setRank((double)targetSection.getFieldSets().size() + 1.0);
        }
        formSectionsByName.put(targetSection.getName(), targetSection);
        return targetSection;
    }

    private String resolveMainSectionName(EditorFormFieldSet fieldSet) {
        String targetSectionName = fieldSet.getTarget().getSectionName() != null ? fieldSet.getTarget().getSectionName() : DEFAULT_SECTION;
        for (EditorFormField field : fieldSet.getEditorFormFields()) {
            EditorFormFieldTarget sectionTarget = field.getTarget();
            if (sectionTarget == null || sectionTarget.getSectionName() == null) continue;
            targetSectionName = sectionTarget.getSectionName();
            break;
        }
        return targetSectionName;
    }

    private void processValueConstraints(EditorFormFieldSet editorFormFieldSet, Locale locale, JCRNodeWrapper existingNode, JCRNodeWrapper parentNode, ExtendedNodeType primaryNodeType) throws RepositoryException {
        for (EditorFormField editorFormField : editorFormFieldSet.getEditorFormFields()) {
            List<EditorFormFieldValueConstraint> valueConstraints = this.getValueConstraints(primaryNodeType, editorFormField, existingNode, parentNode, locale, new HashMap<String, Object>());
            editorFormField.setValueConstraints(valueConstraints);
        }
    }

    private EditorFormFieldSet mergeWithStaticFormFieldSets(String nodeTypeName, EditorFormFieldSet mergedEditorFormFieldSet, Set<String> processedProperties, JCRSiteNode site) {
        SortedSet<EditorFormFieldSet> staticEditorFormFieldSets = this.staticDefinitionsRegistry.getFormFieldSets(nodeTypeName);
        if (staticEditorFormFieldSets == null) {
            return mergedEditorFormFieldSet;
        }
        for (EditorFormFieldSet staticEditorFormFieldSet : staticEditorFormFieldSets) {
            if (!this.isApplicable(staticEditorFormFieldSet.getOriginBundle(), site)) continue;
            mergedEditorFormFieldSet = mergedEditorFormFieldSet.mergeWith(staticEditorFormFieldSet, processedProperties);
        }
        return mergedEditorFormFieldSet;
    }

    private EditorFormField mergeWithStaticFormField(String nodeType, EditorFormField editorFormField) {
        SortedSet<EditorFormFieldSet> staticEditorFormFieldSets = this.staticDefinitionsRegistry.getFormFieldSets(nodeType);
        block0: for (EditorFormFieldSet editorFormFieldSet : staticEditorFormFieldSets == null ? Collections.emptyList() : staticEditorFormFieldSets) {
            for (EditorFormField field : editorFormFieldSet.getEditorFormFields()) {
                if (!field.getName().equals(editorFormField.getName())) continue;
                editorFormField = editorFormField.mergeWith(field);
                continue block0;
            }
        }
        return editorFormField;
    }

    private EditorFormFieldSet generateEditorFormFieldSet(Set<String> processedProperties, ExtendedNodeType nodeType, ExtendedNodeType primaryNodeType, JCRNodeWrapper existingNode, JCRNodeWrapper parentNode, Locale locale, Locale uiLocale, Boolean removed, Boolean dynamic, Boolean activated, Boolean displayed, Boolean isForExtendMixin) throws RepositoryException {
        boolean isLockedAndCannotBeEdited = JCRContentUtils.isLockedAndCannotBeEdited((JCRNodeWrapper)existingNode);
        boolean fieldSetEditable = existingNode == null || !isLockedAndCannotBeEdited && existingNode.hasPermission("jcr:nodeTypeManagement");
        TreeSet<EditorFormField> editorFormFields = new TreeSet<EditorFormField>();
        HashMap<String, Double> maxTargetRank = new HashMap<String, Double>();
        List itemDefinitions = isForExtendMixin != false ? nodeType.getItems() : nodeType.getDeclaredItems(true);
        for (ExtendedItemDefinition itemDefinition : itemDefinitions) {
            if (itemDefinition.isNode() || itemDefinition.isHidden() || itemDefinition.isUnstructured() || processedProperties.contains(itemDefinition.getName())) {
                processedProperties.add(itemDefinition.getName());
                continue;
            }
            String itemType = itemDefinition.getItemType();
            Double rank = (Double)maxTargetRank.get(itemType);
            if (rank == null) {
                rank = -1.0;
            }
            Double d = rank;
            Double d2 = rank = Double.valueOf(rank + 1.0);
            maxTargetRank.put(itemType, rank);
            EditorFormField editorFormField = this.generateEditorFormField(itemDefinition, primaryNodeType, existingNode, parentNode, uiLocale, locale, rank);
            if (isForExtendMixin.booleanValue()) {
                editorFormField.getTarget().setFieldSetName(nodeType.getName());
            }
            editorFormFields.add(editorFormField);
            if (dynamic.booleanValue()) continue;
            processedProperties.add(itemDefinition.getName());
        }
        String displayName = StringEscapeUtils.unescapeHtml((String)nodeType.getLabel(uiLocale));
        String description = Sanitizers.FORMATTING.sanitize(nodeType.getDescription(uiLocale));
        EditorFormFieldSet fieldset = new EditorFormFieldSet(nodeType.getName(), displayName, description, removed, dynamic, activated, displayed, !fieldSetEditable, editorFormFields);
        fieldset.setTarget(new EditorFormFieldTarget(nodeType.getItemsType(), nodeType.getName(), -0.1));
        return fieldset;
    }

    private EditorFormField generateEditorFormField(ExtendedItemDefinition itemDefinition, ExtendedNodeType primaryNodeType, JCRNodeWrapper existingNode, JCRNodeWrapper parentNode, Locale uiLocale, Locale locale, Double rank) throws RepositoryException {
        ExtendedNodeType extendedNodeType;
        Optional<ExtendedItemDefinition> optionalItem;
        JCRSessionWrapper session = existingNode != null ? existingNode.getSession() : parentNode.getSession();
        boolean isLockedAndCannotBeEdited = JCRContentUtils.isLockedAndCannotBeEdited((JCRNodeWrapper)existingNode);
        boolean sharedFieldsEditable = existingNode == null || !isLockedAndCannotBeEdited && existingNode.hasPermission("jcr:modifyProperties");
        boolean i18nFieldsEditable = existingNode == null || !isLockedAndCannotBeEdited && existingNode.hasPermission("jcr:modifyProperties_" + session.getWorkspace().getName() + "_" + locale.toString());
        ExtendedPropertyDefinition propertyDefinition = (ExtendedPropertyDefinition)itemDefinition;
        ExtendedNodeType declaringNodeType = propertyDefinition.getDeclaringNodeType();
        EditorFormFieldTarget fieldTarget = new EditorFormFieldTarget(propertyDefinition.getItemType(), declaringNodeType.getName(), rank);
        ArrayList<EditorFormFieldValueConstraint> valueConstraints = new ArrayList<EditorFormFieldValueConstraint>();
        for (String valueConstraint : propertyDefinition.getValueConstraints()) {
            if (propertyDefinition.getSelector() == 14 && (propertyDefinition.getRequiredType() == 4 || propertyDefinition.getRequiredType() == 3 || propertyDefinition.getRequiredType() == 12)) {
                try {
                    Matcher rangeMatcher = RANGE_PATTERN.matcher(valueConstraint);
                    if (rangeMatcher.matches()) {
                        valueConstraint = rangeMatcher.group(2);
                    }
                    if (propertyDefinition.getRequiredType() == 3) {
                        valueConstraint = Long.toString(Double.valueOf(valueConstraint).longValue());
                    }
                }
                catch (Exception rangeMatcher) {
                    // empty catch block
                }
            }
            valueConstraints.add(new EditorFormFieldValueConstraint(valueConstraint, null, new EditorFormFieldValue("String", valueConstraint), null));
        }
        ArrayList<EditorFormProperty> selectorOptions = null;
        if (propertyDefinition.getSelectorOptions() != null) {
            selectorOptions = new ArrayList<EditorFormProperty>();
            for (Map.Entry selectorOptionsEntry : propertyDefinition.getSelectorOptions().entrySet()) {
                selectorOptions.add(new EditorFormProperty((String)selectorOptionsEntry.getKey(), (String)selectorOptionsEntry.getValue()));
            }
        }
        ArrayList<EditorFormFieldValue> defaultValues = null;
        if (propertyDefinition.getDefaultValues() != null) {
            defaultValues = new ArrayList<EditorFormFieldValue>();
            for (Value defaultValue : propertyDefinition.getDefaultValues(locale)) {
                try {
                    defaultValues.add(new EditorFormFieldValue(defaultValue));
                }
                catch (RepositoryException e) {
                    logger.error("Error converting field " + propertyDefinition.getName() + " default value", (Throwable)e);
                }
            }
        }
        ArrayList<EditorFormFieldValue> currentValues = null;
        if (existingNode != null && existingNode.hasProperty(propertyDefinition.getName())) {
            currentValues = new ArrayList<EditorFormFieldValue>();
            JCRPropertyWrapper existingProperty = existingNode.getProperty(propertyDefinition.getName());
            if (existingProperty != null && existingProperty.getDefinition().equals(propertyDefinition)) {
                if (propertyDefinition.isMultiple()) {
                    for (JCRValueWrapper value : existingProperty.getValues()) {
                        currentValues.add(new EditorFormFieldValue((Value)value));
                    }
                } else {
                    currentValues.add(new EditorFormFieldValue((Value)existingProperty.getValue()));
                }
            }
        }
        ExtendedPropertyDefinition item2 = (optionalItem = (extendedNodeType = NodeTypeRegistry.getInstance().getNodeType(propertyDefinition.getDeclaringNodeType().getAlias())).getItems().stream().filter(item -> StringUtils.equals((String)item.getName(), (String)propertyDefinition.getName())).findAny()).isPresent() ? optionalItem.get() : propertyDefinition;
        String propertyLabel = StringEscapeUtils.unescapeHtml((String)item2.getLabel(uiLocale, primaryNodeType));
        String propertyDescription = Sanitizers.FORMATTING.sanitize(item2.getTooltip(uiLocale, primaryNodeType));
        propertyLabel = StringUtils.isEmpty((String)propertyLabel) ? StringEscapeUtils.unescapeHtml((String)item2.getLabel(uiLocale, extendedNodeType)) : propertyLabel;
        propertyDescription = StringUtils.isEmpty((String)propertyDescription) ? Sanitizers.FORMATTING.sanitize(item2.getTooltip(uiLocale, extendedNodeType)) : propertyDescription;
        String key = itemDefinition.getResourceBundleKey() + ".constraint.error.message";
        if (itemDefinition.getDeclaringNodeType().getTemplatePackage() != null) {
            key = key + "@" + itemDefinition.getDeclaringNodeType().getTemplatePackage().getResourceBundleName();
        }
        String propertyErrorMessage = EditorFormServiceImpl.resolveResourceKey(key, uiLocale, parentNode.getResolveSite());
        String selectorType = SelectorType.nameFromValue((int)propertyDefinition.getSelector());
        if (selectorType == null) {
            if (defaultSelectors.containsKey(propertyDefinition.getRequiredType())) {
                selectorType = SelectorType.nameFromValue((int)defaultSelectors.get(propertyDefinition.getRequiredType()));
            } else {
                logger.warn("Couldn't resolve a default selector type for property " + propertyDefinition.getName());
            }
        }
        GqlJcrPropertyType requiredType = GqlJcrPropertyType.fromValue((int)propertyDefinition.getRequiredType());
        EditorFormField field = new EditorFormField();
        field.setName(propertyDefinition.getName());
        field.setDisplayName(propertyLabel);
        field.setDescription(propertyDescription);
        field.setErrorMessage(propertyErrorMessage);
        field.setRequiredType(requiredType);
        field.setSelectorType(selectorType);
        field.setSelectorOptions(selectorOptions);
        field.setI18n(propertyDefinition.isInternationalized());
        field.setReadOnly(this.isFieldReadOnly(propertyDefinition, sharedFieldsEditable, i18nFieldsEditable));
        field.setMultiple(propertyDefinition.isMultiple());
        field.setMandatory(propertyDefinition.isMandatory());
        field.setValueConstraints(valueConstraints);
        field.setDefaultValues(defaultValues);
        field.setCurrentValues(currentValues);
        field.setRemoved(null);
        field.setTarget(fieldTarget);
        field.setExtendedPropertyDefinition(propertyDefinition);
        field.setDeclaringNodeType(propertyDefinition.getDeclaringNodeType().getName());
        return field;
    }

    private List<EditorFormFieldValueConstraint> getValueConstraints(ExtendedNodeType primaryNodeType, EditorFormField editorFormField, JCRNodeWrapper existingNode, JCRNodeWrapper parentNode, Locale locale, Map<String, Object> extendContext) throws RepositoryException {
        List<EditorFormProperty> selectorOptions;
        ExtendedPropertyDefinition propertyDefinition = editorFormField.getExtendedPropertyDefinition();
        if (propertyDefinition != null && propertyDefinition.getSelector() == 14 && !(selectorOptions = editorFormField.getSelectorOptions()).isEmpty()) {
            logger.debug("Processing choice list values for property {}", (Object)editorFormField);
            Map initializers = this.choiceListInitializerService.getInitializers();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("contextType", primaryNodeType);
            context.put("contextNode", existingNode);
            context.put("contextParent", parentNode);
            context.putAll(extendContext);
            List initialChoiceListValues = new ArrayList();
            for (EditorFormProperty selectorProperty : selectorOptions) {
                if (!initializers.containsKey(selectorProperty.getName())) continue;
                initialChoiceListValues = ((ChoiceListInitializer)initializers.get(selectorProperty.getName())).getChoiceListValues(propertyDefinition, selectorProperty.getValue(), initialChoiceListValues, locale, context);
            }
            ArrayList<EditorFormFieldValueConstraint> valueConstraints = new ArrayList<EditorFormFieldValueConstraint>();
            for (ChoiceListValue choiceListValue : initialChoiceListValues) {
                ArrayList<EditorFormProperty> propertyList = new ArrayList<EditorFormProperty>();
                if (choiceListValue.getProperties() != null) {
                    for (Map.Entry choiceListPropertyEntry : choiceListValue.getProperties().entrySet()) {
                        propertyList.add(new EditorFormProperty((String)choiceListPropertyEntry.getKey(), choiceListPropertyEntry.getValue().toString()));
                    }
                }
                try {
                    valueConstraints.add(new EditorFormFieldValueConstraint(choiceListValue.getDisplayName(), null, new EditorFormFieldValue(choiceListValue.getValue()), propertyList));
                }
                catch (RepositoryException e) {
                    logger.error("Error retrieving choice list value", (Throwable)e);
                }
            }
            return valueConstraints;
        }
        return editorFormField.getValueConstraints();
    }

    private boolean isFieldReadOnly(ExtendedPropertyDefinition propertyDefinition, boolean sharedFieldsEditable, boolean i18nFieldsEditable) {
        if (propertyDefinition.isProtected()) {
            return true;
        }
        return propertyDefinition.isInternationalized() ? !i18nFieldsEditable : !sharedFieldsEditable;
    }

    private JCRSessionWrapper getSession(Locale locale, String uuidOrPath) throws RepositoryException {
        Locale fallbackLocale = (Locale)JCRTemplate.getInstance().doExecuteWithSystemSession(jcrSessionWrapper -> {
            JCRNodeWrapper node = StringUtils.startsWith((String)uuidOrPath, (String)"/") ? jcrSessionWrapper.getNode(uuidOrPath) : jcrSessionWrapper.getNodeByIdentifier(uuidOrPath);
            JCRSiteNode site = node.getResolveSite();
            if (site != null && site.isMixLanguagesActive()) {
                return LanguageCodeConverters.getLocaleFromCode((String)site.getDefaultLanguage());
            }
            return null;
        });
        return JCRSessionFactory.getInstance().getCurrentUserSession("default", locale, fallbackLocale);
    }

    private List<ExtendedNodeType> getExtendMixins(ExtendedNodeType type, JCRSiteNode site) throws NoSuchNodeTypeException {
        ArrayList<ExtendedNodeType> res = new ArrayList<ExtendedNodeType>();
        Set installedModules = site != null && site.getPath().startsWith("/sites/") ? site.getInstalledModulesWithAllDependencies() : null;
        Map m = NodeTypeRegistry.getInstance().getMixinExtensions();
        for (ExtendedNodeType nodeType : m.keySet()) {
            if (!type.isNodeType(nodeType.getName())) continue;
            for (ExtendedNodeType extension : (Set)m.get(nodeType)) {
                if (installedModules != null && extension.getTemplatePackage() != null && !extension.getTemplatePackage().getModuleType().equalsIgnoreCase("system") && !installedModules.contains(extension.getTemplatePackage().getId())) continue;
                res.add(extension);
            }
        }
        return res;
    }

    boolean isApplicable(Bundle bundle, JCRSiteNode site) {
        JahiaTemplatesPackage tpl = this.jahiaTemplateManagerService.getTemplatePackageById(bundle.getSymbolicName());
        if ("system".equals(tpl.getModuleType())) {
            return true;
        }
        return site.getInstalledModulesWithAllDependencies().contains(bundle.getSymbolicName());
    }

    static {
        defaultSelectors.put(1, 1);
        defaultSelectors.put(3, 1);
        defaultSelectors.put(4, 1);
        defaultSelectors.put(5, 3);
        defaultSelectors.put(6, 11);
        defaultSelectors.put(7, 1);
        defaultSelectors.put(8, 1);
        defaultSelectors.put(10, 9);
        defaultSelectors.put(12, 1);
        defaultSelectors.put(11, 1);
        defaultSelectors.put(9, 9);
        defaultSelectors.put(2, 1);
        PUBLISHED_TECHNICAL_NODES = Arrays.asList("vanityUrlMapping", "j:conditionalVisibility");
    }
}

