/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.api.forms.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.contenteditor.api.forms.EditorFormDefinition;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldSet;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={StaticDefinitionsRegistry.class})
public class StaticDefinitionsRegistry
implements SynchronousBundleListener {
    private static final Logger logger = LoggerFactory.getLogger(StaticDefinitionsRegistry.class);
    private Map<Bundle, List<EditorFormDefinition>> staticEditorFormDefinitionsByBundle = new LinkedHashMap<Bundle, List<EditorFormDefinition>>();
    private Map<String, SortedSet<EditorFormDefinition>> staticEditorFormDefinitionsByName = new LinkedHashMap<String, SortedSet<EditorFormDefinition>>();
    private Map<Bundle, List<EditorFormFieldSet>> staticEditorFormFieldSetsByBundle = new LinkedHashMap<Bundle, List<EditorFormFieldSet>>();
    private Map<String, SortedSet<EditorFormFieldSet>> staticEditorFormFieldSetsByName = new LinkedHashMap<String, SortedSet<EditorFormFieldSet>>();
    private ObjectMapper objectMapper = new ObjectMapper();
    private BundleContext bundleContext;

    @Activate
    public void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this.bundleContext = bundleContext;
        for (Bundle bundle : bundleContext.getBundles()) {
            if (bundle.getBundleContext() == null) continue;
            this.registerStaticEditorFormFieldSets(bundle);
            this.registerStaticEditorFormDefinitions(bundle);
        }
        bundleContext.addBundleListener((BundleListener)this);
    }

    @Deactivate
    public void deactivate() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: {
                this.registerStaticEditorFormFieldSets(event.getBundle());
                this.registerStaticEditorFormDefinitions(event.getBundle());
                break;
            }
            case 4: {
                this.unregisterStaticEditorFormFieldSets(event.getBundle());
                this.unregisterStaticEditorFormDefinitions(event.getBundle());
            }
        }
    }

    SortedSet<EditorFormFieldSet> getFormFieldSets(String name) {
        return this.staticEditorFormFieldSetsByName.get(name);
    }

    SortedSet<EditorFormDefinition> getFormDefinitions(String name) {
        return this.staticEditorFormDefinitionsByName.get(name);
    }

    SortedSet<EditorFormDefinition> getFormDefinitionsForType(ExtendedNodeType type) {
        TreeSet<EditorFormDefinition> editorFormDefinitions = new TreeSet<EditorFormDefinition>();
        this.staticEditorFormDefinitionsByName.forEach((nodeType, definitions) -> {
            if (type.isNodeType(nodeType)) {
                editorFormDefinitions.addAll((Collection<EditorFormDefinition>)definitions);
            }
        });
        return editorFormDefinitions;
    }

    private void registerStaticEditorFormFieldSets(Bundle bundle) {
        if (bundle.getBundleContext() == null) {
            return;
        }
        Enumeration editorFormURLs = bundle.findEntries("META-INF/jahia-content-editor-forms/fieldsets", "*.json", true);
        if (editorFormURLs == null) {
            return;
        }
        ArrayList<EditorFormFieldSet> bundleEditorFormFieldSets = new ArrayList<EditorFormFieldSet>();
        while (editorFormURLs.hasMoreElements()) {
            URL editorFormURL = (URL)editorFormURLs.nextElement();
            EditorFormFieldSet editorFormFieldSet = this.readEditorFormFieldSet(editorFormURL);
            if (editorFormFieldSet == null) continue;
            editorFormFieldSet.setOriginBundle(bundle);
            bundleEditorFormFieldSets.add(editorFormFieldSet);
        }
        this.staticEditorFormFieldSetsByBundle.put(bundle, bundleEditorFormFieldSets);
    }

    EditorFormFieldSet readEditorFormFieldSet(URL editorFormURL) {
        EditorFormFieldSet editorFormFieldSet = null;
        try {
            editorFormFieldSet = (EditorFormFieldSet)this.objectMapper.readValue(editorFormURL, EditorFormFieldSet.class);
            String name = editorFormFieldSet.getName();
            if (StringUtils.isNotBlank((String)name)) {
                SortedSet<EditorFormFieldSet> editorFormFieldSets = this.staticEditorFormFieldSetsByName.get(name);
                if (editorFormFieldSets == null) {
                    editorFormFieldSets = new TreeSet<EditorFormFieldSet>();
                }
                editorFormFieldSets.add(editorFormFieldSet);
                this.staticEditorFormFieldSetsByName.put(name, editorFormFieldSets);
                logger.info("Successfully loaded static fieldSets for name {} from {}", (Object)name, (Object)editorFormURL);
            } else {
                logger.error("Could not serialize the object with the {} from {}", EditorFormFieldSet.class, (Object)editorFormURL);
            }
        }
        catch (IOException e) {
            logger.error("Error loading editor form from " + editorFormURL, (Throwable)e);
        }
        return editorFormFieldSet;
    }

    private void unregisterStaticEditorFormFieldSets(Bundle bundle) {
        List<EditorFormFieldSet> bundleEditorFormFieldSets = this.staticEditorFormFieldSetsByBundle.remove(bundle);
        if (bundleEditorFormFieldSets == null) {
            return;
        }
        for (EditorFormFieldSet bundleEditorFormFieldSet : bundleEditorFormFieldSets) {
            SortedSet<EditorFormFieldSet> nodeTypeEditorFormFieldSets = this.staticEditorFormFieldSetsByName.get(bundleEditorFormFieldSet.getName());
            if (nodeTypeEditorFormFieldSets == null) continue;
            nodeTypeEditorFormFieldSets.remove(bundleEditorFormFieldSet);
            this.staticEditorFormFieldSetsByName.put(bundleEditorFormFieldSet.getName(), nodeTypeEditorFormFieldSets);
        }
    }

    private void registerStaticEditorFormDefinitions(Bundle bundle) {
        if (bundle.getBundleContext() == null) {
            return;
        }
        Enumeration editorFormURLs = bundle.findEntries("META-INF/jahia-content-editor-forms/forms", "*.json", true);
        if (editorFormURLs == null) {
            return;
        }
        ArrayList<EditorFormDefinition> bundleEditorFormDefinitions = new ArrayList<EditorFormDefinition>();
        while (editorFormURLs.hasMoreElements()) {
            URL editorFormURL = (URL)editorFormURLs.nextElement();
            EditorFormDefinition editorFormDefinition = this.readEditorFormDefinition(editorFormURL, bundle);
            if (editorFormDefinition == null) continue;
            bundleEditorFormDefinitions.add(editorFormDefinition);
        }
        this.staticEditorFormDefinitionsByBundle.put(bundle, bundleEditorFormDefinitions);
    }

    EditorFormDefinition readEditorFormDefinition(URL editorFormURL, Bundle bundle) {
        EditorFormDefinition editorFormDefinition = null;
        try {
            editorFormDefinition = (EditorFormDefinition)this.objectMapper.readValue(editorFormURL, EditorFormDefinition.class);
            editorFormDefinition.setOriginBundle(bundle);
            String name = editorFormDefinition.getNodeType();
            if (StringUtils.isNotBlank((String)name)) {
                SortedSet<EditorFormDefinition> editorFormDefinitions = this.staticEditorFormDefinitionsByName.get(name);
                if (editorFormDefinitions == null) {
                    editorFormDefinitions = new TreeSet<EditorFormDefinition>();
                }
                editorFormDefinitions.add(editorFormDefinition);
                this.staticEditorFormDefinitionsByName.put(name, editorFormDefinitions);
                logger.info("Successfully loaded static form for name {} from {}", (Object)name, (Object)editorFormURL);
            } else {
                logger.error("Could not serialize the object with the {} from {}", EditorFormDefinition.class, (Object)editorFormURL);
            }
        }
        catch (IOException e) {
            logger.error("Error loading editor form from " + editorFormURL, (Throwable)e);
        }
        return editorFormDefinition;
    }

    private void unregisterStaticEditorFormDefinitions(Bundle bundle) {
        List<EditorFormDefinition> bundleEditorFormDefinitions = this.staticEditorFormDefinitionsByBundle.remove(bundle);
        if (bundleEditorFormDefinitions == null) {
            return;
        }
        for (EditorFormDefinition bundleEditorFormDefinition : bundleEditorFormDefinitions) {
            SortedSet<EditorFormDefinition> editorFormDefinitions = this.staticEditorFormDefinitionsByName.get(bundleEditorFormDefinition.getNodeType());
            if (editorFormDefinitions == null) continue;
            editorFormDefinitions.remove(bundleEditorFormDefinition);
            this.staticEditorFormDefinitionsByName.put(bundleEditorFormDefinition.getNodeType(), editorFormDefinitions);
        }
    }
}

