/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.api.lock;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import org.apache.commons.lang3.StringUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingBiFunction;
import pl.touk.throwing.ThrowingConsumer;
import pl.touk.throwing.exception.WrappedException;

public class StaticEditorLockService {
    private static final Logger logger = LoggerFactory.getLogger(StaticEditorLockService.class);
    private static final String LOCK_TYPE = "engine";
    private static final Map<String, LockDetails> holdLocks = new ConcurrentHashMap<String, LockDetails>();
    private static final Map<String, Set<String>> locksByUuid = new ConcurrentHashMap<String, Set<String>>();

    public static boolean tryLock(String uuid, String lockId) throws RepositoryException {
        JCRSessionFactory jcrSessionFactory = JCRSessionFactory.getInstance();
        JahiaUser currentUser = jcrSessionFactory.getCurrentUser();
        JCRSessionWrapper sessionWrapper = jcrSessionFactory.getCurrentUserSession("default");
        JCRNodeWrapper node = sessionWrapper.getNodeByIdentifier(uuid);
        logger.debug("Trying to add lock {} on node {}", (Object)lockId, (Object)uuid);
        try {
            LockDetails r = holdLocks.compute(lockId, (k, lockDetails) -> {
                if (node.getProvider().isLockingAvailable() && node.hasPermission("{http://www.jcp.org/jcr/1.0}lockManagement")) {
                    locksByUuid.compute(uuid, ThrowingBiFunction.unchecked((lockedIdentifier, locks) -> {
                        if (locks == null) {
                            locks = new HashSet<String>();
                        }
                        if (locks.isEmpty()) {
                            logger.debug("Locking node {}", lockedIdentifier);
                            node.lockAndStoreToken(LOCK_TYPE);
                            for (String lockToken : sessionWrapper.getLockTokens()) {
                                sessionWrapper.removeLockToken(lockToken);
                            }
                        }
                        locks.add(lockId);
                        logger.debug("Locks set on node {} : {}", lockedIdentifier, locks);
                        return locks;
                    }));
                    return new LockDetails(currentUser, uuid);
                }
                return lockDetails;
            });
            return r != null && currentUser.equals(r.user);
        }
        catch (WrappedException e) {
            if (!(e.getCause() instanceof UnsupportedRepositoryOperationException)) {
                StaticEditorLockService.unwrapException(e);
            }
            return false;
        }
    }

    public static void unlock(String lockId) throws RepositoryException {
        try {
            holdLocks.compute(lockId, (k, lockDetails) -> {
                JCRSessionFactory jcrSessionFactory = JCRSessionFactory.getInstance();
                JahiaUser currentUser = jcrSessionFactory.getCurrentUser();
                if (lockDetails == null || !currentUser.equals(lockDetails.user)) {
                    return lockDetails;
                }
                logger.debug("Releasing content editor lock {}", (Object)lockId);
                locksByUuid.compute(lockDetails.uuid, ThrowingBiFunction.unchecked((lockedIdentifier, locks) -> {
                    JCRSessionWrapper sessionWrapper = jcrSessionFactory.getCurrentUserSession("default");
                    if (locks != null) {
                        locks.remove(lockId);
                        logger.debug("Remaining locks on node {} : {}", lockedIdentifier, locks);
                        if (locks.isEmpty()) {
                            locks = null;
                        }
                    }
                    try {
                        String lockOwners;
                        JCRNodeWrapper node = sessionWrapper.getNodeByIdentifier(lockedIdentifier);
                        if (locks == null && node.getProvider().isLockingAvailable() && node.isLocked() && StringUtils.isNotEmpty((CharSequence)(lockOwners = node.getLockOwner())) && Arrays.asList(StringUtils.split((String)lockOwners, (String)" ")).contains(currentUser.getUsername())) {
                            logger.debug("Calling unlock on node {}", lockedIdentifier);
                            node.unlock(LOCK_TYPE);
                        }
                    }
                    catch (LockException e) {
                        logger.warn("Error when releasing lock: {}", (Object)lockId, (Object)e);
                    }
                    return locks;
                }));
                logger.debug("Lock {} released", (Object)lockId);
                return null;
            });
        }
        catch (WrappedException e) {
            StaticEditorLockService.unwrapException(e);
        }
    }

    public static void closeAllRemainingLocks() {
        logger.debug("Releasing all locks for current user");
        holdLocks.keySet().forEach(ThrowingConsumer.unchecked(StaticEditorLockService::unlock));
    }

    private static void unwrapException(WrappedException e) throws RepositoryException {
        if (e.getCause() instanceof RepositoryException) {
            throw (RepositoryException)e.getCause();
        }
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        throw e;
    }

    private static class LockDetails {
        final JahiaUser user;
        final String uuid;

        public LockDetails(JahiaUser user, String uuid) {
            this.user = user;
            this.uuid = uuid;
        }
    }
}

