/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.graphql.api;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.jahia.modules.contenteditor.api.forms.EditorFormException;
import org.jahia.modules.contenteditor.api.forms.EditorFormService;
import org.jahia.modules.contenteditor.api.lock.StaticEditorLockService;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GqlEditorFormMutations {
    private static final Logger logger = LoggerFactory.getLogger(GqlEditorFormMutations.class);
    private EditorFormService editorFormService;

    @Inject
    @GraphQLOsgiService
    public void setEditorFormService(EditorFormService editorFormService) {
        this.editorFormService = editorFormService;
    }

    @GraphQLField
    @GraphQLDescription(value="Unlock the given node for edition, if the node is locked.")
    @GraphQLName(value="unlockEditor")
    public boolean unlockEditor(@GraphQLName(value="editorID") @GraphQLNonNull @GraphQLDescription(value="An ID generated client side used to identify the lock") String editorID) throws EditorFormException {
        try {
            logger.info("Request for lock release {}", (Object)editorID);
            StaticEditorLockService.unlock(editorID);
            return true;
        }
        catch (RepositoryException e) {
            throw new EditorFormException("Unable to unlock content editor", e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Publish the edited node with the associated technical sub nodes (visibility conditions, vanity urls, ACLs)")
    public boolean publishForm(@GraphQLName(value="uuidOrPath") @GraphQLNonNull @GraphQLDescription(value="UUID or path of the edited node.") String uuidOrPath, @GraphQLName(value="locale") @GraphQLNonNull @GraphQLDescription(value="A string representation of a locale, in IETF BCP 47 language tag format, ie en_US, en, fr, fr_CH, ...") String locale) {
        try {
            return this.editorFormService.publishForm(LanguageCodeConverters.getLocaleFromCode((String)locale), uuidOrPath);
        }
        catch (EditorFormException e) {
            throw new DataFetchingException((Throwable)((Object)e));
        }
    }
}

