/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.graphql.api;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.modules.contenteditor.api.forms.EditorForm;
import org.jahia.modules.contenteditor.api.forms.EditorFormDefinition;
import org.jahia.modules.contenteditor.api.forms.EditorFormException;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldValueConstraint;
import org.jahia.modules.contenteditor.api.forms.EditorFormService;
import org.jahia.modules.contenteditor.graphql.api.GqlUtils;
import org.jahia.modules.contenteditor.graphql.api.definitions.GqlNodeTypeTreeEntry;
import org.jahia.modules.contenteditor.graphql.api.types.ContextEntryInput;
import org.jahia.modules.contenteditor.utils.ContentEditorUtils;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.NodeTypeTreeEntry;
import org.jahia.utils.NodeTypesUtils;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GqlEditorForms {
    private static Logger logger = LoggerFactory.getLogger(GqlEditorForms.class);
    private EditorFormService editorFormService;

    @Inject
    @GraphQLOsgiService
    public void setEditorFormService(EditorFormService editorFormService) {
        this.editorFormService = editorFormService;
    }

    @GraphQLField
    @GraphQLName(value="createForm")
    @GraphQLDescription(value="Get a editor form to create a new content from its nodetype and parent")
    public EditorForm getCreateForm(@GraphQLName(value="primaryNodeType") @GraphQLNonNull @GraphQLDescription(value="The primary node type name identifying the form we want to retrieve") String nodeType, @GraphQLName(value="uiLocale") @GraphQLNonNull @GraphQLDescription(value="A string representation of a locale, in IETF BCP 47 language tag format, ie en_US, en, fr, fr_CH, ...") String uiLocale, @GraphQLName(value="locale") @GraphQLNonNull @GraphQLDescription(value="A string representation of a locale, in IETF BCP 47 language tag format, ie en_US, en, fr, fr_CH, ...") String locale, @GraphQLName(value="uuidOrPath") @GraphQLNonNull @GraphQLDescription(value="uuid or path of an existing node under with the new content will be created.") String uuidOrPath) throws EditorFormException {
        return this.editorFormService.getCreateForm(nodeType, LanguageCodeConverters.getLocaleFromCode((String)uiLocale), LanguageCodeConverters.getLocaleFromCode((String)locale), uuidOrPath);
    }

    @GraphQLField
    @GraphQLName(value="editForm")
    @GraphQLDescription(value="Get a editor form from a locale and an existing node")
    public EditorForm getEditForm(@GraphQLName(value="uiLocale") @GraphQLNonNull @GraphQLDescription(value="A string representation of a locale, in IETF BCP 47 language tag format, ie en_US, en, fr, fr_CH, ...") String uiLocale, @GraphQLName(value="locale") @GraphQLNonNull @GraphQLDescription(value="A string representation of a locale, in IETF BCP 47 language tag format, ie en_US, en, fr, fr_CH, ...") String locale, @GraphQLName(value="uuidOrPath") @GraphQLNonNull @GraphQLDescription(value="UUID or path of an existing node under with the new content will be created.") String uuidOrPath) throws EditorFormException {
        return this.editorFormService.getEditForm(LanguageCodeConverters.getLocaleFromCode((String)uiLocale), LanguageCodeConverters.getLocaleFromCode((String)locale), uuidOrPath);
    }

    @GraphQLField
    @GraphQLName(value="fieldConstraints")
    @GraphQLDescription(value="Get field constraints")
    public List<EditorFormFieldValueConstraint> getFieldConstraints(@GraphQLName(value="nodeUuidOrPath") @GraphQLDescription(value="UUID or path of the node (optional in case you are creating it, and it doesnt exist yet)") String nodeUuidOrPath, @GraphQLName(value="parentNodeUuidOrPath") @GraphQLNonNull @GraphQLDescription(value="UUID or path of the parent node") String parentNodeUuidOrPath, @GraphQLName(value="primaryNodeType") @GraphQLNonNull @GraphQLDescription(value="A string representation of the primary node type of the node") String primaryNodeType, @GraphQLName(value="fieldNodeType") @GraphQLNonNull @GraphQLDescription(value="A string representation of the field node type (the node type that contains the field, can be the node type of the node, a mixin or a super type)") String fieldNodeType, @GraphQLName(value="fieldName") @GraphQLNonNull @GraphQLDescription(value="A string representation of field name") String fieldName, @GraphQLName(value="context") @GraphQLDescription(value="Object contains additional information of the node") List<ContextEntryInput> context, @GraphQLName(value="uiLocale") @GraphQLNonNull @GraphQLDescription(value="A string representation of a locale, in IETF BCP 47 language tag format, ie en_US, en, fr, fr_CH, ...") String uiLocale, @GraphQLName(value="locale") @GraphQLNonNull @GraphQLDescription(value="A string representation of a locale, in IETF BCP 47 language tag format, ie en_US, en, fr, fr_CH, ...") String locale) throws EditorFormException {
        return this.editorFormService.getFieldConstraints(nodeUuidOrPath, parentNodeUuidOrPath, primaryNodeType, fieldNodeType, fieldName, context, LanguageCodeConverters.getLocaleFromCode((String)uiLocale), LanguageCodeConverters.getLocaleFromCode((String)locale));
    }

    @GraphQLField
    @GraphQLName(value="contentTypesAsTree")
    @GraphQLDescription(value="Get a list of allowed child nodeTypes for a given nodeType and path. (Note that it returns nothing for type [jnt:page]. [jnt:contentFolder] is filterered by [jmix:editorialContent])")
    public List<GqlNodeTypeTreeEntry> getContentTypesAsTree(@GraphQLName(value="nodeTypes") @GraphQLDescription(value="List of types we want to retrieve, null for all") List<String> nodeTypes, @GraphQLName(value="childNodeName") @GraphQLDescription(value="the child node name, used to check the type allowed for this named child node, do not specify if you want to check for unnamed children") String childNodeName, @GraphQLName(value="excludedNodeTypes") @GraphQLDescription(value="List of types we want to exclude, null for all") List<String> excludedNodeTypes, @GraphQLName(value="includeSubTypes") @GraphQLDefaultValue(value=GqlUtils.SupplierTrue.class) @GraphQLDescription(value="if true, retrieves all the sub types of the given node types, if false, returns the type only. Default value is true") boolean includeSubTypes, @GraphQLName(value="useContribute") @GraphQLDefaultValue(value=GqlUtils.SupplierTrue.class) @GraphQLDescription(value="if true, check the contribute property of the node. Default value is true") boolean useContribute, @GraphQLName(value="nodePath") @GraphQLNonNull @GraphQLDescription(value="thPath of an existing node under with the new content will be created.") String nodePath, @GraphQLName(value="uiLocale") @GraphQLNonNull @GraphQLDescription(value="A string representation of a locale, in IETF BCP 47 language tag format, ie en_US, en, fr, fr_CH, ...") String uiLocale) throws RepositoryException {
        JCRNodeWrapper parentNode = this.getSession().getNode(nodePath);
        if (parentNode.isNodeType("jnt:contentFolder") && (nodeTypes == null || nodeTypes.isEmpty())) {
            nodeTypes = Collections.singletonList("jmix:droppableContent");
        }
        if (!parentNode.hasPermission("jcr:addChildNodes")) {
            return Collections.emptyList();
        }
        String nodeIdentifier = parentNode.getIdentifier();
        Locale locale = LanguageCodeConverters.getLocaleFromCode((String)uiLocale);
        ArrayList<String> allowedNodeTypes = new ArrayList<String>(ContentEditorUtils.getAllowedNodeTypesAsChildNode(parentNode, childNodeName, useContribute, includeSubTypes, nodeTypes));
        Set entries = NodeTypesUtils.getContentTypesAsTree(allowedNodeTypes, excludedNodeTypes, (boolean)includeSubTypes, (String)nodePath, (JCRSessionWrapper)this.getSession(locale), (Locale)locale);
        return entries.stream().map(entry -> new GqlNodeTypeTreeEntry((NodeTypeTreeEntry)entry, nodeIdentifier)).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLName(value="ckeditorConfigPath")
    @GraphQLDescription(value="Retrieve the custom configuration path for CKEditor")
    public String ckeditorConfigPath(@GraphQLName(value="nodePath") @GraphQLDescription(value="node path") String nodePath) throws RepositoryException {
        String configPath;
        try {
            String templatesSet = this.getSession().getNode(nodePath).getResolveSite().getPropertyAsString("j:templatesSet");
            configPath = this.getConfigPath(templatesSet, "/javascript/ckeditor_config.js");
        }
        catch (PathNotFoundException e) {
            configPath = "";
        }
        if (configPath.isEmpty()) {
            configPath = this.getConfigPath("ckeditor", "/javascript/config.js");
        }
        return configPath;
    }

    @GraphQLField
    @GraphQLName(value="ckeditorToolbar")
    @GraphQLDescription(value="Retrieve the toolbar type for CKEditor")
    public String ckeditorToolbar(@GraphQLName(value="nodePath") @GraphQLDescription(value="node path") String nodePath) throws RepositoryException {
        String toolbar = "Light";
        try {
            JCRNodeWrapper node = this.getSession().getNode(nodePath);
            if (node.hasPermission("view-full-wysiwyg-editor")) {
                toolbar = "Full";
            } else if (node.hasPermission("view-basic-wysiwyg-editor")) {
                toolbar = "Basic";
            }
        }
        catch (PathNotFoundException e) {
            logger.debug("Path does not exist {}", (Object)nodePath);
        }
        return toolbar;
    }

    @GraphQLField
    @GraphQLName(value="subContentsCount")
    @GraphQLDescription(value="Retrieve the number of sub contents under the node for given types")
    public Integer subContentsCounts(@GraphQLName(value="nodePath") @GraphQLDescription(value="node path") String nodePath, @GraphQLName(value="includeTypes") @GraphQLDescription(value="List of node types to check for") List<String> nodeTypes, @GraphQLName(value="limit") @GraphQLDescription(value="Limit of sub contents count") Integer limit) throws RepositoryException {
        int count = 0;
        JCRSessionWrapper session = this.getSession();
        JCRNodeWrapper node = session.getNode(nodePath);
        if (!node.hasNodes()) {
            return count;
        }
        QueryManagerWrapper queryManager = session.getWorkspace().getQueryManager();
        for (String type : nodeTypes) {
            count = (int)((long)count + queryManager.createQuery("SELECT count AS [rep:count()] FROM [" + type + "] WHERE isdescendantnode(['" + JCRContentUtils.sqlEncode((String)node.getPath()) + "'])", "JCR-SQL2").execute().getRows().nextRow().getValue("count").getLong());
            if (limit == null || limit <= 0 || count < limit) continue;
            return limit;
        }
        return count;
    }

    @GraphQLField
    @GraphQLName(value="getOverrides")
    @GraphQLDescription(value="Get a list of all the overrides define on the system for a nodetype")
    public SortedSet<EditorFormDefinition> getFormOverrides(@GraphQLName(value="primaryNodeType") @GraphQLNonNull @GraphQLDescription(value="The primary node type name identifying the form we want to retrieve") String nodeType) throws EditorFormException {
        return this.editorFormService.getFormOverrides(nodeType);
    }

    private String getConfigPath(String moduleId, String resource) {
        Bundle ckeditorBundle;
        String configPath = "";
        JahiaTemplatesPackage ckeditorModule = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(moduleId);
        if (ckeditorModule != null && (ckeditorBundle = ckeditorModule.getBundle()) != null && ckeditorBundle.getResource(resource) != null) {
            configPath = "$context" + ckeditorModule.getRootFolderPath() + resource;
        }
        return configPath;
    }

    private JCRSessionWrapper getSession() throws RepositoryException {
        return JCRSessionFactory.getInstance().getCurrentUserSession("default");
    }

    private JCRSessionWrapper getSession(Locale locale) throws RepositoryException {
        if (locale == null) {
            return this.getSession();
        }
        return JCRSessionFactory.getInstance().getCurrentUserSession("default", locale);
    }
}

