/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.graphql.api;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import javax.jcr.RepositoryException;
import org.jahia.bin.filters.jcr.JcrSessionFilter;
import org.jahia.modules.contenteditor.api.forms.EditorFormException;
import org.jahia.modules.contenteditor.api.lock.StaticEditorLockService;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLProvider;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutationSupport;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.usermanager.JahiaUser;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLTypeExtension(value=DXGraphQLProvider.Subscription.class)
public class GqlEditorSubscriptions
extends GqlJcrMutationSupport {
    private static final Logger logger = LoggerFactory.getLogger(GqlEditorSubscriptions.class);

    @GraphQLField
    @GraphQLDescription(value="Lock the node for edition and subscribe to hold the lock. The node is automatically unlocked when the client disconnect or close the connection")
    public static Publisher<String> subscribeToEditorLock(@GraphQLName(value="nodeId") @GraphQLNonNull @GraphQLDescription(value="Uuid of the node to be locked.") String uuid, @GraphQLName(value="editorID") @GraphQLNonNull @GraphQLDescription(value="An ID generated client side used to identify the lock") String editorID) throws EditorFormException {
        JCRSessionFactory jcrSessionFactory = JCRSessionFactory.getInstance();
        JahiaUser currentUser = jcrSessionFactory.getCurrentUser();
        try {
            if (!StaticEditorLockService.tryLock(uuid, editorID)) {
                return null;
            }
        }
        catch (RepositoryException e) {
            throw new EditorFormException("Unable to lock node: " + uuid, e);
        }
        return Flowable.create(obs -> obs.setCancellable(() -> {
            logger.info("Connection lost or closed, unlock the node");
            try {
                JCRSessionFactory.getInstance().setCurrentUser(currentUser);
                StaticEditorLockService.unlock(editorID);
            }
            finally {
                JcrSessionFilter.endRequest();
            }
        }), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }
}

