/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.graphql.extensions;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.utils.LanguageCodeConverters;

@GraphQLTypeExtension(value=GqlJcrNode.class)
public class JCRNodeContentEditorExtensions {
    private GqlJcrNode node;

    public JCRNodeContentEditorExtensions(GqlJcrNode node) {
        this.node = node;
    }

    @GraphQLField
    @GraphQLDescription(value="Returns edit lock status of the current node object")
    public boolean isLockedAndCannotBeEdited() {
        try {
            return JCRContentUtils.isLockedAndCannotBeEdited((JCRNodeWrapper)this.node.getNode());
        }
        catch (RepositoryException e) {
            throw new DataFetchingException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLName(value="findAvailableNodeName")
    @GraphQLDescription(value="Returns the next available name for a node, appending if needed numbers.")
    public String findAvailableNodeName(@GraphQLName(value="nodeType") String nodeTypeName, @GraphQLName(value="language") String language) {
        try {
            ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(nodeTypeName);
            return JCRContentUtils.findAvailableNodeName((Node)this.node.getNode(), (String)JCRContentUtils.generateNodeName((String)nodeType.getLabel(LanguageCodeConverters.languageCodeToLocale((String)language))));
        }
        catch (RepositoryException e) {
            throw new DataFetchingException((Throwable)e);
        }
    }
}

