/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.api.forms;

import graphql.annotations.annotationTypes.GraphQLField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.jahia.modules.contenteditor.api.forms.EditorFormRuntimeException;
import org.jahia.modules.contenteditor.api.forms.EditorFormSectionDefinition;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.osgi.framework.Bundle;

public class EditorFormDefinition
implements Comparable<EditorFormDefinition> {
    private String nodeType;
    private Double priority;
    private List<EditorFormSectionDefinition> sections;
    private Bundle originBundle;
    private Boolean hasPreview;

    public EditorFormDefinition() {
        this.sections = null;
    }

    public EditorFormDefinition(String nodeType, Double priority, Boolean hasPreview, List<EditorFormSectionDefinition> sections, Bundle originBundle) {
        this.nodeType = nodeType;
        this.priority = priority;
        this.sections = sections;
        this.originBundle = originBundle;
        this.hasPreview = hasPreview;
    }

    @GraphQLField
    public String getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    @GraphQLField
    public Double getPriority() {
        return this.priority;
    }

    public void setPriority(Double priority) {
        this.priority = priority;
    }

    @GraphQLField
    public Boolean hasPreview() {
        return this.hasPreview;
    }

    public void setHasPreview(Boolean hasPreview) {
        this.hasPreview = hasPreview;
    }

    @GraphQLField
    public List<EditorFormSectionDefinition> getSections() {
        return this.sections;
    }

    public void setSections(List<EditorFormSectionDefinition> sections) {
        this.sections = sections;
    }

    @GraphQLField
    public String getOriginBundleSymbolicName() {
        return this.originBundle != null ? this.originBundle.getSymbolicName() : null;
    }

    public Bundle getOriginBundle() {
        return this.originBundle;
    }

    public void setOriginBundle(Bundle originBundle) {
        this.originBundle = originBundle;
    }

    @Override
    public int compareTo(EditorFormDefinition otherEditorFormDefinition) {
        if (otherEditorFormDefinition == null) {
            return -1;
        }
        String otherName = otherEditorFormDefinition.getNodeType();
        try {
            ExtendedNodeType extendedNodeType = NodeTypeRegistry.getInstance().getNodeType(this.nodeType);
            ExtendedNodeType otherNodeType = NodeTypeRegistry.getInstance().getNodeType(otherName);
            if (!extendedNodeType.equals((Object)otherNodeType)) {
                if (extendedNodeType.isNodeType(otherNodeType.getName())) {
                    return 1;
                }
                if (otherNodeType.isNodeType(extendedNodeType.getName())) {
                    return -1;
                }
                return 1;
            }
        }
        catch (NoSuchNodeTypeException e) {
            throw new EditorFormRuntimeException(String.format("unable to resolve one of the types %s and %s", this.nodeType, otherName), e);
        }
        int result = 0;
        if (this.priority == null) {
            if (otherEditorFormDefinition.priority != null) {
                result = -1;
            }
        } else {
            result = otherEditorFormDefinition.priority == null ? 1 : this.priority.compareTo(otherEditorFormDefinition.priority);
        }
        if (result != 0) {
            return result;
        }
        if (this.originBundle == null) {
            if (otherEditorFormDefinition.originBundle != null) {
                result = -1;
            }
        } else {
            result = otherEditorFormDefinition.originBundle == null ? 1 : this.originBundle.compareTo((Object)otherEditorFormDefinition.originBundle);
        }
        return result;
    }

    public EditorFormDefinition mergeWith(EditorFormDefinition otherEditorFormDefinition) {
        return new EditorFormDefinition(this.nodeType, this.priority, otherEditorFormDefinition.hasPreview() != null ? otherEditorFormDefinition.hasPreview() : this.hasPreview, this.mergeSections(otherEditorFormDefinition.getSections()), null);
    }

    private List<EditorFormSectionDefinition> mergeSections(List<EditorFormSectionDefinition> sections) {
        List sectionsCopy = this.sections.stream().map(EditorFormSectionDefinition::copy).collect(Collectors.toCollection(LinkedList::new));
        if (sections == null) {
            return sectionsCopy;
        }
        ArrayList<EditorFormSectionDefinition> sortedSections = new ArrayList<EditorFormSectionDefinition>();
        for (EditorFormSectionDefinition newSection : sections) {
            EditorFormSectionDefinition sectionDef = null;
            Iterator iter = sectionsCopy.iterator();
            while (iter.hasNext()) {
                EditorFormSectionDefinition e = (EditorFormSectionDefinition)iter.next();
                if (!e.getName().equals(newSection.getName())) continue;
                sectionDef = e;
                iter.remove();
                break;
            }
            if (sectionDef == null) {
                sectionDef = newSection.copy();
            } else {
                sectionDef.mergeWith(newSection);
            }
            sortedSections.add(sectionDef);
        }
        sortedSections.addAll(sectionsCopy);
        return sortedSections;
    }
}

