/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.api.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldTarget;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldValue;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldValueConstraint;
import org.jahia.modules.contenteditor.api.forms.EditorFormProperty;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;

public class EditorFormField
implements Comparable<EditorFormField> {
    private static final Comparator<EditorFormField> editorFormFieldComparator = Comparator.comparing(EditorFormField::getTarget, Comparator.nullsFirst(EditorFormFieldTarget::compareTo)).thenComparing(EditorFormField::getName, Comparator.nullsFirst(String::compareToIgnoreCase));
    private String name;
    private String displayName;
    private String description;
    private String errorMessage;
    private String declaringNodeType;
    private GqlJcrPropertyType requiredType;
    private Map<String, Object> selectorOptionsMap;
    private String selectorType;
    private List<EditorFormProperty> selectorOptions;
    private Boolean i18n;
    private Boolean readOnly;
    private Boolean multiple;
    private Boolean mandatory;
    private List<EditorFormFieldValueConstraint> valueConstraints;
    private List<EditorFormFieldValue> defaultValues;
    private List<EditorFormFieldValue> currentValues;
    private Boolean removed;
    private EditorFormFieldTarget target;
    private ExtendedPropertyDefinition extendedPropertyDefinition;

    public EditorFormField() {
    }

    public EditorFormField(EditorFormField field) {
        this.setName(field.name);
        this.setDisplayName(field.displayName);
        this.setDescription(field.description);
        this.setErrorMessage(field.errorMessage);
        this.setRequiredType(field.requiredType);
        this.setSelectorType(field.selectorType);
        this.setSelectorOptions(field.selectorOptions == null ? null : field.selectorOptions.stream().map(EditorFormProperty::new).collect(Collectors.toList()));
        this.setI18n(field.i18n);
        this.setReadOnly(field.readOnly);
        this.setMultiple(field.multiple);
        this.setMandatory(field.mandatory);
        this.setValueConstraints(field.valueConstraints == null ? null : field.valueConstraints.stream().map(EditorFormFieldValueConstraint::new).collect(Collectors.toList()));
        this.setDefaultValues((List<EditorFormFieldValue>)(field.defaultValues == null ? null : new ArrayList<EditorFormFieldValue>(field.defaultValues)));
        this.setCurrentValues((List<EditorFormFieldValue>)(field.currentValues == null ? null : new ArrayList<EditorFormFieldValue>(field.currentValues)));
        this.setRemoved(field.removed);
        this.setTarget(field.target);
        this.setExtendedPropertyDefinition(field.extendedPropertyDefinition);
        this.setDeclaringNodeType(field.declaringNodeType);
    }

    @GraphQLField
    @GraphQLDescription(value="The required type for the field")
    public GqlJcrPropertyType getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(GqlJcrPropertyType requiredType) {
        this.requiredType = requiredType;
    }

    public Map<String, Object> getSelectorOptionsMap() {
        return this.selectorOptionsMap;
    }

    public void setSelectorOptionsMap(Map<String, Object> selectorOptionsMap) {
        this.selectorOptionsMap = selectorOptionsMap;
        this.selectorOptions = new ArrayList<EditorFormProperty>();
        this.serializeMap("", selectorOptionsMap);
    }

    private void serializeMap(String baseKey, Map<String, Object> selectorOptionsMap) {
        for (String key : selectorOptionsMap.keySet()) {
            Object value = selectorOptionsMap.get(key);
            if (value instanceof Map) {
                this.serializeMap(baseKey + key + ".", (Map)value);
                continue;
            }
            if (value instanceof List) {
                this.selectorOptions.add(new EditorFormProperty(baseKey + key, (List)value));
                continue;
            }
            this.selectorOptions.add(new EditorFormProperty(baseKey + key, value.toString()));
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Options for the selector type. For JCR definitions, this will usually include choicelist initializer name and properties.")
    public List<EditorFormProperty> getSelectorOptions() {
        return this.selectorOptions;
    }

    public void setSelectorOptions(List<EditorFormProperty> selectorOptions) {
        this.selectorOptions = selectorOptions;
    }

    @GraphQLField
    @GraphQLDescription(value="This array contains the list of possible values to choose from")
    public List<EditorFormFieldValueConstraint> getValueConstraints() {
        return this.valueConstraints;
    }

    public void setValueConstraints(List<EditorFormFieldValueConstraint> valueConstraints) {
        this.valueConstraints = valueConstraints;
    }

    @GraphQLField
    @GraphQLDescription(value="The name of the field")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @GraphQLField
    @GraphQLDescription(value="The displayable name of the field")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @GraphQLField
    @GraphQLDescription(value="The description of the field")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @GraphQLField
    @GraphQLDescription(value="The error message of the field")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @GraphQLField
    @GraphQLDescription(value="The declaring node type for the field")
    public String getDeclaringNodeType() {
        return this.declaringNodeType;
    }

    public void setDeclaringNodeType(String declaringNodeType) {
        this.declaringNodeType = declaringNodeType;
    }

    @GraphQLField
    @GraphQLDescription(value="The selector type for the field. In the case of fields generated from node types, this is actually the SelectorType.")
    public String getSelectorType() {
        return this.selectorType;
    }

    public void setSelectorType(String selectorType) {
        this.selectorType = selectorType;
    }

    @GraphQLField
    @GraphQLDescription(value="This value contains the default values for the field.")
    public List<EditorFormFieldValue> getDefaultValues() {
        return this.defaultValues;
    }

    public void setDefaultValues(List<EditorFormFieldValue> defaultValues) {
        this.defaultValues = defaultValues;
    }

    @GraphQLField
    @GraphQLDescription(value="This value is true if the field allows for internationalized values")
    public Boolean getI18n() {
        return this.i18n;
    }

    public void setI18n(Boolean i18n) {
        this.i18n = i18n;
    }

    @GraphQLField
    @GraphQLDescription(value="This value is true if the field is readonly. This could be due to locks or permissions")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @GraphQLField
    @GraphQLDescription(value="This value is true if the field value is multi-valued.")
    public Boolean getMultiple() {
        return this.multiple;
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
    }

    @GraphQLField
    @GraphQLDescription(value="This value is true if the field is mandatory")
    public Boolean getMandatory() {
        return this.mandatory;
    }

    public void setMandatory(Boolean mandatory) {
        this.mandatory = mandatory;
    }

    public EditorFormFieldTarget getTarget() {
        return this.target;
    }

    public void setTarget(EditorFormFieldTarget target) {
        this.target = target;
    }

    @GraphQLField
    @GraphQLDescription(value="This value contains the current existing values for the field.")
    public List<EditorFormFieldValue> getCurrentValues() {
        return this.currentValues;
    }

    public void setCurrentValues(List<EditorFormFieldValue> currentValues) {
        this.currentValues = currentValues;
    }

    public ExtendedPropertyDefinition getExtendedPropertyDefinition() {
        return this.extendedPropertyDefinition;
    }

    @JsonIgnore
    public void setExtendedPropertyDefinition(ExtendedPropertyDefinition extendedPropertyDefinition) {
        this.extendedPropertyDefinition = extendedPropertyDefinition;
    }

    public boolean isRemoved() {
        if (this.removed == null) {
            return false;
        }
        return this.removed;
    }

    public void setRemoved(Boolean removed) {
        this.removed = removed;
    }

    private static Boolean mergeBooleanKeepTrue(Boolean value1, Boolean value2) {
        if (value1 == null) {
            if (value2 == null) {
                return null;
            }
            return value2;
        }
        if (value1.booleanValue()) {
            return true;
        }
        if (value2 != null) {
            return value2;
        }
        return value1;
    }

    public EditorFormField mergeWith(EditorFormField otherEditorFormField) {
        if (!this.name.equals(otherEditorFormField.name)) {
            return this;
        }
        EditorFormField newField = new EditorFormField();
        newField.setName(this.name);
        newField.setDisplayName(otherEditorFormField.displayName != null ? otherEditorFormField.displayName : this.displayName);
        newField.setDescription(otherEditorFormField.description != null ? otherEditorFormField.description : this.description);
        newField.setErrorMessage(otherEditorFormField.errorMessage != null ? otherEditorFormField.errorMessage : this.errorMessage);
        newField.setRequiredType(otherEditorFormField.requiredType != null ? otherEditorFormField.requiredType : this.requiredType);
        newField.setSelectorType(otherEditorFormField.selectorType != null ? otherEditorFormField.selectorType : this.selectorType);
        newField.setSelectorOptions(otherEditorFormField.selectorOptions != null ? otherEditorFormField.selectorOptions : this.selectorOptions);
        newField.setI18n(this.i18n != null ? this.i18n : otherEditorFormField.i18n);
        newField.setReadOnly(EditorFormField.mergeBooleanKeepTrue(this.readOnly, otherEditorFormField.readOnly));
        newField.setMultiple(this.multiple != null ? this.multiple : otherEditorFormField.multiple);
        newField.setMandatory(EditorFormField.mergeBooleanKeepTrue(this.mandatory, otherEditorFormField.mandatory));
        newField.setValueConstraints(otherEditorFormField.valueConstraints != null ? otherEditorFormField.valueConstraints : this.valueConstraints);
        newField.setDefaultValues(otherEditorFormField.defaultValues != null ? otherEditorFormField.defaultValues : this.defaultValues);
        newField.setCurrentValues(otherEditorFormField.currentValues != null ? otherEditorFormField.currentValues : this.currentValues);
        newField.setRemoved(otherEditorFormField.removed != null ? otherEditorFormField.removed : this.removed);
        newField.setTarget(this.mergeTargets(otherEditorFormField));
        newField.setExtendedPropertyDefinition(this.extendedPropertyDefinition != null ? this.extendedPropertyDefinition : otherEditorFormField.extendedPropertyDefinition);
        newField.setDeclaringNodeType(otherEditorFormField.declaringNodeType != null ? otherEditorFormField.declaringNodeType : this.declaringNodeType);
        return newField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditorFormField that = (EditorFormField)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.errorMessage, that.errorMessage) && Objects.equals(this.requiredType, that.requiredType) && Objects.equals(this.selectorType, that.selectorType) && Objects.equals(this.selectorOptions, that.selectorOptions) && Objects.equals(this.i18n, that.i18n) && Objects.equals(this.readOnly, that.readOnly) && Objects.equals(this.multiple, that.multiple) && Objects.equals(this.mandatory, that.mandatory) && Objects.equals(this.valueConstraints, that.valueConstraints) && Objects.equals(this.defaultValues, that.defaultValues) && Objects.equals(this.currentValues, that.currentValues) && Objects.equals(this.removed, that.removed) && Objects.equals(this.target, that.target) && Objects.equals(this.extendedPropertyDefinition, that.extendedPropertyDefinition) && Objects.equals(this.declaringNodeType, that.declaringNodeType);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.displayName, this.description, this.errorMessage, this.requiredType, this.selectorType, this.selectorOptions, this.i18n, this.readOnly, this.multiple, this.mandatory, this.valueConstraints, this.defaultValues, this.currentValues, this.removed, this.target, this.extendedPropertyDefinition, this.declaringNodeType);
    }

    public String toString() {
        return "EditorFormField{name='" + this.name + '\'' + ", displayName='" + this.displayName + '\'' + ", description='" + this.description + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", requiredType='" + this.requiredType + '\'' + ", selectorType='" + this.selectorType + '\'' + ", selectorOptions=" + this.selectorOptions + ", i18n=" + this.i18n + ", readOnly=" + this.readOnly + ", multiple=" + this.multiple + ", mandatory=" + this.mandatory + ", valueConstraints=" + this.valueConstraints + ", defaultValues=" + this.defaultValues + ", currentValues=" + this.currentValues + ", removed=" + this.removed + ", target=" + this.target + ", extendedPropertyDefinition=" + this.extendedPropertyDefinition + ", declaringNodeType=" + this.declaringNodeType + '}';
    }

    private EditorFormFieldTarget mergeTargets(EditorFormField otherEditorFormField) {
        if (this.target == null) {
            if (otherEditorFormField.target != null) {
                return otherEditorFormField.target;
            }
            return null;
        }
        EditorFormFieldTarget mergedEditorFormFieldTarget = new EditorFormFieldTarget(this.target.getSectionName(), this.target.getFieldSetName(), this.target.getRank());
        if (otherEditorFormField.target != null) {
            Double otherEditorFormFieldTargetRank = otherEditorFormField.target.getRank();
            if (otherEditorFormFieldTargetRank != null) {
                mergedEditorFormFieldTarget.setRank(otherEditorFormFieldTargetRank);
            }
            if (otherEditorFormField.target.getSectionName() != null && otherEditorFormField.target.getFieldSetName() != null) {
                mergedEditorFormFieldTarget.setSectionName(otherEditorFormField.target.getSectionName());
                mergedEditorFormFieldTarget.setFieldSetName(otherEditorFormField.target.getFieldSetName());
            }
        }
        return mergedEditorFormFieldTarget;
    }

    @Override
    public int compareTo(EditorFormField other) {
        return editorFormFieldComparator.compare(this, other);
    }
}

