/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.api.forms;

import com.fasterxml.jackson.annotation.JsonProperty;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jahia.modules.contenteditor.api.forms.EditorFormField;
import org.jahia.modules.contenteditor.api.forms.EditorFormFieldTarget;
import org.osgi.framework.Bundle;

public class EditorFormFieldSet
implements Comparable<EditorFormFieldSet> {
    private String name;
    private String displayName;
    private String description;
    private Bundle originBundle;
    private Double rank = 0.0;
    private Double priority = 1.0;
    private Boolean removed = false;
    private Boolean dynamic = false;
    private Boolean activated = true;
    private Boolean displayed = true;
    private Boolean readOnly;
    private Set<EditorFormField> editorFormFields = new HashSet<EditorFormField>();
    private Map<String, EditorFormField> editorFormFieldsByName = new LinkedHashMap<String, EditorFormField>();
    private EditorFormFieldTarget target = new EditorFormFieldTarget();

    public EditorFormFieldSet() {
    }

    public EditorFormFieldSet(String name, String displayName, String description, Boolean removed, Boolean dynamic, Boolean activated, Boolean displayed, Boolean readOnly, Set<EditorFormField> editorFormFields) {
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.removed = removed;
        this.dynamic = dynamic;
        this.activated = activated;
        this.displayed = displayed;
        this.readOnly = readOnly;
        this.setEditorFormFields(editorFormFields);
    }

    @GraphQLField
    @GraphQLDescription(value="Get the name of the field set")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @GraphQLField
    @GraphQLDescription(value="Get the internationalized displayable name of the field set")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @GraphQLField
    @GraphQLDescription(value="Get the internationalized description of the field set")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getRemoved() {
        return this.removed;
    }

    public void setRemoved(Boolean removed) {
        this.removed = removed;
    }

    @GraphQLField
    @GraphQLDescription(value="True if this is dynamic field set (meaningin it can be activated or not)")
    public Boolean getDynamic() {
        return this.dynamic;
    }

    public void setDynamic(Boolean dynamic) {
        this.dynamic = dynamic;
    }

    @GraphQLField
    @GraphQLDescription(value="Only used in the case of a dynamic field set. Set to true if it is activated")
    public Boolean getActivated() {
        return this.activated;
    }

    public void setActivated(Boolean activated) {
        this.activated = activated;
    }

    @GraphQLField
    @GraphQLDescription(value="Defines if the field has to be displayed or not")
    public Boolean getDisplayed() {
        return this.displayed;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @GraphQLField
    @GraphQLDescription(value="This value is true if the fieldset is readonly. This could be due to locks or permissions")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setDisplayed(Boolean displayed) {
        this.displayed = displayed;
    }

    public Bundle getOriginBundle() {
        return this.originBundle;
    }

    public void setOriginBundle(Bundle originBundle) {
        this.originBundle = originBundle;
    }

    public Double getRank() {
        return this.rank;
    }

    public void setRank(Double rank) {
        this.rank = rank;
    }

    public Double getPriority() {
        return this.priority;
    }

    public void setPriority(Double priority) {
        this.priority = priority;
    }

    @GraphQLField
    @GraphQLName(value="fields")
    @GraphQLDescription(value="Get the fields contained in the target")
    @JsonProperty(value="fields")
    public Set<EditorFormField> getEditorFormFields() {
        return this.editorFormFields;
    }

    public void setEditorFormFields(Set<EditorFormField> editorFormFields) {
        this.editorFormFields = editorFormFields;
        this.editorFormFieldsByName.clear();
        if (editorFormFields != null) {
            for (EditorFormField editorFormField : editorFormFields) {
                this.editorFormFieldsByName.put(editorFormField.getName(), editorFormField);
            }
        }
    }

    public boolean addField(EditorFormField editorFormField) {
        this.editorFormFieldsByName.put(editorFormField.getName(), editorFormField);
        return this.editorFormFields.add(editorFormField);
    }

    public String toString() {
        return "EditorFormFieldSet{nodeType='" + this.name + '\'' + ", originBundle=" + this.originBundle + ", priority=" + this.priority + ", editorFormFields=" + this.editorFormFields + ", editorFormFieldsByName=" + this.editorFormFieldsByName + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditorFormFieldSet that = (EditorFormFieldSet)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.originBundle, that.originBundle) && Objects.equals(this.rank, that.rank) && Objects.equals(this.priority, that.priority);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.originBundle, this.rank, this.priority);
    }

    @Override
    public int compareTo(EditorFormFieldSet otherEditorFormFieldSet) {
        if (otherEditorFormFieldSet == null) {
            return -1;
        }
        int compareName = this.name.compareTo(otherEditorFormFieldSet.name);
        if (compareName != 0) {
            int compareRank = this.rank.compareTo(otherEditorFormFieldSet.rank);
            if (compareRank == 0) {
                return compareName;
            }
            return compareRank;
        }
        if (this.priority == null) {
            if (otherEditorFormFieldSet.priority != null) {
                return -1;
            }
            return otherEditorFormFieldSet.hashCode() - this.hashCode();
        }
        if (otherEditorFormFieldSet.priority == null) {
            return 1;
        }
        int comparePriority = this.priority.compareTo(otherEditorFormFieldSet.priority);
        if (comparePriority == 0) {
            return otherEditorFormFieldSet.hashCode() - this.hashCode();
        }
        return comparePriority;
    }

    public boolean isRemoved() {
        if (this.removed == null) {
            return false;
        }
        return this.removed;
    }

    public EditorFormFieldSet mergeWith(EditorFormFieldSet otherEditorFormFieldSet, Set<String> processedProperties) {
        if (!this.name.equals(otherEditorFormFieldSet.name)) {
            return this;
        }
        TreeSet<EditorFormField> mergedEditorFormFields = new TreeSet<EditorFormField>();
        if (this.editorFormFields != null) {
            for (EditorFormField editorFormField : this.editorFormFields) {
                EditorFormField mergedEditorFormField;
                EditorFormField otherFormField = otherEditorFormFieldSet.editorFormFieldsByName.get(editorFormField.getName());
                if (otherFormField == null && !editorFormField.isRemoved()) {
                    mergedEditorFormFields.add(editorFormField);
                    continue;
                }
                if (otherFormField == null || (mergedEditorFormField = editorFormField.mergeWith(otherFormField)).isRemoved()) continue;
                mergedEditorFormFields.add(mergedEditorFormField);
            }
        }
        if (otherEditorFormFieldSet.editorFormFields != null) {
            for (EditorFormField otherEditorFormField : otherEditorFormFieldSet.editorFormFields) {
                if (this.editorFormFieldsByName.get(otherEditorFormField.getName()) != null || otherEditorFormField.isRemoved() || processedProperties.contains(otherEditorFormField.getName())) continue;
                mergedEditorFormFields.add(otherEditorFormField);
            }
        }
        EditorFormFieldSet newEditorFormFieldSet = new EditorFormFieldSet(this.name, this.displayName, this.description, this.removed, this.dynamic, this.activated, this.displayed, this.readOnly, mergedEditorFormFields);
        if (otherEditorFormFieldSet.priority != null) {
            newEditorFormFieldSet.setPriority(otherEditorFormFieldSet.priority);
        }
        if (otherEditorFormFieldSet.rank != null) {
            newEditorFormFieldSet.setRank(otherEditorFormFieldSet.rank);
        }
        newEditorFormFieldSet.setRemoved(otherEditorFormFieldSet.isRemoved());
        if (this.originBundle != null) {
            newEditorFormFieldSet.setOriginBundle(this.getOriginBundle());
        } else {
            newEditorFormFieldSet.setOriginBundle(otherEditorFormFieldSet.getOriginBundle());
        }
        if (otherEditorFormFieldSet.displayed != null) {
            newEditorFormFieldSet.setDisplayed(otherEditorFormFieldSet.getDisplayed());
        }
        return newEditorFormFieldSet;
    }

    public EditorFormField getFieldByName(String name) {
        return this.editorFormFieldsByName.get(name);
    }

    public EditorFormFieldTarget getTarget() {
        return this.target;
    }

    public void setTarget(EditorFormFieldTarget target) {
        this.target = target;
    }
}

