/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.api.forms;

import com.fasterxml.jackson.annotation.JsonProperty;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;

public class EditorFormFieldValue {
    private String type;
    private String value;

    public EditorFormFieldValue() {
    }

    public EditorFormFieldValue(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public EditorFormFieldValue(Long longValue) {
        this.type = "Long";
        this.value = String.valueOf(longValue);
    }

    public EditorFormFieldValue(Double doubleValue) {
        this.type = "Double";
        this.value = String.valueOf(doubleValue);
    }

    public EditorFormFieldValue(Boolean booleanValue) {
        this.type = "Boolean";
        this.value = String.valueOf(booleanValue);
    }

    public EditorFormFieldValue(Value value) throws RepositoryException {
        this.type = PropertyType.nameFromValue((int)value.getType());
        switch (value.getType()) {
            case 0: 
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.value = value.getString();
                break;
            }
            case 3: {
                this.value = String.valueOf(value.getLong());
                break;
            }
            case 4: {
                this.value = String.valueOf(value.getDouble());
                break;
            }
            case 12: {
                this.value = String.valueOf(value.getDecimal());
                break;
            }
            case 5: {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").withZone(value.getDate().getTimeZone().toZoneId());
                this.value = formatter.format(value.getDate().toInstant());
                break;
            }
            case 6: {
                this.value = String.valueOf(value.getBoolean());
                break;
            }
        }
    }

    @GraphQLField
    @GraphQLName(value="string")
    @GraphQLDescription(value="This value's string representation")
    @JsonProperty(value="string")
    public String getStringValue() {
        return this.value;
    }

    @GraphQLField
    @GraphQLDescription(value="The type of this value")
    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "EditorFormFieldValue{type='" + this.type + '\'' + ", value='" + this.value + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EditorFormFieldValue that = (EditorFormFieldValue)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }
}

