/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.graphql.api.definitions;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.jahia.modules.contenteditor.graphql.api.GqlUtils;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrNodeType;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.utils.NodeTypeTreeEntry;

@GraphQLName(value="NodeTypeTreeEntry")
@GraphQLDescription(value="GraphQL representation of node type tree entry")
public class GqlNodeTypeTreeEntry {
    private NodeTypeTreeEntry nodeTreeEntry;
    private GqlNodeTypeTreeEntry parent;
    private String id;

    public GqlNodeTypeTreeEntry(NodeTypeTreeEntry entry, String identifier) {
        this.nodeTreeEntry = entry;
        this.id = entry.getName() + "-" + identifier;
    }

    private GqlNodeTypeTreeEntry(NodeTypeTreeEntry entry, GqlNodeTypeTreeEntry parent) {
        this.nodeTreeEntry = entry;
        this.id = entry.getName() + "-" + parent.getId();
        this.parent = parent;
    }

    @GraphQLField
    @GraphQLDescription(value="Return nodeType name")
    public String getName() {
        return this.nodeTreeEntry.getName();
    }

    @GraphQLField
    @GraphQLDescription(value="Return uniq identifier for tree entry")
    public String getId() {
        return this.id;
    }

    @GraphQLField
    @GraphQLDescription(value="Return the parent tree entry (if any)")
    public GqlNodeTypeTreeEntry getParent() {
        return this.parent;
    }

    @GraphQLField
    @GraphQLDescription(value="Return nodeType")
    public GqlJcrNodeType getNodeType() {
        return new GqlJcrNodeType(this.nodeTreeEntry.getNodeType());
    }

    @GraphQLField
    @GraphQLDescription(value="Return icon URL with png extension")
    public String getIconURL(@GraphQLName(value="addExtension") @GraphQLDefaultValue(value=GqlUtils.SupplierTrue.class) @GraphQLDescription(value="if true (default) add '.png' to the icon path.") boolean addExtension) {
        try {
            return JCRContentUtils.getIconWithContext((ExtendedNodeType)this.nodeTreeEntry.getNodeType()) + (addExtension ? ".png" : "");
        }
        catch (RepositoryException e) {
            throw new DataFetchingException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Return the i18n label")
    public String getLabel() {
        return this.nodeTreeEntry.getLabel();
    }

    @GraphQLField
    @GraphQLDescription(value="Return the children if any")
    public List<GqlNodeTypeTreeEntry> getChildren() {
        if (this.nodeTreeEntry.getChildren() == null) {
            return Collections.emptyList();
        }
        return this.nodeTreeEntry.getChildren().stream().sorted(Comparator.comparing(NodeTypeTreeEntry::getLabel)).map(entry -> new GqlNodeTypeTreeEntry((NodeTypeTreeEntry)entry, this)).collect(Collectors.toList());
    }
}

