/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.migration;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.content.JCRValueWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migrator {
    private static final Logger logger = LoggerFactory.getLogger(Migrator.class);

    public static void migrate() {
        try {
            logger.info("Content editor migration: start migration check for [contentEditor] permission on editor-in-chief/currentSite-access role");
            if (Migrator.migrateRemoveContentEditorPermissionOnEditorInChiefCurrentSite()) {
                logger.info("Content editor migration: [contentEditor] permission successfully removed on editor-in-chief/currentSite-access role");
            } else {
                logger.info("Content editor migration: nothing to migrate for [contentEditor] permission on editor-in-chief/currentSite-access role");
            }
        }
        catch (Exception e) {
            logger.error("Content editor migration: Failed to migrate [contentEditor] permission on editor-in-chief/currentSite-access role", (Throwable)e);
        }
    }

    private static boolean migrateRemoveContentEditorPermissionOnEditorInChiefCurrentSite() throws RepositoryException {
        return (Boolean)JCRTemplate.getInstance().doExecuteWithSystemSession(session -> {
            List<JCRValueWrapper> filteredValues;
            JCRPropertyWrapper permissionNamesProp;
            try {
                JCRNodeWrapper editorInChiefCurrentSiteAccessNode = session.getNode("/roles/editor/editor-in-chief/currentSite-access");
                permissionNamesProp = editorInChiefCurrentSiteAccessNode.getProperty("j:permissionNames");
            }
            catch (Exception e) {
                return false;
            }
            JCRValueWrapper[] originalValues = permissionNamesProp.getValues();
            if (originalValues.length > 0 && originalValues.length != (filteredValues = Arrays.stream(originalValues).filter(value -> {
                try {
                    return !"contentEditor".equals(value.getString());
                }
                catch (RepositoryException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList())).size()) {
                permissionNamesProp.setValue((Value[])filteredValues.toArray(new JCRValueWrapper[0]));
                session.save();
                return true;
            }
            return false;
        });
    }
}

