/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.render;

import org.apache.commons.lang3.StringUtils;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.filter.AbstractFilter;
import org.jahia.services.render.filter.RenderChain;
import org.jahia.services.render.filter.RenderFilter;
import org.osgi.service.component.annotations.Component;

@Component(service={RenderFilter.class}, immediate=true)
public class PreviewWrapperFilter
extends AbstractFilter {
    private final String CE_PREVIEW_WRAPPER = "ce_preview_wrapper";
    private final String CE_PREVIEW_WRAPPER_TAG_START = "<div id=\"ce_preview_content\">";
    private final String CE_PREVIEW_WRAPPER_TAG_END = "</div>";

    public PreviewWrapperFilter() {
        this.setPriority(45.0f);
        this.setApplyOnModes("preview");
        this.setApplyOnConfigurations("module");
        this.addCondition((renderContext, resource) -> {
            String ceAttribute = (String)renderContext.getRequest().getAttribute("ce_preview_wrapper");
            return StringUtils.isNotEmpty((CharSequence)ceAttribute) && ceAttribute.equals(resource.getNodePath());
        });
    }

    public String execute(String previousOut, RenderContext renderContext, Resource resource, RenderChain chain) {
        return "<div id=\"ce_preview_content\">" + previousOut + "</div>";
    }
}

