/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.contenteditor.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.nodetypes.ConstraintsHelper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingConsumer;

public class ContentEditorUtils {
    private static Logger logger = LoggerFactory.getLogger(ContentEditorUtils.class);

    private ContentEditorUtils() {
    }

    public static Set<String> getAllowedNodeTypesAsChildNode(JCRNodeWrapper currentNode, String childNodeName, boolean useContributeNodeTypes, boolean includeSubTypes, List<String> filterNodeType) {
        try {
            Set<String> resolvedContributeTypes;
            Set<String> definitionAllowedTypes = ContentEditorUtils.getChildNodeTypes(currentNode, filterNodeType, childNodeName, includeSubTypes);
            if (useContributeNodeTypes && (resolvedContributeTypes = ContentEditorUtils.getContributeTypes(currentNode, definitionAllowedTypes)) != null && !resolvedContributeTypes.isEmpty()) {
                return resolvedContributeTypes;
            }
            return definitionAllowedTypes;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException((Throwable)e);
        }
    }

    private static Set<String> getContributeTypes(JCRNodeWrapper node, Set<String> definitionAllowedTypes) throws RepositoryException {
        JCRNodeWrapper parent;
        if (node.isNodeType("jmix:contributeMode") && node.hasProperty("j:contributeTypes")) {
            JCRValueWrapper[] contributeTypes = node.getProperty("j:contributeTypes").getValues();
            HashSet<String> resolvedContributeTypes = new HashSet<String>();
            Arrays.stream(contributeTypes).forEach(type -> definitionAllowedTypes.forEach(allowedType -> {
                try {
                    if (NodeTypeRegistry.getInstance().getNodeType(type.getString()).isNodeType(allowedType)) {
                        resolvedContributeTypes.add(type.getString());
                    }
                }
                catch (RepositoryException e) {
                    throw new DataFetchingException((Throwable)e);
                }
            }));
            return resolvedContributeTypes;
        }
        try {
            parent = node.getParent();
        }
        catch (ItemNotFoundException e) {
            return Collections.emptySet();
        }
        return ContentEditorUtils.getContributeTypes(parent, definitionAllowedTypes);
    }

    private static Set<String> getChildNodeTypes(JCRNodeWrapper node, List<String> filterNodeType, String childNodeName, boolean includeSubTypes) throws RepositoryException {
        HashSet<String> allowedTypes = new HashSet<String>();
        HashSet availableTypes = new HashSet(ConstraintsHelper.getConstraintSet((JCRNodeWrapper)node, (String)childNodeName));
        if (availableTypes.isEmpty()) {
            availableTypes.addAll(ConstraintsHelper.getConstraintSet((JCRNodeWrapper)node));
        }
        availableTypes.forEach(type -> {
            try {
                ExtendedNodeType nodeType = NodeTypeRegistry.getInstance().getNodeType(type);
                Stream<ExtendedNodeType> typesToCheck = Stream.concat(nodeType.getSubtypesAsList().stream(), Stream.of(nodeType));
                typesToCheck.forEach(subType -> ContentEditorUtils.getAllowedTypes(allowedTypes, filterNodeType, subType, includeSubTypes));
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        });
        return allowedTypes;
    }

    private static void getAllowedTypes(Set<String> allowedTypes, List<String> filterNodeType, ExtendedNodeType subType, boolean includeSubTypes) {
        if (filterNodeType != null) {
            filterNodeType.forEach(ThrowingConsumer.unchecked(filterType -> {
                if (NodeTypeRegistry.getInstance().getNodeType(filterType).isMixin() || includeSubTypes) {
                    if (subType.isNodeType(filterType)) {
                        allowedTypes.add(subType.getName());
                    }
                } else if (subType.getName().equals(filterType)) {
                    allowedTypes.add(subType.getName());
                }
            }));
        } else {
            allowedTypes.add(subType.getName());
        }
    }
}

