/*
 * Copyright (C) 2002-2022 Jahia Solutions Group SA. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jahia.modules.graphql.provider.dxm.admin;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;

@GraphQLName("Cluster")
@GraphQLDescription("Details about the Jahia Cluster")
public class GqlCluster {

    private Boolean isActivated;

    public GqlCluster() {
    }

    @GraphQLField
    @GraphQLName("isActivated")
    @GraphQLDescription("Is the cluster mode activated on this Jahia instance")
    public Boolean getIsActivated() {
        return isActivated;
    }

    @GraphQLField
    @GraphQLDescription("Query operation on Jahia's journal across all nodes of a cluster")
    public GqlClusterJournal getJournal() {
        return isActivated ? new GqlClusterJournal() : null;
    }

    public void setIsActivated(Boolean isActivated) {
        this.isActivated = isActivated;
    }
}


