/*
 * Copyright (C) 2002-2022 Jahia Solutions Group SA. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jahia.modules.graphql.provider.dxm.osgiconfig;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;

@GraphQLDescription("OSGi configuration property")
public class GqlConfigurationProperty {
    private String key;
    private String value;

    public GqlConfigurationProperty(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @GraphQLField
    @GraphQLDescription("The property key")
    public String getKey() {
        return key;
    }

    @GraphQLField
    @GraphQLDescription("The property value")
    public String getValue() {
        return value;
    }
}
