/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm;

import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.GraphQLError;
import graphql.language.SourceLocation;
import java.util.List;
import java.util.Map;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;

public class DXGraphQLError
implements GraphQLError {
    private final String message;
    private List<Object> path;
    private List<SourceLocation> locations;
    private ErrorType errorType;
    private BaseGqlClientException exception;

    public DXGraphQLError(BaseGqlClientException exception, List<Object> path, List<SourceLocation> locations) {
        this.message = exception.getMessage();
        this.path = path;
        this.locations = locations;
        this.errorType = exception.getErrorType();
        this.exception = exception;
    }

    public List<Object> getPath() {
        return this.path;
    }

    public String getMessage() {
        return this.message;
    }

    public List<SourceLocation> getLocations() {
        return this.locations;
    }

    public ErrorClassification getErrorType() {
        if (this.errorType != null) {
            return this.errorType;
        }
        return new SimpleClassification(((Object)((Object)this.exception)).getClass().getSimpleName());
    }

    public Map<String, Object> getExtensions() {
        return this.exception.getExtensions();
    }

    public Map<String, Object> toSpecification() {
        Map result = super.toSpecification();
        result.put("errorType", this.getErrorType().toSpecification((GraphQLError)this));
        return result;
    }

    private class SimpleClassification
    implements ErrorClassification {
        private String value;

        public SimpleClassification(String value) {
            this.value = value;
        }

        public Object toSpecification(GraphQLError error) {
            return this.value;
        }
    }
}

