/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.PropertyExistence;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeConstraintInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeCriteriaInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.node.GqlOrdering;
import org.jahia.services.content.nodetypes.ValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingBiFunction;
import pl.touk.throwing.ThrowingFunction;

public class GqlConstraintHandler {
    private static final Logger logger = LoggerFactory.getLogger(GqlConstraintHandler.class);
    public static final Pattern LONG_PATTERN = Pattern.compile("[+-]?\\d+");
    public static final Pattern DOUBLE_PATTERN = Pattern.compile("^[+-]?\\d+\\.?\\d+?$");
    private static final NodeConstraintConvertor[] NODE_CONSTRAINT_CONVERTORS = new NodeConstraintConvertor[]{new NodeConstraintConvertorLike(), new NodeConstraintConvertorContains(), new NodeConstraintConvertorEquals(), new NodeConstraintConvertorNotEquals(), new NodeConstraintConvertorGreaterThan(), new NodeConstraintConvertorGreaterThanOrEqualsTo(), new NodeConstraintConvertorLessThan(), new NodeConstraintConvertorLessThanOrEqualsTo(), new NodeConstraintConvertorExists(), new NodeConstraintConvertorLastDays()};
    private QueryObjectModelFactory qomFactory;
    private ValueFactory valueFactory;

    public GqlConstraintHandler(QueryObjectModelFactory qomFactory, ValueFactory valueFactory) {
        this.qomFactory = qomFactory;
        this.valueFactory = valueFactory;
    }

    public QueryObjectModelFactory getQomFactory() {
        return this.qomFactory;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public Constraint getConstraintTree(String selector, GqlJcrNodeCriteriaInput criteria) throws RepositoryException {
        LinkedHashSet<Constraint> constraints = new LinkedHashSet<Constraint>();
        Collection<String> paths = criteria.getPaths();
        if (paths != null && !paths.isEmpty()) {
            Function<String, Constraint> constraintFunction = this.getPathConstraintFunction(selector, criteria.getPathType());
            constraints.add(paths.stream().map(constraintFunction).reduce(ThrowingBiFunction.unchecked((arg_0, arg_1) -> ((QueryObjectModelFactory)this.qomFactory).or(arg_0, arg_1))::apply).orElse(null));
        }
        if (criteria.getNodeConstraint() != null) {
            constraints.add(this.compositeChildConstraints(selector, criteria.getNodeConstraint()));
        }
        return constraints.stream().reduce(ThrowingBiFunction.unchecked((arg_0, arg_1) -> ((QueryObjectModelFactory)this.qomFactory).and(arg_0, arg_1))::apply).orElse(null);
    }

    private Function<String, Constraint> getPathConstraintFunction(String selector, GqlJcrNodeCriteriaInput.PathType pathType) {
        Function function = ThrowingFunction.unchecked(p -> this.qomFactory.descendantNode(selector, p));
        if (pathType == GqlJcrNodeCriteriaInput.PathType.PARENT) {
            function = ThrowingFunction.unchecked(p -> this.qomFactory.childNode(selector, p));
        } else if (pathType == GqlJcrNodeCriteriaInput.PathType.OWN) {
            function = ThrowingFunction.unchecked(p -> this.qomFactory.sameNode(selector, p));
        }
        return function;
    }

    private Constraint compositeChildConstraints(String selector, GqlJcrNodeConstraintInput constraintInput) throws RepositoryException {
        this.validateNodeCompositeConstraintConflict(constraintInput);
        List<GqlJcrNodeConstraintInput> allConstraintInputs = constraintInput.getAll();
        List<GqlJcrNodeConstraintInput> anyConstraintInputs = constraintInput.getAny();
        List<GqlJcrNodeConstraintInput> noneConstraintInputs = constraintInput.getNone();
        Function convert = ThrowingFunction.unchecked(c -> this.compositeChildConstraints(selector, (GqlJcrNodeConstraintInput)c));
        if (allConstraintInputs == null && anyConstraintInputs == null && noneConstraintInputs == null) {
            return this.convertToConstraint(selector, constraintInput);
        }
        if (allConstraintInputs != null && anyConstraintInputs == null && noneConstraintInputs == null) {
            return allConstraintInputs.stream().map(convert).reduce(ThrowingBiFunction.unchecked((arg_0, arg_1) -> ((QueryObjectModelFactory)this.qomFactory).and(arg_0, arg_1))::apply).orElse(null);
        }
        if (allConstraintInputs == null && anyConstraintInputs != null && noneConstraintInputs == null) {
            return anyConstraintInputs.stream().map(convert).reduce(ThrowingBiFunction.unchecked((arg_0, arg_1) -> ((QueryObjectModelFactory)this.qomFactory).or(arg_0, arg_1))::apply).orElse(null);
        }
        if (allConstraintInputs == null && anyConstraintInputs == null && noneConstraintInputs != null) {
            return noneConstraintInputs.stream().map(convert).map(ThrowingFunction.unchecked(arg_0 -> ((QueryObjectModelFactory)this.qomFactory).not(arg_0))).reduce(ThrowingBiFunction.unchecked((arg_0, arg_1) -> ((QueryObjectModelFactory)this.qomFactory).and(arg_0, arg_1))::apply).orElse(null);
        }
        throw new GqlJcrWrongInputException("Composite constraints all/any/none cannot be mixed with other constraints in the same level");
    }

    private void validateNodeCompositeConstraintConflict(GqlJcrNodeConstraintInput nodeConstraint) {
        if (!(nodeConstraint.getAll() == null && nodeConstraint.getAny() == null && nodeConstraint.getNone() == null || nodeConstraint.getContains() == null && nodeConstraint.getLike() == null && nodeConstraint.getFunction() == null && nodeConstraint.getExists() == null && nodeConstraint.getEquals() == null && nodeConstraint.getGt() == null && nodeConstraint.getGte() == null && nodeConstraint.getLt() == null && nodeConstraint.getLte() == null && nodeConstraint.getLastDays() == null && nodeConstraint.getProperty() == null && nodeConstraint.getNotEquals() == null)) {
            throw new GqlJcrWrongInputException("Composite constraints all/any/none cannot be mixed with other constraints in the same level");
        }
    }

    private Constraint convertToConstraint(String selector, GqlJcrNodeConstraintInput nodeConstraintInput) throws RepositoryException {
        return Arrays.stream(NODE_CONSTRAINT_CONVERTORS).map(ThrowingFunction.unchecked(nodeConstraintConvertor -> nodeConstraintConvertor.convert(nodeConstraintInput, selector, this))).filter(Objects::nonNull).reduce(ThrowingBiFunction.unchecked((arg_0, arg_1) -> ((QueryObjectModelFactory)this.qomFactory).and(arg_0, arg_1))::apply).orElseThrow(() -> new GqlJcrWrongInputException("At least one of the following constraint field is expected: " + StringUtils.join((Collection)Arrays.stream(NODE_CONSTRAINT_CONVERTORS).map(NodeConstraintConvertor::getFieldName).collect(Collectors.toSet()), (char)',')));
    }

    public Ordering getOrderingByProperty(String selector, GqlJcrNodeCriteriaInput criteria) throws RepositoryException {
        GqlOrdering gqlOrdering = criteria.getOrdering();
        Ordering ordering = null;
        if (gqlOrdering != null) {
            switch (gqlOrdering.getOrderType()) {
                case ASC: {
                    ordering = this.qomFactory.ascending((DynamicOperand)this.qomFactory.propertyValue(selector, gqlOrdering.getProperty()));
                    break;
                }
                case DESC: {
                    ordering = this.qomFactory.descending((DynamicOperand)this.qomFactory.propertyValue(selector, gqlOrdering.getProperty()));
                }
            }
        }
        return ordering;
    }

    private DynamicOperand applyConstraintFunctions(GqlJcrNodeConstraintInput nodeConstraint, String selector) throws RepositoryException {
        PropertyValue value = nodeConstraint.getProperty() != null ? this.qomFactory.propertyValue(selector, nodeConstraint.getProperty()) : null;
        GqlJcrNodeConstraintInput.QueryFunction function = nodeConstraint.getFunction();
        if (function == null) {
            return value;
        }
        switch (function) {
            case LOWER_CASE: {
                return this.qomFactory.lowerCase((DynamicOperand)value);
            }
            case UPPER_CASE: {
                return this.qomFactory.upperCase((DynamicOperand)value);
            }
            case NODE_NAME: {
                return this.qomFactory.nodeName(selector);
            }
            case NODE_LOCAL_NAME: {
                return this.qomFactory.nodeLocalName(selector);
            }
        }
        return value;
    }

    private Value convertValueByParsingSuccess(String value) {
        if (LONG_PATTERN.matcher(value).matches()) {
            return this.valueFactory.createValue(Long.parseLong(value));
        }
        if (DOUBLE_PATTERN.matcher(value).matches()) {
            return this.valueFactory.createValue(Double.parseDouble(value));
        }
        try {
            Calendar c = ISO8601.parse((String)value);
            if (c != null) {
                return this.valueFactory.createValue(c);
            }
        }
        catch (IllegalArgumentException e) {
            logger.debug("Cannot parse date", (Throwable)e);
        }
        throw new DataFetchingException("Invalid value " + value);
    }

    private static class NodeConstraintConvertorLastDays
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorLastDays() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            Integer value = nodeConstraint.getLastDays();
            if (value == null) {
                return null;
            }
            this.validateNodeConstraintProperty(nodeConstraint);
            if (nodeConstraint.getLastDays() != null && nodeConstraint.getLastDays() < 0) {
                throw new GqlJcrWrongInputException("lastDays value should not be negative");
            }
            Calendar cal = Calendar.getInstance();
            cal.add(5, -value.intValue());
            return handler.getQomFactory().comparison((DynamicOperand)handler.getQomFactory().propertyValue(selector, nodeConstraint.getProperty()), "jcr.operator.greater.than.or.equal.to", (StaticOperand)handler.getQomFactory().literal((Value)new ValueImpl(cal)));
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.LASTDAYS.getValue();
        }
    }

    private static class NodeConstraintConvertorExists
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorExists() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            Boolean value = nodeConstraint.getExists();
            if (value == null) {
                return null;
            }
            if (nodeConstraint.getProperty() == null) {
                throw new GqlJcrWrongInputException("'property' field is required");
            }
            PropertyExistence constraint = handler.getQomFactory().propertyExistence(selector, nodeConstraint.getProperty());
            return value != false ? constraint : handler.getQomFactory().not((Constraint)constraint);
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.EXISTS.getValue();
        }
    }

    private static class NodeConstraintConvertorGreaterThanOrEqualsTo
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorGreaterThanOrEqualsTo() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            String value = nodeConstraint.getGte();
            if (value == null) {
                return null;
            }
            this.validateNodeConstraintProperty(nodeConstraint);
            return handler.getQomFactory().comparison(handler.applyConstraintFunctions(nodeConstraint, selector), "jcr.operator.greater.than.or.equal.to", (StaticOperand)handler.getQomFactory().literal(handler.convertValueByParsingSuccess(value)));
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.GTE.getValue();
        }
    }

    private static class NodeConstraintConvertorLessThanOrEqualsTo
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorLessThanOrEqualsTo() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            String value = nodeConstraint.getLte();
            if (value == null) {
                return null;
            }
            this.validateNodeConstraintProperty(nodeConstraint);
            return handler.getQomFactory().comparison(handler.applyConstraintFunctions(nodeConstraint, selector), "jcr.operator.less.than.or.equal.to", (StaticOperand)handler.getQomFactory().literal(handler.convertValueByParsingSuccess(value)));
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.LTE.getValue();
        }
    }

    private static class NodeConstraintConvertorGreaterThan
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorGreaterThan() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            String value = nodeConstraint.getGt();
            if (value == null) {
                return null;
            }
            this.validateNodeConstraintProperty(nodeConstraint);
            return handler.getQomFactory().comparison(handler.applyConstraintFunctions(nodeConstraint, selector), "jcr.operator.greater.than", (StaticOperand)handler.getQomFactory().literal(handler.convertValueByParsingSuccess(value)));
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.GT.getValue();
        }
    }

    private static class NodeConstraintConvertorLessThan
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorLessThan() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            String value = nodeConstraint.getLt();
            if (value == null) {
                return null;
            }
            this.validateNodeConstraintProperty(nodeConstraint);
            return handler.getQomFactory().comparison(handler.applyConstraintFunctions(nodeConstraint, selector), "jcr.operator.less.than", (StaticOperand)handler.getQomFactory().literal(handler.convertValueByParsingSuccess(value)));
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.LT.getValue();
        }
    }

    private static class NodeConstraintConvertorNotEquals
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorNotEquals() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            String value = nodeConstraint.getNotEquals();
            if (value == null) {
                return null;
            }
            this.validateNodeConstraintProperty(nodeConstraint);
            return handler.getQomFactory().comparison(handler.applyConstraintFunctions(nodeConstraint, selector), "jcr.operator.not.equal.to", (StaticOperand)handler.getQomFactory().literal((Value)new ValueImpl(value)));
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.NOTEQUALS.getValue();
        }
    }

    private static class NodeConstraintConvertorEquals
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorEquals() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            String value = nodeConstraint.getEquals();
            if (value == null) {
                return null;
            }
            this.validateNodeConstraintProperty(nodeConstraint);
            return handler.getQomFactory().comparison(handler.applyConstraintFunctions(nodeConstraint, selector), "jcr.operator.equal.to", (StaticOperand)handler.getQomFactory().literal((Value)new ValueImpl(value)));
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.EQUALS.getValue();
        }
    }

    private static class NodeConstraintConvertorContains
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorContains() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            String value = nodeConstraint.getContains();
            if (value == null) {
                return null;
            }
            return handler.getQomFactory().fullTextSearch(selector, nodeConstraint.getProperty(), (StaticOperand)handler.getQomFactory().literal((Value)new ValueImpl(value)));
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.CONTAINS.getValue();
        }
    }

    private static class NodeConstraintConvertorLike
    extends NodeConstraintConvertor {
        private NodeConstraintConvertorLike() {
        }

        @Override
        public Constraint convert(GqlJcrNodeConstraintInput nodeConstraint, String selector, GqlConstraintHandler handler) throws RepositoryException {
            String value = nodeConstraint.getLike();
            if (value == null) {
                return null;
            }
            this.validateNodeConstraintProperty(nodeConstraint);
            return handler.getQomFactory().comparison(handler.applyConstraintFunctions(nodeConstraint, selector), "jcr.operator.like", (StaticOperand)handler.getQomFactory().literal((Value)new ValueImpl(value)));
        }

        @Override
        public String getFieldName() {
            return GqlJcrNodeConstraintInput.FieldNames.LIKE.getValue();
        }
    }

    private static abstract class NodeConstraintConvertor {
        private NodeConstraintConvertor() {
        }

        abstract Constraint convert(GqlJcrNodeConstraintInput var1, String var2, GqlConstraintHandler var3) throws RepositoryException;

        abstract String getFieldName();

        protected void validateNodeConstraintProperty(GqlJcrNodeConstraintInput nodeConstraint) {
            if (nodeConstraint.getProperty() == null && (nodeConstraint.getFunction() == null || !nodeConstraint.getFunction().equals((Object)GqlJcrNodeConstraintInput.QueryFunction.NODE_NAME) && !nodeConstraint.getFunction().equals((Object)GqlJcrNodeConstraintInput.QueryFunction.NODE_LOCAL_NAME))) {
                throw new GqlJcrWrongInputException("'property' field is required");
            }
        }
    }
}

