/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.execution.DataFetcherExceptionHandler;
import graphql.execution.DataFetcherExceptionHandlerParameters;
import graphql.execution.DataFetcherExceptionHandlerResult;
import graphql.execution.ExecutionPath;
import graphql.language.SourceLocation;
import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLError;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaDataFetchingExceptionHandler
implements DataFetcherExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(JahiaDataFetchingExceptionHandler.class);

    @NotNull
    public static GraphQLError transformException(Throwable exception, DataFetchingEnvironment environment) {
        return JahiaDataFetchingExceptionHandler.transformException(exception, environment.getExecutionStepInfo().getPath(), environment.getField().getSourceLocation());
    }

    public static GraphQLError transformException(Throwable exception, ExecutionPath path, SourceLocation sourceLocation) {
        if ((exception = JahiaDataFetchingExceptionHandler.unwrapException(exception)) instanceof BaseGqlClientException) {
            return new DXGraphQLError((BaseGqlClientException)((Object)exception), path.toList(), sourceLocation != null ? Collections.singletonList(sourceLocation) : new ArrayList<SourceLocation>());
        }
        return new ExceptionWhileDataFetching(path, exception, sourceLocation);
    }

    private static Throwable unwrapException(Throwable exception) {
        if (exception instanceof RuntimeException && exception.getCause() instanceof InvocationTargetException) {
            return ((InvocationTargetException)exception.getCause()).getTargetException();
        }
        return exception;
    }

    public DataFetcherExceptionHandlerResult onException(DataFetcherExceptionHandlerParameters handlerParameters) {
        Throwable exception = handlerParameters.getException();
        exception = JahiaDataFetchingExceptionHandler.unwrapException(exception);
        DataFetcherExceptionHandlerResult.Builder builder = DataFetcherExceptionHandlerResult.newResult();
        ExecutionPath path = handlerParameters.getPath();
        SourceLocation sourceLocation = handlerParameters.getField().getSingleField().getSourceLocation();
        GraphQLError error = JahiaDataFetchingExceptionHandler.transformException(exception, path, sourceLocation);
        builder.error(error);
        if (!(error instanceof DXGraphQLError)) {
            log.warn(error.getMessage(), exception);
        }
        return builder.build();
    }
}

