/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.acl;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.acl.GqlAclRole;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclEntry;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclRole;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclService;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeImpl;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.user.GqlPrincipal;
import org.jahia.modules.graphql.provider.dxm.user.PrincipalInput;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLName(value="GqlAclEntry")
@GraphQLDescription(value="ACL entry")
public class GqlAclEntry {
    Logger logger = LoggerFactory.getLogger(GqlAclEntry.class);
    @Inject
    @GraphQLOsgiService
    private JahiaAclService aclService;
    @Inject
    @GraphQLOsgiService
    private JahiaGroupManagerService groupService;
    @Inject
    @GraphQLOsgiService
    private JahiaUserManagerService userService;
    private final JahiaAclEntry aclEntry;

    public GqlAclEntry(JahiaAclEntry aclEntry) {
        this.aclEntry = aclEntry;
    }

    @GraphQLField
    @GraphQLDescription(value="Get principal for this entry")
    public GqlPrincipal getPrincipal() {
        String principalKey = this.aclEntry.getPrincipalKey();
        PrincipalInput principal = new PrincipalInput(principalKey);
        return principal.getPrincipal(this.aclEntry.getSiteKey(), this.userService, this.groupService);
    }

    @GraphQLField
    @GraphQLDescription(value="Get role for this entry")
    public GqlAclRole getRole() throws RepositoryException {
        String roleName = this.aclEntry.getRoleName();
        JahiaAclRole aclRole = this.aclService.getRole(roleName);
        return aclRole != null ? new GqlAclRole(this.aclService.getRole(roleName)) : null;
    }

    @GraphQLField
    @GraphQLDescription(value="Get node where this ACL entry originated from")
    public GqlJcrNode getInheritedFrom() {
        String fromPath = this.aclEntry.getFromPath();
        JCRNodeWrapper node = null;
        try {
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default");
            node = session.getNode(fromPath);
        }
        catch (RepositoryException e) {
            this.logger.error("Unable to fetch node {}", (Object)fromPath);
        }
        return node != null ? new GqlJcrNodeImpl(node) : null;
    }

    @GraphQLField
    @GraphQLDescription(value="Type of access for this ACL entry - one of GRANT, DENY or EXTERNAL")
    public String getAclEntryType() {
        return this.aclEntry.getType().toString();
    }

    @GraphQLField
    @GraphQLDescription(value="Return true if this ACL entry did not originate from this ACL's parent node")
    public boolean isInherited() {
        return this.aclEntry.isInherited();
    }

    @GraphQLField
    @GraphQLDescription(value="External permissions name ")
    public String getExternalPermissionsName() {
        return this.aclEntry.getExternalPermissionsName();
    }
}

