/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.acl.service;

import javax.jcr.RepositoryException;
import org.jahia.services.content.JCRNodeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaAclRoleProperties {
    private final Logger logger = LoggerFactory.getLogger(JahiaAclRoleProperties.class);
    private final String label;
    private final String description;

    public JahiaAclRoleProperties(JCRNodeWrapper n) {
        this.label = this.getProperty(n, "jcr:title");
        this.description = this.getProperty(n, "jcr:description");
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    private String getProperty(JCRNodeWrapper node, String propName) {
        try {
            if (node.hasProperty(propName)) {
                return node.getPropertyAsString(propName);
            }
        }
        catch (RepositoryException e) {
            this.logger.error("Missing property {} for node {}", (Object)propName, (Object)node);
        }
        return "";
    }
}

