/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.acl.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclEntry;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclRole;
import org.jahia.modules.graphql.provider.dxm.acl.service.JahiaAclService;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.usermanager.JahiaGroupManagerService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={JahiaAclService.class}, immediate=true)
public class JahiaAclServiceImpl
implements JahiaAclService {
    @Reference
    private JahiaUserManagerService userService;
    @Reference
    private JahiaGroupManagerService groupService;
    public static final String JCR_ROLEGROUP_TYPE = "j:roleGroup";
    public static final String JCR_ROLE_DEPENDENCIES_TYPE = "j:dependencies";
    public static final String REMOVE = "REMOVE";

    @Override
    public List<JahiaAclRole> getRoles() throws RepositoryException {
        ArrayList<JahiaAclRole> roles = new ArrayList<JahiaAclRole>();
        NodeIterator ni = this.execQuery("select * from [jnt:role] as r where isdescendantnode(r,['/roles'])");
        while (ni.hasNext()) {
            JCRNodeWrapper roleNode = (JCRNodeWrapper)ni.next();
            JahiaAclRole aclRole = new JahiaAclRole(roleNode);
            if (aclRole.isHidden() || aclRole.isPrivileged()) continue;
            roles.add(aclRole);
        }
        return roles;
    }

    @Override
    public JahiaAclRole getRole(String roleName) throws RepositoryException {
        NodeIterator ni = this.execQuery("select * from [jnt:role] as r where localname()='" + JCRContentUtils.sqlEncode((String)roleName) + "' and isdescendantnode(r,['/roles'])");
        if (ni.hasNext()) {
            JCRNodeWrapper roleNode = (JCRNodeWrapper)ni.next();
            return new JahiaAclRole(roleNode);
        }
        return null;
    }

    @Override
    public boolean grantRoles(JCRNodeWrapper jcrNode, String principalKey, List<String> roleNames) throws RepositoryException {
        if (!this.isValidPrincipal(jcrNode, principalKey)) {
            throw new ItemNotFoundException("Invalid user");
        }
        HashMap<String, String> roles = new HashMap<String, String>(roleNames.size());
        boolean breakInheritance = jcrNode.getAclInheritanceBreak();
        for (String r : roleNames) {
            roles.put(r, breakInheritance || !this.hasInheritedPermission(jcrNode, principalKey, r) ? "GRANT" : REMOVE);
        }
        return jcrNode.changeRoles(principalKey, roles);
    }

    @Override
    public boolean revokeRoles(JCRNodeWrapper jcrNode, String principalKey, List<String> roleNames) throws RepositoryException {
        HashMap<String, String> roles = new HashMap<String, String>(roleNames.size());
        boolean breakInheritance = jcrNode.getAclInheritanceBreak();
        for (String r : roleNames) {
            roles.put(r, breakInheritance || this.hasInheritedPermission(jcrNode, principalKey, r) ? "DENY" : REMOVE);
        }
        return jcrNode.changeRoles(principalKey, roles);
    }

    private boolean isValidPrincipal(JCRNodeWrapper jcrNode, String principalKey) throws RepositoryException {
        String siteKey = null;
        JCRSiteNode site = jcrNode.getResolveSite();
        if (site != null) {
            siteKey = site.getSiteKey();
        }
        String[] principalItems = principalKey.split(":");
        boolean isValid = false;
        if ("u".equals(principalItems[0])) {
            isValid = this.userService.lookupUser(principalItems[1], siteKey) != null;
        } else if ("g".equals(principalItems[0])) {
            isValid = this.groupService.lookupGroup(siteKey, principalItems[1]) != null;
        }
        return isValid;
    }

    @Override
    public boolean hasInheritedPermission(JCRNodeWrapper jcrNode, String principalKey, String roleName) {
        List<JahiaAclEntry> aclEntries = this.getAclEntries(jcrNode, principalKey);
        return aclEntries.stream().anyMatch(ace -> roleName.equals(ace.getRoleName()) && ace.isGrantType() && ace.isInherited());
    }

    @Override
    public List<JahiaAclEntry> getAclEntries(JCRNodeWrapper jcrNode, String principalKey) {
        ArrayList<JahiaAclEntry> result = new ArrayList<JahiaAclEntry>();
        Map acl = jcrNode.getAclEntries();
        if (acl == null) {
            return result;
        }
        List permissions = (List)acl.get(principalKey);
        if (permissions == null || permissions.isEmpty()) {
            return result;
        }
        for (String[] perm : permissions) {
            result.add(new JahiaAclEntry(jcrNode, principalKey, perm));
        }
        return result;
    }

    @Override
    public List<JahiaAclEntry> getAclEntries(JCRNodeWrapper jcrNode) {
        ArrayList<JahiaAclEntry> result = new ArrayList<JahiaAclEntry>();
        Map acl = jcrNode.getAclEntries();
        if (acl == null) {
            return result;
        }
        for (Map.Entry e : acl.entrySet()) {
            String principalKey = (String)e.getKey();
            for (String[] perm : (List)e.getValue()) {
                result.add(new JahiaAclEntry(jcrNode, principalKey, perm));
            }
        }
        return result;
    }

    private NodeIterator execQuery(String query) throws RepositoryException {
        JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("default");
        QueryManagerWrapper qm = session.getWorkspace().getQueryManager();
        Query q = qm.createQuery(query, "JCR-SQL2");
        return q.execute().getNodes();
    }
}

