/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.admin;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.jahia.modules.graphql.provider.dxm.admin.GqlClusterJournalLocalRevision;
import org.jahia.services.SpringContextSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLName(value="Journal")
@GraphQLDescription(value="Details about the Jahia cluster journal")
public class GqlClusterJournal {
    public static final Logger logger = LoggerFactory.getLogger(GqlClusterJournal.class);
    private final SessionFactory hibernateSessionFactory = (SessionFactory)SpringContextSingleton.getBean((String)"sessionFactory");

    @GraphQLField
    @GraphQLDescription(value="The latest revision of the journal on the cluster")
    public Long getGlobalRevision() {
        try (Session session = this.hibernateSessionFactory.openSession();){
            Long l = this.queryGlobalRevision(session);
            return l;
        }
    }

    @GraphQLField
    @GraphQLDescription(value="The latest revision of the journal on the current node")
    public GqlClusterJournalLocalRevision getLocalRevision() {
        String currentNodeServerId = System.getProperty("cluster.node.serverId");
        if (!StringUtils.isEmpty((String)currentNodeServerId)) {
            try (Session session = this.hibernateSessionFactory.openSession();){
                GqlClusterJournalLocalRevision gqlClusterJournalLocalRevision = this.queryLocalRevision(session, currentNodeServerId);
                return gqlClusterJournalLocalRevision;
            }
        }
        logger.warn("Unable to query localRevision, cluster.node.serverId system property not found");
        return null;
    }

    @GraphQLField
    @GraphQLDescription(value="The latest revisions of the journal for all cluster nodes")
    public List<GqlClusterJournalLocalRevision> getRevisions() {
        try (Session session = this.hibernateSessionFactory.openSession();){
            List<GqlClusterJournalLocalRevision> list = this.queryAllLocalRevisions(session);
            return list;
        }
    }

    @GraphQLField
    @GraphQLName(value="isClusterSync")
    @GraphQLDescription(value="Is the journal in sync across all nodes of a cluster")
    public Boolean isClusterSync() {
        try (Session session = this.hibernateSessionFactory.openSession();){
            Long globalRevision = this.queryGlobalRevision(session);
            if (globalRevision == null) {
                throw new IllegalStateException("Unable to check if cluster is sync, globalRevision not found");
            }
            List revisions = this.queryAllLocalRevisions(session).stream().map(GqlClusterJournalLocalRevision::getRevision).collect(Collectors.toList());
            revisions.add(globalRevision);
            Boolean bl = revisions.stream().distinct().count() <= 1L;
            return bl;
        }
    }

    private GqlClusterJournalLocalRevision queryLocalRevision(Session session, String journalId) {
        NativeQuery query = session.createSQLQuery("SELECT JOURNAL_ID, REVISION_ID FROM JR_J_LOCAL_REVISIONS WHERE JOURNAL_ID = :journalId");
        query.setParameter("journalId", (Object)journalId);
        Object result = query.uniqueResult();
        if (result instanceof Object[]) {
            return this.buildLocalRevision((Object[])result);
        }
        return null;
    }

    private List<GqlClusterJournalLocalRevision> queryAllLocalRevisions(Session session) {
        NativeQuery query = session.createSQLQuery("SELECT JOURNAL_ID, REVISION_ID FROM JR_J_LOCAL_REVISIONS");
        List results = query.getResultList();
        if (results != null) {
            return results.stream().filter(obj -> obj instanceof Object[]).map(obj -> (Object[])obj).map(this::buildLocalRevision).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Long queryGlobalRevision(Session session) {
        NativeQuery query = session.createSQLQuery("SELECT REVISION_ID FROM JR_J_GLOBAL_REVISION");
        Object result = query.uniqueResult();
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        return null;
    }

    private GqlClusterJournalLocalRevision buildLocalRevision(Object[] queryResult) {
        if (queryResult != null && queryResult.length > 1 && queryResult[1] instanceof Number) {
            return new GqlClusterJournalLocalRevision(queryResult[0].toString(), ((Number)queryResult[1]).longValue());
        }
        return null;
    }
}

