/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.admin;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.api.Constants;
import org.jahia.bin.Jahia;
import org.jahia.modules.graphql.provider.dxm.admin.GqlJahiaDatabase;
import org.jahia.modules.graphql.provider.dxm.admin.GqlJahiaSystem;
import org.jahia.modules.graphql.provider.dxm.admin.GqlJahiaVersion;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlConfigurationQuery;
import org.jahia.modules.graphql.provider.dxm.scheduler.GqlScheduler;
import org.jahia.utils.DatabaseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLName(value="JahiaAdminQuery")
@GraphQLDescription(value="Jahia admin queries root")
public class GqlJahiaAdminQuery {
    public static final Logger logger = LoggerFactory.getLogger(GqlJahiaAdminQuery.class);
    public static final String JAHIA_PROJECT_VERSION;

    @GraphQLField
    @GraphQLDescription(value="Version of the running Jahia instance")
    public GqlJahiaVersion getVersion() {
        GqlJahiaVersion gqlJahiaVersion = new GqlJahiaVersion();
        gqlJahiaVersion.setRelease(Optional.ofNullable(JAHIA_PROJECT_VERSION).orElse(""));
        try {
            gqlJahiaVersion.setBuild(MethodUtils.invokeExactStaticMethod(Jahia.class, (String)"getBuildNumber", (Object[])new Object[0]).toString());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.warn("Cannot get build number");
        }
        gqlJahiaVersion.setSnapshot(Optional.ofNullable(JAHIA_PROJECT_VERSION).orElse("").contains("SNAPSHOT"));
        Date date = null;
        try {
            date = DateFormat.getDateTimeInstance(1, 1, Locale.ENGLISH).parse(Jahia.getBuildDate());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            gqlJahiaVersion.setBuildDate(ISO8601.format((Calendar)calendar));
        }
        catch (ParseException e) {
            logger.warn("Exception while parsing build date", (Throwable)e);
        }
        return gqlJahiaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GraphQLField
    @GraphQLDescription(value="Details about the database Jahia is connected to")
    public GqlJahiaDatabase getDatabase() throws SQLException {
        GqlJahiaDatabase gqlJahiaDatabase = new GqlJahiaDatabase();
        gqlJahiaDatabase.setType(DatabaseUtils.getDatabaseType().toString());
        Connection connection = null;
        try {
            connection = DatabaseUtils.getDatasource().getConnection();
            DatabaseMetaData metadata = connection.getMetaData();
            gqlJahiaDatabase.setName(metadata.getDatabaseProductName());
            gqlJahiaDatabase.setVersion(metadata.getDatabaseProductVersion());
            gqlJahiaDatabase.setDriverName(metadata.getDriverName());
            gqlJahiaDatabase.setDriverVersion(metadata.getDriverVersion());
        }
        catch (Exception e) {
            logger.error("Unable to get database information . Cause: " + e.getMessage(), (Throwable)e);
        }
        finally {
            DatabaseUtils.closeQuietly((Object)connection);
        }
        return gqlJahiaDatabase;
    }

    @GraphQLField
    @GraphQLDescription(value="Details about the system hosting Jahia")
    public GqlJahiaSystem getSystem() {
        return new GqlJahiaSystem();
    }

    @GraphQLField
    @GraphQLDescription(value="Read an OSGi configuration")
    public GqlConfigurationQuery configuration(@GraphQLName(value="pid") @GraphQLDescription(value="Configuration pid ot factory pid") @GraphQLNonNull String pid, @GraphQLName(value="identifier") @GraphQLDescription(value="If factory pid, configuration identifier (filename suffix)") String identifier) {
        return new GqlConfigurationQuery(pid, identifier);
    }

    @GraphQLField
    @GraphQLDescription(value="Get jobs scheduler")
    public GqlScheduler getScheduler() {
        return new GqlScheduler();
    }

    static {
        Properties p = new Properties();
        try {
            p.load(Constants.class.getClassLoader().getResourceAsStream("version.properties"));
        }
        catch (IOException e) {
            logger.warn("Exception while retrieving JAHIA_PROJECT_VERSION", (Throwable)e);
            throw new RuntimeException(e);
        }
        JAHIA_PROJECT_VERSION = p.getProperty("version");
    }
}

