/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DXGraphQLConfig.class, ManagedServiceFactory.class}, property={"service.pid=org.jahia.modules.graphql.provider"}, immediate=true)
public class DXGraphQLConfig
implements ManagedServiceFactory {
    private static Logger logger = LoggerFactory.getLogger(DXGraphQLConfig.class);
    private static final String PERMISSION_PREFIX = "permission.";
    private static final String TYPE_PREFIX = "type.";
    private static final String CORS_ORIGINS = "http.cors.allow-origin";
    private static final String NODE_LIMIT = "graphql.fields.node.limit";
    private Map<String, List<String>> keysByPid = new HashMap<String, List<String>>();
    private Map<String, String> permissions = new HashMap<String, String>();
    private Set<String> corsOrigins = new HashSet<String>();
    private Map<String, Set<String>> corsOriginByPid = new HashMap<String, Set<String>>();
    private int nodeLimit = 5000;
    private ComponentContext componentContext;

    public String getName() {
        return "DX GraphQL configurations";
    }

    public void updated(String pid, Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            return;
        }
        this.deleted(pid);
        ArrayList<String> keysForPid = new ArrayList<String>();
        this.keysByPid.put(pid, keysForPid);
        this.corsOriginByPid.remove(pid);
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            boolean addKey = true;
            String value = (String)properties.get(key);
            if (key.startsWith(PERMISSION_PREFIX) && value != null) {
                for (String p : this.keysByPid.keySet()) {
                    if (StringUtils.equals((String)p, (String)pid) || !this.keysByPid.get(p).contains(key)) continue;
                    addKey = false;
                    logger.warn("Unable to register permission for {} because it has been already registered by the config with id {}", (Object)key, (Object)p);
                    break;
                }
                if (!addKey) continue;
                this.permissions.put(key.substring(PERMISSION_PREFIX.length()), value);
                keysForPid.add(key);
                continue;
            }
            if (key.equals(CORS_ORIGINS)) {
                this.corsOriginByPid.put(pid, new HashSet<String>(Arrays.asList(StringUtils.split((String)value, (String)" ,"))));
                continue;
            }
            if (key.equals(NODE_LIMIT) && properties.get("felix.fileinstall.filename") != null && properties.get("felix.fileinstall.filename").toString().endsWith("org.jahia.modules.graphql.provider-default.cfg")) {
                try {
                    int newNodeLimit = Integer.parseInt(value);
                    if (newNodeLimit < 0) {
                        throw new ConfigurationException(key, "Node limit must be a positive integer");
                    }
                    if (newNodeLimit == this.nodeLimit) continue;
                    logger.info("Node limit has been updated to {} by pid {} (file/config) {}.cfg", new Object[]{newNodeLimit, pid, pid});
                    this.nodeLimit = newNodeLimit;
                    PaginationHelper.updateLimit(this.nodeLimit);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException(key, "Node limit must be a positive integer");
                }
            }
            keysForPid.add(key);
        }
        this.corsOrigins = this.corsOriginByPid.keySet().stream().flatMap(k -> this.corsOriginByPid.get(k).stream()).collect(Collectors.toSet());
    }

    public void deleted(String pid) {
        List<String> keysForPid = this.keysByPid.get(pid);
        if (keysForPid != null) {
            for (String key : keysForPid) {
                if (key.startsWith(PERMISSION_PREFIX)) {
                    this.permissions.remove(key.substring(PERMISSION_PREFIX.length()));
                    continue;
                }
                if (!key.equals(CORS_ORIGINS)) continue;
                this.corsOriginByPid.remove(pid);
                this.corsOrigins = this.corsOriginByPid.keySet().stream().flatMap(k -> this.corsOriginByPid.get(k).stream()).collect(Collectors.toSet());
            }
            this.keysByPid.remove(pid);
        }
    }

    public Map<String, String> getPermissions() {
        return this.permissions;
    }

    public Set<String> getCorsOrigins() {
        return this.corsOrigins;
    }

    public int getNodeLimit() {
        return this.nodeLimit;
    }
}

