/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.content;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.jcr.Node;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrReproducibleNodeInput;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;

@GraphQLTypeExtension(value=GqlJcrMutation.class)
@GraphQLDescription(value="Content management related extensions of JCR mutations")
public class ContentManagementGqlJcrMutationExtension {
    private GqlJcrMutation mutation;

    public ContentManagementGqlJcrMutationExtension(GqlJcrMutation mutation) {
        this.mutation = mutation;
    }

    @GraphQLField
    @GraphQLDescription(value="Paste a single node to a different parent node")
    public GqlJcrNodeMutation pasteNode(@GraphQLName(value="mode") @GraphQLNonNull @GraphQLDescription(value="Paste mode, either COPY or MOVE") PasteMode mode, @GraphQLName(value="pathOrId") @GraphQLNonNull @GraphQLDescription(value="Path or UUID of the node to be pasted") String pathOrId, @GraphQLName(value="destParentPathOrId") @GraphQLNonNull @GraphQLDescription(value="Path or UUID of the destination parent node to paste the node to") String destParentPathOrId, @GraphQLName(value="destName") @GraphQLDescription(value="The name of the node at the new location or null if its current name should be preserved") String destName, @GraphQLName(value="childNodeTypesToSkip") @GraphQLDescription(value="The child node types that should be skipped during copy") List<String> childNodeTypesToSkip, @GraphQLName(value="namingConflictResolution") @GraphQLDefaultValue(value=SupplierFail.class) @GraphQLDescription(value="The way to deal with duplicate node names when they are not allowed, either FAIL or RENAME") NodeNamingConflictResolutionStrategy namingConflictResolution) throws BaseGqlClientException {
        destName = this.getNodeName(pathOrId, destParentPathOrId, destName, namingConflictResolution);
        if (mode == PasteMode.COPY) {
            return this.mutation.copyNode(pathOrId, destParentPathOrId, destName, childNodeTypesToSkip);
        }
        if (mode == PasteMode.MOVE) {
            return this.mutation.moveNode(pathOrId, destParentPathOrId, destName);
        }
        throw new UnsupportedOperationException();
    }

    @GraphQLField
    @GraphQLDescription(value="Paste multiple nodes to different parent node(s)")
    public Collection<GqlJcrNodeMutation> pasteNodes(@GraphQLName(value="mode") @GraphQLNonNull @GraphQLDescription(value="Paste mode, either COPY or MOVE") PasteMode mode, @GraphQLName(value="nodes") @GraphQLNonNull @GraphQLDescription(value="Info about nodes to paste and their new parent node(s)") @GraphQLNonNull Collection<@GraphQLNonNull GqlJcrReproducibleNodeInput> nodes, @GraphQLName(value="childNodeTypesToSkip") @GraphQLDescription(value="The child node types that should be skipped during copy") List<String> childNodeTypesToSkip, @GraphQLName(value="namingConflictResolution") @GraphQLDefaultValue(value=SupplierFail.class) @GraphQLDescription(value="The way to deal with duplicate node names when they are not allowed, either FAIL or RENAME") NodeNamingConflictResolutionStrategy namingConflictResolution) throws BaseGqlClientException {
        ArrayList<GqlJcrNodeMutation> result = new ArrayList<GqlJcrNodeMutation>(nodes.size());
        for (GqlJcrReproducibleNodeInput node : nodes) {
            result.add(this.pasteNode(mode, node.getPathOrId(), node.getDestParentPathOrId(), node.getDestName(), childNodeTypesToSkip, namingConflictResolution));
        }
        return result;
    }

    private String getNodeName(String pathOrId, String destParentPathOrId, String destName, NodeNamingConflictResolutionStrategy namingConflictResolution) {
        JCRSessionWrapper session = this.mutation.getSession();
        if (destName == null) {
            JCRNodeWrapper node = GqlJcrMutation.getNodeFromPathOrId(session, pathOrId);
            destName = node.getName();
        }
        if (namingConflictResolution == NodeNamingConflictResolutionStrategy.RENAME) {
            JCRNodeWrapper destParentNode = GqlJcrMutation.getNodeFromPathOrId(session, destParentPathOrId);
            destName = JCRContentUtils.findAvailableNodeName((Node)destParentNode, (String)destName);
        }
        return destName;
    }

    public static class SupplierFail
    implements Supplier<Object> {
        @Override
        public NodeNamingConflictResolutionStrategy get() {
            return NodeNamingConflictResolutionStrategy.FAIL;
        }
    }

    public static enum NodeNamingConflictResolutionStrategy {
        FAIL,
        RENAME;

    }

    public static enum PasteMode {
        COPY,
        MOVE;

    }
}

