/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.image;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.osgi.BundleUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.image.Image;
import org.jahia.services.image.JahiaImageService;
import pl.touk.throwing.ThrowingBiConsumer;
import pl.touk.throwing.exception.WrappedException;

public class GqlJcrImageTransformMutation {
    private JCRNodeWrapper node;
    private String name;
    private String targetPath;
    private JahiaImageService imageService;

    public GqlJcrImageTransformMutation(JCRNodeWrapper node, String name, String targetPath) throws RepositoryException {
        this.node = node;
        this.name = name != null ? name : node.getName();
        this.targetPath = targetPath != null ? targetPath : node.getParent().getPath();
        this.imageService = (JahiaImageService)BundleUtils.getOsgiService(JahiaImageService.class, null);
    }

    @GraphQLField
    @GraphQLDescription(value="The transformed node")
    public GqlJcrNode getNode() {
        try {
            return SpecializedTypesHandler.getNode(this.node);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Rotate an image under the current node")
    public boolean rotateImage(@GraphQLName(value="angle") @GraphQLNonNull @GraphQLDescription(value="angle in degrees") double angle) {
        try {
            this.node = this.doOperation(this.node, ThrowingBiConsumer.unchecked((image, f) -> this.imageService.rotateImage(image, f, angle)));
        }
        catch (WrappedException e) {
            throw new DataFetchingException(e.getCause());
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Resize an image under the current node")
    public boolean resizeImage(@GraphQLName(value="height") @GraphQLNonNull @GraphQLDescription(value="new height") int height, @GraphQLName(value="width") @GraphQLNonNull @GraphQLDescription(value="new width") int width) {
        try {
            this.node = this.doOperation(this.node, ThrowingBiConsumer.unchecked((image, f) -> this.imageService.resizeImage(image, f, width, height, JahiaImageService.ResizeType.SCALE_TO_FILL)));
        }
        catch (WrappedException e) {
            throw new DataFetchingException(e.getCause());
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Crop an image under the current node")
    public boolean cropImage(@GraphQLName(value="height") @GraphQLNonNull @GraphQLDescription(value="new height") int height, @GraphQLName(value="width") @GraphQLNonNull @GraphQLDescription(value="new width") int width, @GraphQLName(value="top") @GraphQLNonNull @GraphQLDescription(value="top") int top, @GraphQLName(value="left") @GraphQLNonNull @GraphQLDescription(value="left") int left) {
        try {
            this.node = this.doOperation(this.node, ThrowingBiConsumer.unchecked((image, f) -> this.imageService.cropImage(image, f, top, left, width, height)));
        }
        catch (WrappedException e) {
            throw new DataFetchingException(e.getCause());
        }
        return true;
    }

    private JCRNodeWrapper doOperation(JCRNodeWrapper jcrNode, BiConsumer<Image, File> operation) {
        JCRNodeWrapper jCRNodeWrapper;
        BufferedInputStream fis = null;
        File f = null;
        try {
            Image image = this.imageService.getImage(jcrNode);
            String fileExtension = FilenameUtils.getExtension((String)this.name);
            fileExtension = fileExtension != null && !fileExtension.equals("") ? "." + fileExtension : null;
            f = File.createTempFile("image", fileExtension);
            operation.accept(image, f);
            fis = new BufferedInputStream(new FileInputStream(f));
            jCRNodeWrapper = jcrNode.getSession().getNode(this.targetPath).uploadFile(this.name, (InputStream)fis, jcrNode.getFileContent().getContentType());
        }
        catch (IOException | RepositoryException e) {
            try {
                throw new DataFetchingException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                if (f != null) {
                    f.delete();
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        if (f != null) {
            f.delete();
        }
        return jCRNodeWrapper;
    }
}

