/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.locking;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.jahia.modules.graphql.provider.dxm.locking.GqlLockDetail;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.usermanager.JahiaUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GraphQLName(value="LockInfo")
@GraphQLDescription(value="Information on node lock")
public class GqlLockInfo {
    public static final Logger logger = LoggerFactory.getLogger(GqlLockInfo.class);
    private JCRNodeWrapper node;

    public GqlLockInfo(JCRNodeWrapper node) {
        this.node = node;
    }

    @GraphQLField
    @GraphQLDescription(value="Is node lockable")
    public boolean isLockable() {
        return this.node.isLockable();
    }

    @GraphQLField
    @GraphQLDescription(value="Can the node be locked")
    public boolean canLock() {
        try {
            if (this.isLockable()) {
                JahiaUser jahiaUser = this.node.getSession().getUser();
                if (jahiaUser.isRoot()) {
                    return true;
                }
                return this.isUserLockOwner();
            }
        }
        catch (RepositoryException ex) {
            logger.error("Failed to access repository", (Throwable)ex);
            return false;
        }
        return false;
    }

    @GraphQLField
    @GraphQLDescription(value="Can the node be unlocked")
    public boolean canUnlock() {
        try {
            if (this.node.isLocked()) {
                JahiaUser jahiaUser = this.node.getSession().getUser();
                if (jahiaUser.isRoot()) {
                    return true;
                }
                return this.isUserLockOwner();
            }
        }
        catch (RepositoryException ex) {
            logger.error("Failed to access repository", (Throwable)ex);
            return false;
        }
        return false;
    }

    @GraphQLField
    @GraphQLName(value="details")
    @GraphQLDescription(value="Is node lockable")
    public List<GqlLockDetail> getDetails(@GraphQLName(value="language") @GraphQLDescription(value="language in which to retrieve details") String language) {
        LinkedList<GqlLockDetail> lockDetails = new LinkedList<GqlLockDetail>();
        try {
            List lockInfo;
            Map lockInfos = this.node.getLockInfos();
            if (language != null && lockInfos.containsKey(language)) {
                lockInfo = (List)lockInfos.get(language);
            } else {
                language = null;
                lockInfo = (List)lockInfos.get(null);
            }
            if (lockInfo != null) {
                for (String lock : lockInfo) {
                    lockDetails.add(new GqlLockDetail(language, StringUtils.substringBefore((String)lock, (String)":"), StringUtils.substringAfter((String)lock, (String)":")));
                }
            }
        }
        catch (RepositoryException ex) {
            logger.error("Failed to access repository", (Throwable)ex);
        }
        return lockDetails;
    }

    private boolean isUserLockOwner() throws RepositoryException {
        if (this.node.getLock().getLockOwner() != null) {
            String[] lockOwners;
            for (String lockOwner : lockOwners = this.node.getLock().getLockOwner().split(" ")) {
                if (!this.node.getSession().getUserID().equals(lockOwner)) continue;
                return true;
            }
        }
        return false;
    }
}

