/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.locking;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import java.util.function.Supplier;
import javax.jcr.RepositoryException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;

@GraphQLTypeExtension(value=GqlJcrNodeMutation.class)
public class LockJCRNodeMutationExtension {
    private GqlJcrNodeMutation nodeMutation;

    public LockJCRNodeMutationExtension(GqlJcrNodeMutation nodeMutation) throws GqlJcrWrongInputException {
        this.nodeMutation = nodeMutation;
    }

    @GraphQLField
    @GraphQLDescription(value="Lock the node")
    public boolean lock(@GraphQLName(value="type") @GraphQLDefaultValue(value=DefaultLockTypeProvider.class) @GraphQLDescription(value="Type of lock, defaults to user") String type) {
        try {
            JCRNodeWrapper nodeToLock = this.nodeMutation.getNode().getNode();
            return nodeToLock.lockAndStoreToken(type);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Unlock the node")
    public boolean unlock(@GraphQLName(value="type") @GraphQLDefaultValue(value=DefaultLockTypeProvider.class) @GraphQLDescription(value="Type of lock, defaults to user") String type) {
        try {
            JCRNodeWrapper nodeToUnlock = this.nodeMutation.getNode().getNode();
            if (!nodeToUnlock.isLocked()) {
                return false;
            }
            if (nodeToUnlock.getSession().getUser().isRoot()) {
                String lockOwner = nodeToUnlock.getLockOwner();
                nodeToUnlock.unlock(type, lockOwner);
            } else {
                nodeToUnlock.unlock(type);
            }
            return !nodeToUnlock.isLocked();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Unlock all nodes under the specified node")
    public boolean clearAllLocks() {
        try {
            JCRNodeWrapper nodeToUnlock = this.nodeMutation.getNode().getNode();
            if (nodeToUnlock.hasPermission("clearLock")) {
                JCRSessionWrapper systemSession = JCRTemplate.getInstance().getSessionFactory().getCurrentSystemSession("default", nodeToUnlock.getSession().getLocale(), nodeToUnlock.getSession().getFallbackLocale());
                systemSession.getNode(nodeToUnlock.getPath()).clearAllLocks();
            }
            return !nodeToUnlock.isLocked();
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException((Throwable)e);
        }
    }

    public static class DefaultLockTypeProvider
    implements Supplier<Object> {
        @Override
        public String get() {
            return "user";
        }
    }
}

