/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.jahia.api.Constants;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLFieldCompleter;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrMutationSupport;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeMutation;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNodeWithParentInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrQuery;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrReproducibleNodeInput;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.node.NodeMutationConstraintViolationHandler;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.QueryManagerWrapper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.importexport.ReferencesHelper;
import org.jahia.services.query.QueryWrapper;
import org.jahia.settings.SettingsBean;

@GraphQLName(value="JCRMutation")
@GraphQLDescription(value="JCR Mutations")
public class GqlJcrMutation
extends GqlJcrMutationSupport
implements DXGraphQLFieldCompleter {
    private String workspace;
    private boolean save = true;

    public GqlJcrMutation(String workspace, boolean save) {
        this.workspace = workspace;
        this.save = save;
    }

    @GraphQLField
    @GraphQLDescription(value="Creates a new JCR node under the specified parent")
    public GqlJcrNodeMutation addNode(@GraphQLName(value="parentPathOrId") @GraphQLNonNull @GraphQLDescription(value="The path or id of the parent node") String parentPathOrId, @GraphQLName(value="name") @GraphQLNonNull @GraphQLDescription(value="The name of the node to create") String name, @GraphQLName(value="primaryNodeType") @GraphQLNonNull @GraphQLDescription(value="The primary node type of the node to create") String primaryNodeType, @GraphQLName(value="useAvailableNodeName") @GraphQLDescription(value="If true, use the next available name for a node, appending if needed numbers. Default is false") Boolean useAvailableNodeName, @GraphQLName(value="mixins") @GraphQLDescription(value="The collection of mixin type names") Collection<String> mixins, @GraphQLName(value="properties") Collection<GqlJcrPropertyInput> properties, @GraphQLName(value="children") Collection<GqlJcrNodeInput> children) throws BaseGqlClientException {
        GqlJcrNodeInput node = new GqlJcrNodeInput(name, primaryNodeType, useAvailableNodeName, mixins, properties, children);
        return new GqlJcrNodeMutation(GqlJcrMutation.addNode(GqlJcrMutation.getNodeFromPathOrId(this.getSession(), parentPathOrId), node));
    }

    @GraphQLField
    @GraphQLDescription(value="Batch creates a number of new JCR nodes under the specified parent")
    public Collection<GqlJcrNodeMutation> addNodesBatch(@GraphQLName(value="nodes") @GraphQLNonNull @GraphQLDescription(value="The collection of nodes to create") Collection<GqlJcrNodeWithParentInput> nodes) throws BaseGqlClientException {
        ArrayList<GqlJcrNodeMutation> result = new ArrayList<GqlJcrNodeMutation>();
        for (GqlJcrNodeWithParentInput node : nodes) {
            result.add(new GqlJcrNodeMutation(GqlJcrMutation.addNode(GqlJcrMutation.getNodeFromPathOrId(this.getSession(), node.getParentPathOrId()), node)));
        }
        return result;
    }

    @GraphQLField
    @GraphQLDescription(value="Mutates an existing node, based on path or id")
    public GqlJcrNodeMutation mutateNode(@GraphQLName(value="pathOrId") @GraphQLNonNull @GraphQLDescription(value="The path or id of the node to mutate") String pathOrId) throws BaseGqlClientException {
        return new GqlJcrNodeMutation(GqlJcrMutation.getNodeFromPathOrId(this.getSession(), pathOrId));
    }

    @GraphQLField
    @GraphQLDescription(value="Mutates a set of existing nodes, based on path or id")
    public Collection<GqlJcrNodeMutation> mutateNodes(@GraphQLName(value="pathsOrIds") @GraphQLNonNull @GraphQLDescription(value="The paths or id ofs the nodes to mutate") Collection<String> pathsOrIds) throws BaseGqlClientException {
        ArrayList<GqlJcrNodeMutation> result = new ArrayList<GqlJcrNodeMutation>();
        for (String pathOrId : pathsOrIds) {
            result.add(new GqlJcrNodeMutation(GqlJcrMutation.getNodeFromPathOrId(this.getSession(), pathOrId)));
        }
        return result;
    }

    @GraphQLField
    @GraphQLDescription(value="Mutates a set of existing nodes, based on query execution")
    public Collection<GqlJcrNodeMutation> mutateNodesByQuery(@GraphQLName(value="query") @GraphQLNonNull @GraphQLDescription(value="The query string") String query, @GraphQLName(value="queryLanguage") @GraphQLDefaultValue(value=GqlJcrQuery.QueryLanguageDefaultValue.class) @GraphQLDescription(value="The query language") GqlJcrQuery.QueryLanguage queryLanguage, @GraphQLName(value="limit") @GraphQLDescription(value="The maximum size of the result set") Long limit, @GraphQLName(value="offset") @GraphQLDescription(value="The start offset of the result set") Long offset) throws BaseGqlClientException {
        JCRNodeIteratorWrapper nodes;
        LinkedList<GqlJcrNodeMutation> result = new LinkedList<GqlJcrNodeMutation>();
        try {
            QueryManagerWrapper queryManager = this.getSession().getWorkspace().getQueryManager();
            QueryWrapper q = queryManager.createQuery(query, queryLanguage.getJcrQueryLanguage());
            if (limit != null && limit > 0L) {
                q.setLimit(limit.longValue());
            }
            if (offset != null && offset > 0L) {
                q.setOffset(offset.longValue());
            }
            nodes = q.execute().getNodes();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        while (nodes.hasNext()) {
            JCRNodeWrapper node = (JCRNodeWrapper)nodes.next();
            result.add(new GqlJcrNodeMutation(node));
        }
        return result;
    }

    @GraphQLField
    @GraphQLDescription(value="Delete an existing node and all its children")
    public boolean deleteNode(@GraphQLName(value="pathOrId") @GraphQLNonNull @GraphQLDescription(value="The path or id of the node to delete") String pathOrId) throws BaseGqlClientException {
        try {
            GqlJcrMutation.getNodeFromPathOrId(this.getSession(), pathOrId).remove();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Marks the existing node and all its children for deletion")
    public boolean markNodeForDeletion(@GraphQLName(value="pathOrId") @GraphQLNonNull @GraphQLDescription(value="The path or id of the node to mark for deletion") String pathOrId, @GraphQLName(value="comment") @GraphQLDescription(value="Optional deletion comment") String comment) throws BaseGqlClientException {
        try {
            GqlJcrMutation.getNodeFromPathOrId(this.getSession(), pathOrId).markForDeletion(comment);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Unmarks the specified node and all its children for deletion")
    public boolean unmarkNodeForDeletion(@GraphQLName(value="pathOrId") @GraphQLNonNull @GraphQLDescription(value="The path or id of the node to unmark for deletion") String pathOrId) throws BaseGqlClientException {
        try {
            GqlJcrMutation.getNodeFromPathOrId(this.getSession(), pathOrId).unmarkForDeletion();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Import a file under the specified parent")
    public boolean importContent(@GraphQLName(value="parentPathOrId") @GraphQLNonNull @GraphQLDescription(value="The path or id of the parent node") String parentPathOrId, @GraphQLName(value="file") @GraphQLNonNull @GraphQLDescription(value="Name of the request part that contains desired import file body") String file, @GraphQLName(value="rootBehaviour") @GraphQLDefaultValue(value=DefaultRootBehaviour.class) @GraphQLDescription(value="Specify the behaviour in case of existing content, possible values are in the DocumentViewImportHandler class") Integer rootBehaviour, DataFetchingEnvironment environment) throws BaseGqlClientException {
        GqlJcrMutation.importFileUpload(file, GqlJcrMutation.getNodeFromPathOrId(this.getSession(), parentPathOrId), rootBehaviour, environment);
        return true;
    }

    @GraphQLField
    @GraphQLDescription(value="Copy a single node to a different parent node")
    public GqlJcrNodeMutation copyNode(@GraphQLName(value="pathOrId") @GraphQLNonNull @GraphQLDescription(value="Path or UUID of the node to be copied") String pathOrId, @GraphQLName(value="destParentPathOrId") @GraphQLNonNull @GraphQLDescription(value="Path or UUID of the destination parent node to copy the node to") String destParentPathOrId, @GraphQLName(value="destName") @GraphQLDescription(value="The name of the node at the new location or null if its current name should be preserved") String destName, @GraphQLName(value="childNodeTypesToSkip") @GraphQLDescription(value="The child node types that should be skipped during copy") List<String> childNodeTypesToSkip) throws BaseGqlClientException {
        JCRNodeWrapper destNode;
        JCRNodeWrapper destParentNode = GqlJcrMutation.getNodeFromPathOrId(this.getSession(), destParentPathOrId);
        JCRNodeWrapper node = GqlJcrMutation.getNodeFromPathOrId(this.getSession(), pathOrId);
        if (destName == null) {
            destName = node.getName();
        }
        GqlJcrMutation.verifyNodeReproductionTarget(node, destParentNode);
        try {
            if (childNodeTypesToSkip == null || childNodeTypesToSkip.isEmpty()) {
                if (!node.copy(destParentNode, destName, true, JCRNodeWrapper.NodeNamingConflictResolutionStrategy.FAIL)) {
                    throw new DataFetchingException("Error copying node '" + node.getPath() + "' to '" + destParentNode.getPath() + "'");
                }
            } else {
                JCRNodeWrapper newNode = destParentNode.addNode(destName, node.getPrimaryNodeTypeName());
                for (ExtendedNodeType mixin : node.getMixinNodeTypes()) {
                    if (Constants.forbiddenMixinToCopy.contains(mixin.getName())) continue;
                    newNode.addMixin(mixin.getName());
                }
                HashMap references = new HashMap();
                node.copyProperties(newNode, references);
                ReferencesHelper.resolveCrossReferences((JCRSessionWrapper)node.getSession(), references, (boolean)false);
                HashSet<String> ignoreNodeTypes = new HashSet<String>(childNodeTypesToSkip);
                ignoreNodeTypes.addAll(Constants.forbiddenChildNodeTypesToCopy);
                for (JCRNodeWrapper childNode : node.getNodes()) {
                    childNode.copy(newNode, childNode.getName(), true, new ArrayList<String>(ignoreNodeTypes), SettingsBean.getInstance().getImportMaxBatch());
                }
                ReferencesHelper.resolveCrossReferences((JCRSessionWrapper)this.getSession(), references, (boolean)false);
            }
            destNode = destParentNode.getNode(destName);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return new GqlJcrNodeMutation(destNode);
    }

    @GraphQLField
    @GraphQLDescription(value="Move a single node to a different parent node")
    public GqlJcrNodeMutation moveNode(@GraphQLName(value="pathOrId") @GraphQLNonNull @GraphQLDescription(value="Path or UUID of the node to be moved") String pathOrId, @GraphQLName(value="destParentPathOrId") @GraphQLNonNull @GraphQLDescription(value="Path or UUID of the destination parent node to move the node to") String destParentPathOrId, @GraphQLName(value="destName") @GraphQLDescription(value="The name of the node at the new location or null if its current name should be preserved") String destName) throws BaseGqlClientException {
        JCRNodeWrapper destNode;
        JCRNodeWrapper destParentNode = GqlJcrMutation.getNodeFromPathOrId(this.getSession(), destParentPathOrId);
        JCRNodeWrapper node = GqlJcrMutation.getNodeFromPathOrId(this.getSession(), pathOrId);
        if (destName == null) {
            destName = node.getName();
        }
        GqlJcrMutation.verifyNodeReproductionTarget(node, destParentNode);
        try {
            String destPath = destParentNode.getPath() + '/' + destName;
            this.getSession().move(node.getPath(), destPath);
            destNode = destParentNode.getNode(destName);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return new GqlJcrNodeMutation(destNode);
    }

    @GraphQLField
    @GraphQLDescription(value="Copy multiple nodes to different parent node(s)")
    public Collection<GqlJcrNodeMutation> copyNodes(@GraphQLName(value="nodes") @GraphQLNonNull @GraphQLNonNull Collection<@GraphQLNonNull GqlJcrReproducibleNodeInput> nodes, final @GraphQLName(value="childNodeTypesToSkip") @GraphQLDescription(value="The child node types that should be skipped during copy") List<String> childNodeTypesToSkip) throws BaseGqlClientException {
        return this.reproduceNodes(nodes, new NodeReproducer(){

            @Override
            public GqlJcrNodeMutation reproduce(GqlJcrReproducibleNodeInput node) {
                return GqlJcrMutation.this.copyNode(node.getPathOrId(), node.getDestParentPathOrId(), node.getDestName(), childNodeTypesToSkip);
            }

            @Override
            public String getOperationName() {
                return "copying";
            }
        });
    }

    @GraphQLField
    @GraphQLDescription(value="Move multiple nodes to different parent node(s)")
    public Collection<GqlJcrNodeMutation> moveNodes(@GraphQLName(value="nodes") @GraphQLNonNull @GraphQLNonNull Collection<@GraphQLNonNull GqlJcrReproducibleNodeInput> nodes) throws BaseGqlClientException {
        return this.reproduceNodes(nodes, new NodeReproducer(){

            @Override
            public GqlJcrNodeMutation reproduce(GqlJcrReproducibleNodeInput node) {
                return GqlJcrMutation.this.moveNode(node.getPathOrId(), node.getDestParentPathOrId(), node.getDestName());
            }

            @Override
            public String getOperationName() {
                return "moving";
            }
        });
    }

    private static void verifyNodeReproductionTarget(JCRNodeWrapper node, JCRNodeWrapper destParentNode) {
        if (destParentNode.equals(node) || destParentNode.getPath().startsWith(node.getPath() + "/")) {
            throw new GqlJcrWrongInputException("Cannot copy or move node '" + node.getPath() + "' to itself or its descendant node");
        }
    }

    private Collection<GqlJcrNodeMutation> reproduceNodes(Collection<GqlJcrReproducibleNodeInput> nodes, NodeReproducer nodeReproducer) throws BaseGqlClientException {
        ArrayList<GqlJcrNodeMutation> result = new ArrayList<GqlJcrNodeMutation>(nodes.size());
        LinkedList<Exception> exceptions = new LinkedList<Exception>();
        for (GqlJcrReproducibleNodeInput node : nodes) {
            try {
                result.add(nodeReproducer.reproduce(node));
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            StringBuilder message = new StringBuilder("Errors " + nodeReproducer.getOperationName() + " nodes:\n");
            for (Exception e : exceptions) {
                message.append(e.getClass().getName()).append(": ").append(e.getMessage()).append('\n');
            }
            throw new DataFetchingException(message.toString());
        }
        return result;
    }

    @GraphQLField
    @GraphQLDescription(value="Get a collection of nodes that were modified by current GraphQL request")
    public Collection<GqlJcrNode> getModifiedNodes() {
        return this.getSession().getChangedNodes().stream().map(node -> {
            try {
                return SpecializedTypesHandler.getNode(node);
            }
            catch (RepositoryException e) {
                throw new JahiaRuntimeException((Throwable)e);
            }
        }).collect(Collectors.toList());
    }

    public JCRSessionWrapper getSession() {
        try {
            return JCRSessionFactory.getInstance().getCurrentUserSession(this.workspace);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    public String getWorkspace() {
        return this.workspace;
    }

    @Override
    public void completeField() {
        try {
            if (this.save) {
                Set sessions = JCRSessionFactory.getInstance().getAllOpenUserSessions();
                for (JCRSessionWrapper session : sessions) {
                    session.validate();
                }
                this.getSession().save();
            }
        }
        catch (RepositoryException e) {
            throw NodeMutationConstraintViolationHandler.transformException(e);
        }
    }

    private static interface NodeReproducer {
        public GqlJcrNodeMutation reproduce(GqlJcrReproducibleNodeInput var1);

        public String getOperationName();
    }

    public static class DefaultRootBehaviour
    implements Supplier<Object> {
        @Override
        public Integer get() {
            return 2;
        }
    }
}

