/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeResolver;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.List;
import org.jahia.modules.graphql.provider.dxm.acl.GqlAcl;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrProperty;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.node.GqlOperationsSupport;
import org.jahia.modules.graphql.provider.dxm.node.GqlUsage;
import org.jahia.modules.graphql.provider.dxm.node.NodeQueryExtensions;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldGroupingInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.MulticriteriaEvaluation;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.util.GqlUtils;
import org.jahia.services.content.JCRNodeWrapper;

@GraphQLName(value="JCRNode")
@GraphQLTypeResolver(value=SpecializedTypesHandler.NodeTypeResolver.class)
@GraphQLDescription(value="GraphQL representation of a JCR node")
public interface GqlJcrNode {
    public JCRNodeWrapper getNode();

    public String getType();

    @GraphQLField
    @GraphQLName(value="uuid")
    @GraphQLNonNull
    @GraphQLDescription(value="The UUID of the JCR node this object represents")
    public String getUuid();

    @GraphQLField
    @GraphQLName(value="workspace")
    @GraphQLNonNull
    @GraphQLDescription(value="Get the workspace of the query")
    public NodeQueryExtensions.Workspace getWorkspace();

    @GraphQLField
    @GraphQLName(value="name")
    @GraphQLNonNull
    @GraphQLDescription(value="The name of the JCR node this object represents")
    public String getName();

    @GraphQLField
    @GraphQLName(value="path")
    @GraphQLNonNull
    @GraphQLDescription(value="The path of the JCR node this object represents")
    public String getPath();

    @GraphQLField
    @GraphQLName(value="displayName")
    @GraphQLDescription(value="The display name of the JCR node this object represents in the requested language")
    public String getDisplayName(@GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the display name in") String var1);

    @GraphQLField
    @GraphQLName(value="parent")
    @GraphQLDescription(value="GraphQL representation of the parent JCR node")
    public GqlJcrNode getParent();

    @GraphQLField
    @GraphQLName(value="properties")
    @GraphQLNonNull
    @GraphQLDescription(value="GraphQL representations of the properties in the requested language")
    public Collection<GqlJcrProperty> getProperties(@GraphQLName(value="names") @GraphQLDescription(value="The names of the JCR properties; null to obtain all properties") Collection<String> var1, @GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the properties in; must be a valid language code in case any internationalized properties are requested, does not matter for non-internationalized ones") String var2, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput var3, @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) @GraphQLName(value="useFallbackLanguage") @GraphQLDescription(value="When set to true, returns the node in the default language if there is no translation for the requested language. Returns null if the option \"Replace untranslated content with the default language content\" is not activated for the site of the requested node. Will also return null if there is no translation for the default language.") Boolean var4, DataFetchingEnvironment var5);

    @GraphQLField
    @GraphQLName(value="property")
    @GraphQLDescription(value="The GraphQL representation of the property in the requested language; null if the property does not exist")
    public GqlJcrProperty getProperty(@GraphQLName(value="name") @GraphQLDescription(value="The name of the JCR property") @GraphQLNonNull String var1, @GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the property in; must be a valid language code for internationalized properties, does not matter for non-internationalized ones") String var2, @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) @GraphQLName(value="useFallbackLanguage") @GraphQLDescription(value="When set to true, returns the node in the default language if there is no translation for the requested language. Returns null if the option \"Replace untranslated content with the default language content\" is not activated for the site of the requested node. Will also return null if there is no translation for the default language.") Boolean var3);

    @GraphQLField
    @GraphQLName(value="children")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    @GraphQLDescription(value="GraphQL representations of the child nodes, according to parameters passed")
    public DXPaginatedData<GqlJcrNode> getChildren(@GraphQLName(value="names") @GraphQLDescription(value="Filter of child nodes by their names; null to avoid such filtering") Collection<String> var1, @GraphQLName(value="validInLanguage") @GraphQLDescription(value="Language to use to get children") String var2, @GraphQLName(value="typesFilter") @GraphQLDescription(value="Filter of child nodes by their types; null to avoid such filtering") NodeTypesInput var3, @GraphQLName(value="propertiesFilter") @GraphQLDescription(value="Filter of child nodes by their property values; null to avoid such filtering") NodePropertiesInput var4, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput var5, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput var6, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields according to specified criteria") FieldGroupingInput var7, @GraphQLName(value="includesSelf") @GraphQLDescription(value="Include the current node itself in results") @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) boolean var8, DataFetchingEnvironment var9) throws GqlJcrWrongInputException;

    @GraphQLField
    @GraphQLName(value="descendant")
    @GraphQLDescription(value="GraphQL representation of a descendant node, based on its relative path")
    public GqlJcrNode getDescendant(@GraphQLName(value="relPath") @GraphQLDescription(value="Name or relative path of the sub node") @GraphQLNonNull String var1) throws GqlJcrWrongInputException;

    @GraphQLField
    @GraphQLName(value="descendants")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    @GraphQLDescription(value="GraphQL representations of the descendant nodes, according to parameters passed")
    public DXPaginatedData<GqlJcrNode> getDescendants(@GraphQLName(value="typesFilter") @GraphQLDescription(value="Filter of descendant nodes by their types; null to avoid such filtering") NodeTypesInput var1, @GraphQLName(value="validInLanguage") @GraphQLDescription(value="Language to use to get children") String var2, @GraphQLName(value="propertiesFilter") @GraphQLDescription(value="Filter of descendant nodes by their property values; null to avoid such filtering") NodePropertiesInput var3, @GraphQLName(value="recursionTypesFilter") @GraphQLDescription(value="Filter out and stop recursion on nodes by their types; null to avoid such filtering") NodeTypesInput var4, @GraphQLName(value="recursionPropertiesFilter") @GraphQLDescription(value="Filter out and stop recursion on nodes by their property values; null to avoid such filtering") NodePropertiesInput var5, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput var6, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput var7, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields according to specified criteria") FieldGroupingInput var8, DataFetchingEnvironment var9) throws GqlJcrWrongInputException;

    @GraphQLField
    @GraphQLName(value="ancestors")
    @GraphQLNonNull
    @GraphQLDescription(value="GraphQL representations of the ancestor nodes of the JCR node, top down direction")
    public List<GqlJcrNode> getAncestors(@GraphQLName(value="upToPath") @GraphQLDescription(value="The path of the topmost ancestor node to include in the result; null or empty string to include all the ancestor nodes") String var1, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput var2, DataFetchingEnvironment var3) throws GqlJcrWrongInputException;

    @GraphQLField
    @GraphQLName(value="references")
    @GraphQLNonNull
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    @GraphQLDescription(value="GraphQL representations of the reference properties that target the current JCR Node")
    public DXPaginatedData<GqlJcrProperty> getReferences(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput var1, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput var2, DataFetchingEnvironment var3);

    @GraphQLField
    @GraphQLName(value="nodeInWorkspace")
    @GraphQLDescription(value="GraphQL representation of this node in certain workspace")
    public GqlJcrNode getNodeInWorkspace(@GraphQLName(value="workspace") @GraphQLDescription(value="The target workspace") @GraphQLNonNull NodeQueryExtensions.Workspace var1);

    @GraphQLField
    @GraphQLDescription(value="Check if the current user has a specific permission")
    public boolean hasPermission(@GraphQLName(value="permissionName") @GraphQLDescription(value="The name of the permission") @GraphQLNonNull String var1);

    @GraphQLField
    @GraphQLName(value="aggregatedLastModifiedDate")
    @GraphQLDescription(value="Get the last modified date of this node and its descendants. The recursion in descendants can be controlled by recursionTypesFilter. If no filter is passed, recursion will stop by default on sub pages.")
    public String getAggregatedLastModifiedDate(@GraphQLName(value="language") @GraphQLDescription(value="The language to use to get the last modified date, if not specified, returns last modification date in any language") String var1, @GraphQLName(value="recursionTypesFilter") @GraphQLDescription(value="Stop recursion on nodes by their types; null to avoid such filtering") NodeTypesInput var2, DataFetchingEnvironment var3);

    @GraphQLField
    @GraphQLName(value="languagesToTranslate")
    @GraphQLDescription(value="Check if the given locales need translation, by comparing last modifications dates with already existing translations")
    public List<String> getLanguagesToTranslate(@GraphQLName(value="languagesTranslated") @GraphQLDescription(value="List of known translated languages, will be used to compare modifications dates") List<String> var1, @GraphQLName(value="languagesToCheck") @GraphQLDescription(value="List of languages potentially to be translated") List<String> var2);

    @GraphQLField
    @GraphQLName(value="translationLanguages")
    @GraphQLDescription(value="Returns languages of available translations for this node")
    public List<String> getTranslationLanguages(@GraphQLName(value="isActiveOnly") @GraphQLDescription(value="Optional: Return languages only if it is active for the site") Boolean var1);

    @GraphQLField
    @GraphQLDescription(value="Get information on the operations that can be done on this node")
    public GqlOperationsSupport getOperationsSupport();

    @GraphQLField
    @GraphQLDescription(value="Get ACL info for this node")
    public GqlAcl getAcl();

    @GraphQLField
    @GraphQLName(value="usages")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    @GraphQLNonNull
    @GraphQLDescription(value="GraphQL representations of the reference properties that target the current JCR Node")
    public DXPaginatedData<GqlUsage> getUsages(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput var1, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput var2, DataFetchingEnvironment var3);

    @GraphQLField
    @GraphQLNonNull
    @GraphQLName(value="isExternal")
    @GraphQLDescription(value="true if node is under a mounted node")
    public boolean isExternal();

    @GraphQLField
    @GraphQLDescription(value="Get node URL")
    public String getUrl();

    @GraphQLField
    @GraphQLDescription(value="Get node thumbnail URL")
    public String getThumbnailUrl(@GraphQLName(value="name") @GraphQLDescription(value="Thumbnail name") String var1);

    @GraphQLDescription(value="Node property selection")
    public static class NodePropertyInput {
        private String language;
        private PropertyEvaluation propertyEvaluation;
        private String propertyName;
        private String propertyValue;

        public NodePropertyInput(@GraphQLName(value="language") String language, @GraphQLName(value="evaluation") PropertyEvaluation propertyEvaluation, @GraphQLName(value="property") @GraphQLNonNull String propertyName, @GraphQLName(value="value") String propertyValue) {
            this.language = language;
            this.propertyEvaluation = propertyEvaluation;
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        @GraphQLField
        @GraphQLName(value="language")
        @GraphQLDescription(value="Language to use when evaluating the property")
        public String getLanguage() {
            return this.language;
        }

        @GraphQLField
        @GraphQLName(value="evaluation")
        @GraphQLDescription(value="The way to evaluate the property; null indicates default (EQUAL)")
        public PropertyEvaluation getPropertyEvaluation() {
            return this.propertyEvaluation;
        }

        @GraphQLField
        @GraphQLName(value="property")
        @GraphQLNonNull
        @GraphQLDescription(value="The name of the property to filter by")
        public String getPropertyName() {
            return this.propertyName;
        }

        @GraphQLField
        @GraphQLName(value="value")
        @GraphQLDescription(value="The value to evaluate the property against")
        public String getPropertyValue() {
            return this.propertyValue;
        }
    }

    @GraphQLDescription(value="Node properties selection")
    public static class NodePropertiesInput {
        private MulticriteriaEvaluation multicriteriaEvaluation;
        private Collection<NodePropertyInput> propertyFilters;

        public NodePropertiesInput(@GraphQLName(value="multi") MulticriteriaEvaluation multicriteriaEvaluation, @GraphQLName(value="filters") @GraphQLNonNull Collection<NodePropertyInput> propertyFilters) {
            this.multicriteriaEvaluation = multicriteriaEvaluation;
            this.propertyFilters = propertyFilters;
        }

        @GraphQLField
        @GraphQLName(value="multi")
        @GraphQLDescription(value="The way to combine multiple individual property filters; null indicates default (ALL)")
        public MulticriteriaEvaluation getMulticriteriaEvaluation() {
            return this.multicriteriaEvaluation;
        }

        @GraphQLField
        @GraphQLName(value="filters")
        @GraphQLNonNull
        @GraphQLDescription(value="Individual property filters")
        public Collection<NodePropertyInput> getPropertyFilters() {
            return this.propertyFilters;
        }
    }

    public static enum PropertyEvaluation {
        PRESENT,
        ABSENT,
        EQUAL,
        DIFFERENT;

    }

    @GraphQLDescription(value="Node types selection")
    public static class NodeTypesInput {
        private MulticriteriaEvaluation multicriteriaEvaluation;
        private Collection<String> types;

        public NodeTypesInput(@GraphQLName(value="multi") MulticriteriaEvaluation multicriteriaEvaluation, @GraphQLName(value="types") @GraphQLNonNull Collection<String> types) {
            this.multicriteriaEvaluation = multicriteriaEvaluation;
            this.types = types;
        }

        @GraphQLField
        @GraphQLName(value="multi")
        @GraphQLDescription(value="The way to combine multiple type criteria; null indicates default (ANY)")
        public MulticriteriaEvaluation getMulticriteriaEvaluation() {
            return this.multicriteriaEvaluation;
        }

        @GraphQLField
        @GraphQLName(value="types")
        @GraphQLNonNull
        @GraphQLDescription(value="Node type names required for a node to pass the filter")
        public Collection<String> getTypes() {
            return this.types;
        }
    }
}

