/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDefaultValue;
import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.security.AccessControlException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.acl.GqlAcl;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrProperty;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;
import org.jahia.modules.graphql.provider.dxm.node.GqlOperationsSupport;
import org.jahia.modules.graphql.provider.dxm.node.GqlUsage;
import org.jahia.modules.graphql.provider.dxm.node.NodeHelper;
import org.jahia.modules.graphql.provider.dxm.node.NodeQueryExtensions;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldGroupingInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldSorterInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FilterHelper;
import org.jahia.modules.graphql.provider.dxm.predicate.MulticriteriaEvaluation;
import org.jahia.modules.graphql.provider.dxm.predicate.SorterHelper;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.modules.graphql.provider.dxm.security.PermissionHelper;
import org.jahia.modules.graphql.provider.dxm.util.GqlUtils;
import org.jahia.services.content.JCRDescendantsNodeIterator;
import org.jahia.services.content.JCRItemWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRSiteNode;
import pl.touk.throwing.ThrowingFunction;
import pl.touk.throwing.ThrowingPredicate;
import pl.touk.throwing.ThrowingSupplier;

@GraphQLName(value="GenericJCRNode")
@GraphQLDescription(value="GraphQL representation of a generic JCR node")
public class GqlJcrNodeImpl
implements GqlJcrNode {
    public static final List<String> DEFAULT_EXCLUDED_CHILDREN = Arrays.asList("jnt:translation");
    public static final Predicate<JCRNodeWrapper> DEFAULT_CHILDREN_PREDICATE = NodeHelper.getTypesPredicate(new GqlJcrNode.NodeTypesInput(MulticriteriaEvaluation.NONE, DEFAULT_EXCLUDED_CHILDREN));
    private JCRNodeWrapper node;
    private String type;

    public GqlJcrNodeImpl(JCRNodeWrapper node) {
        this(node, null);
    }

    public GqlJcrNodeImpl(JCRNodeWrapper node, String type) {
        this.node = node;
        if (type != null) {
            this.type = type;
        } else {
            try {
                this.type = node.getPrimaryNodeTypeName();
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String normalizePath(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    @Override
    public JCRNodeWrapper getNode() {
        return this.node;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    @GraphQLNonNull
    @GraphQLName(value="uuid")
    @GraphQLDescription(value="The UUID of the JCR node this object represents")
    public String getUuid() {
        try {
            return this.node.getIdentifier();
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GraphQLName(value="workspace")
    @GraphQLNonNull
    @GraphQLDescription(value="Get the workspace of the query")
    public NodeQueryExtensions.Workspace getWorkspace() {
        try {
            return "live".equals(this.node.getSession().getWorkspace().getName()) ? NodeQueryExtensions.Workspace.LIVE : NodeQueryExtensions.Workspace.EDIT;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GraphQLName(value="name")
    @GraphQLNonNull
    @GraphQLDescription(value="The name of the JCR node this object represents")
    public String getName() {
        return this.node.getName();
    }

    @Override
    @GraphQLName(value="path")
    @GraphQLNonNull
    @GraphQLDescription(value="The path of the JCR node this object represents")
    public String getPath() {
        return this.node.getPath();
    }

    @Override
    @GraphQLName(value="displayName")
    @GraphQLDescription(value="The displayable name of the JCR node")
    public String getDisplayName(@GraphQLName(value="language") @GraphQLDescription(value="Language") String language) {
        try {
            JCRNodeWrapper node = NodeHelper.getNodeInLanguage(this.node, language);
            return node.getDisplayableName();
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GraphQLName(value="parent")
    @GraphQLDescription(value="GraphQL representation of the parent JCR node")
    public GqlJcrNode getParent() {
        try {
            return SpecializedTypesHandler.getNode(this.node.getParent());
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GraphQLName(value="properties")
    @GraphQLNonNull
    @GraphQLDescription(value="GraphQL representations of the properties in the requested language")
    public Collection<GqlJcrProperty> getProperties(@GraphQLName(value="names") @GraphQLDescription(value="The names of the JCR properties; null to obtain all properties") Collection<String> names, @GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the properties in; must be a valid language code in case any internationalized properties are requested, does not matter for non-internationalized ones") String language, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) @GraphQLName(value="useFallbackLanguage") @GraphQLDescription(value="When set to true, returns the node in the default language if there is no translation for the requested language. Returns null if the option \"Replace untranslated content with the default language content\" is not activated for the site of the requested node. Will also return null if there is no translation for the default language.") Boolean useFallbackLanguage, DataFetchingEnvironment environment) {
        LinkedList<GqlJcrProperty> properties = new LinkedList<GqlJcrProperty>();
        try {
            JCRNodeWrapper translatedNode = NodeHelper.getNodeInLanguage(this.node, language, useFallbackLanguage);
            if (names != null) {
                for (String name : names) {
                    if (!translatedNode.hasProperty(name)) continue;
                    properties.add(new GqlJcrProperty(translatedNode.getProperty(name), this));
                }
            } else {
                PropertyIterator it = translatedNode.getProperties();
                while (it.hasNext()) {
                    JCRPropertyWrapper property = (JCRPropertyWrapper)it.nextProperty();
                    properties.add(new GqlJcrProperty(property, this));
                }
            }
            if (language != null) {
                String translationPath = "/j:translation_" + language + "/";
                properties.removeIf(p -> {
                    try {
                        return !p.getProperty().getRealProperty().getPath().contains(translationPath) && properties.stream().anyMatch(p2 -> {
                            try {
                                return p.getName().equals(p2.getName()) && p2.getProperty().getRealProperty().getPath().contains(translationPath);
                            }
                            catch (RepositoryException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return FilterHelper.filterList(properties, fieldFilter, environment);
    }

    @Override
    @GraphQLName(value="property")
    @GraphQLDescription(value="The GraphQL representation of the property in the requested language; null if the property does not exist")
    public GqlJcrProperty getProperty(@GraphQLName(value="name") @GraphQLDescription(value="The name of the JCR property") @GraphQLNonNull String name, @GraphQLName(value="language") @GraphQLDescription(value="The language to obtain the property in; must be a valid language code for internationalized properties, does not matter for non-internationalized ones") String language, @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) @GraphQLName(value="useFallbackLanguage") @GraphQLDescription(value="When set to true, returns the node in the default language if there is no translation for the requested language. Returns null if the option \"Replace untranslated content with the default language content\" is not activated for the site of the requested node. Will also return null if there is no translation for the default language.") Boolean useFallbackLanguage) {
        try {
            JCRNodeWrapper translatedNode = NodeHelper.getNodeInLanguage(this.node, language, useFallbackLanguage);
            if (!translatedNode.hasProperty(name)) {
                return null;
            }
            return new GqlJcrProperty(translatedNode.getProperty(name), this);
        }
        catch (ItemNotFoundException | PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GraphQLName(value="children")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    @GraphQLDescription(value="GraphQL representations of the child nodes, according to parameters passed")
    public DXPaginatedData<GqlJcrNode> getChildren(@GraphQLName(value="names") @GraphQLDescription(value="Filter of child nodes by their names; null to avoid such filtering") Collection<String> names, @GraphQLName(value="validInLanguage") @GraphQLDescription(value="Language to use to get children") String validInLanguage, @GraphQLName(value="typesFilter") @GraphQLDescription(value="Filter of child nodes by their types; null to avoid such filtering") GqlJcrNode.NodeTypesInput typesFilter, @GraphQLName(value="propertiesFilter") @GraphQLDescription(value="Filter of child nodes by their property values; null to avoid such filtering") GqlJcrNode.NodePropertiesInput propertiesFilter, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput fieldSorter, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields according to specified criteria") FieldGroupingInput fieldGrouping, @GraphQLName(value="includesSelf") @GraphQLDescription(value="Include the current node itself in results") @GraphQLDefaultValue(value=GqlUtils.SupplierFalse.class) boolean includesSelf, DataFetchingEnvironment environment) {
        try {
            return NodeHelper.getPaginatedNodesList((NodeIterator)NodeHelper.getNodeInLanguage(this.node, validInLanguage).getNodes(), names, typesFilter, propertiesFilter, fieldFilter, environment, fieldSorter, fieldGrouping);
        }
        catch (ItemNotFoundException e) {
            throw new DataFetchingException(e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GraphQLName(value="descendant")
    @GraphQLDescription(value="GraphQL representation of a descendant node, based on its relative path")
    public GqlJcrNode getDescendant(@GraphQLName(value="relPath") @GraphQLDescription(value="Name or relative path of the sub node") @GraphQLNonNull String relPath) {
        if (relPath.contains("..")) {
            throw new GqlJcrWrongInputException("No navigation outside of the node sub-tree is supported");
        }
        try {
            if (this.node.hasNode(relPath)) {
                return SpecializedTypesHandler.getNode(this.node.getNode(relPath));
            }
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return null;
    }

    @Override
    @GraphQLName(value="descendants")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    @GraphQLDescription(value="GraphQL representations of the descendant nodes, according to parameters passed")
    public DXPaginatedData<GqlJcrNode> getDescendants(@GraphQLName(value="typesFilter") @GraphQLDescription(value="Filter of descendant nodes by their types; null to avoid such filtering") GqlJcrNode.NodeTypesInput typesFilter, @GraphQLName(value="validInLanguage") @GraphQLDescription(value="Language to use to get children") String validInLanguage, @GraphQLName(value="propertiesFilter") @GraphQLDescription(value="Filter of descendant nodes by their property values; null to avoid such filtering") GqlJcrNode.NodePropertiesInput propertiesFilter, @GraphQLName(value="recursionTypesFilter") @GraphQLDescription(value="Filter out and stop recursion on nodes by their types; null to avoid such filtering") GqlJcrNode.NodeTypesInput recursionTypesFilter, @GraphQLName(value="recursionPropertiesFilter") @GraphQLDescription(value="Filter out and stop recursion on nodes by their property values; null to avoid such filtering") GqlJcrNode.NodePropertiesInput recursionPropertiesFilter, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput fieldSorter, @GraphQLName(value="fieldGrouping") @GraphQLDescription(value="Group fields according to specified criteria") FieldGroupingInput fieldGrouping, DataFetchingEnvironment environment) {
        try {
            JCRDescendantsNodeIterator it = new JCRDescendantsNodeIterator(NodeHelper.getNodeInLanguage(this.node, validInLanguage), NodeHelper.getNodesPredicate(null, recursionTypesFilter, recursionPropertiesFilter, environment));
            return NodeHelper.getPaginatedNodesList((NodeIterator)it, null, typesFilter, propertiesFilter, fieldFilter, environment, fieldSorter, fieldGrouping);
        }
        catch (ItemNotFoundException e) {
            throw new DataFetchingException(e);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GraphQLName(value="ancestors")
    @GraphQLDescription(value="GraphQL representations of the ancestor nodes of the JCR node, top down direction")
    @GraphQLNonNull
    public List<GqlJcrNode> getAncestors(@GraphQLName(value="upToPath") @GraphQLDescription(value="The path of the topmost ancestor node to include in the result; null or empty string to include all the ancestor nodes") String upToPath, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        String upToPathNormalized;
        if (upToPath != null) {
            if (upToPath.isEmpty()) {
                throw new GqlJcrWrongInputException("'" + upToPath + "' is not a valid node path");
            }
            String nodePath = this.node.getPath();
            String nodePathNormalized = GqlJcrNodeImpl.normalizePath(nodePath);
            if (nodePathNormalized.equals(upToPathNormalized = GqlJcrNodeImpl.normalizePath(upToPath)) || !nodePathNormalized.startsWith(upToPathNormalized)) {
                throw new GqlJcrWrongInputException("'" + upToPath + "' does not reference an ancestor node of '" + nodePath + "'");
            }
        } else {
            upToPathNormalized = "/";
        }
        LinkedList<GqlJcrNode> ancestors = new LinkedList<GqlJcrNode>();
        try {
            for (JCRItemWrapper jcrAncestor : this.node.getAncestors()) {
                String ancestorPathNormalized = GqlJcrNodeImpl.normalizePath(jcrAncestor.getPath());
                if (!ancestorPathNormalized.startsWith(upToPathNormalized)) continue;
                ancestors.add(SpecializedTypesHandler.getNode((JCRNodeWrapper)jcrAncestor));
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return FilterHelper.filterList(ancestors, fieldFilter, environment);
    }

    @Override
    @GraphQLName(value="references")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    @GraphQLNonNull
    @GraphQLDescription(value="GraphQL representations of the reference properties that target the current JCR Node")
    public DXPaginatedData<GqlJcrProperty> getReferences(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput fieldSorter, DataFetchingEnvironment environment) {
        PaginationHelper.Arguments arguments;
        LinkedList<GqlJcrProperty> references;
        block6: {
            references = new LinkedList<GqlJcrProperty>();
            arguments = PaginationHelper.parseArguments(environment);
            try {
                this.collectReferences(this.node.getWeakReferences(), references, environment);
            }
            catch (UnsupportedRepositoryOperationException | ConstraintViolationException e) {
                return null;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            try {
                this.collectReferences(this.node.getReferences(), references, environment);
            }
            catch (RepositoryException e) {
                if (e instanceof UnsupportedRepositoryOperationException) break block6;
                throw new RuntimeException(e);
            }
        }
        List<GqlJcrProperty> result = FilterHelper.filterConnection(references, fieldFilter, environment);
        if (fieldSorter != null) {
            result.sort(SorterHelper.getFieldComparator(fieldSorter, FieldEvaluator.forConnection(environment)));
        }
        return PaginationHelper.paginate(result, p -> PaginationHelper.encodeCursor(p.getNode().getUuid() + "/" + p.getName()), arguments);
    }

    private void collectReferences(PropertyIterator references, Collection<GqlJcrProperty> gqlReferences, DataFetchingEnvironment environment) throws RepositoryException {
        while (references.hasNext()) {
            GqlJcrNode gqlReferencingNode;
            GqlJcrProperty gqlReference;
            JCRPropertyWrapper reference = (JCRPropertyWrapper)references.nextProperty();
            JCRNodeWrapper referencingNode = reference.getParent();
            if (!PermissionHelper.hasPermission(referencingNode, environment)) continue;
            String name = reference.getName();
            String locale = reference.getLocale();
            if (referencingNode.isNodeType("jnt:translation")) {
                referencingNode = referencingNode.getParent();
            } else if (referencingNode.isNodeType("jnt:referenceInField")) {
                String s = referencingNode.getProperty("j:fieldName").getValue().getString();
                referencingNode = referencingNode.getParent();
                NodeIterator it = referencingNode.getI18Ns();
                while (it.hasNext()) {
                    Node langNode = it.nextNode();
                    String lang = langNode.getProperty("jcr:language").getString();
                    if (!s.endsWith("_" + lang)) continue;
                    locale = lang;
                    name = StringUtils.substringBeforeLast((String)s, (String)("_" + lang));
                    break;
                }
            }
            if ((gqlReference = (gqlReferencingNode = SpecializedTypesHandler.getNode(referencingNode)).getProperty(name, locale, false)) == null) continue;
            gqlReferences.add(gqlReference);
        }
    }

    @Override
    @GraphQLName(value="nodeInWorkspace")
    @GraphQLDescription(value="GraphQL representation of this node in certain workspace")
    public GqlJcrNode getNodeInWorkspace(@GraphQLName(value="workspace") @GraphQLDescription(value="The target workspace") @GraphQLNonNull NodeQueryExtensions.Workspace workspace) {
        try {
            JCRNodeWrapper target = JCRSessionFactory.getInstance().getCurrentUserSession(workspace.getValue()).getNodeByIdentifier(this.node.getIdentifier());
            return SpecializedTypesHandler.getNode(target);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GraphQLDescription(value="Check if the current user has a specific permission")
    public boolean hasPermission(@GraphQLName(value="permissionName") @GraphQLDescription(value="The name of the permission") @GraphQLNonNull String permissionName) {
        try {
            this.node.getAccessControlManager().privilegeFromName(permissionName);
            return this.node.hasPermission(permissionName);
        }
        catch (AccessControlException ace) {
            return false;
        }
        catch (RepositoryException re) {
            throw new RuntimeException(re);
        }
    }

    @Override
    @GraphQLName(value="aggregatedLastModifiedDate")
    @GraphQLDescription(value="Get the last modified date of this node and its descendants. The recursion in descendants can be controlled by recursionTypesFilter. If no filter is passed, recursion will stop by default on sub pages.")
    public String getAggregatedLastModifiedDate(@GraphQLName(value="language") @GraphQLDescription(value="The language") String language, @GraphQLName(value="recursionTypesFilter") @GraphQLDescription(value="Stop recursion on graphql field values") GqlJcrNode.NodeTypesInput recursionTypesFilter, DataFetchingEnvironment environment) {
        try {
            JCRNodeWrapper i18node = NodeHelper.getNodeInLanguage(this.node, language);
            if (recursionTypesFilter == null) {
                recursionTypesFilter = new GqlJcrNode.NodeTypesInput(MulticriteriaEvaluation.NONE, Collections.singleton("jnt:page"));
            }
            Predicate<JCRNodeWrapper> predicate = NodeHelper.getTypesPredicate(recursionTypesFilter);
            JCRDescendantsNodeIterator it = new JCRDescendantsNodeIterator(i18node, predicate);
            JCRNodeWrapper max = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false).filter(predicate).filter(ThrowingPredicate.unchecked(n -> n.hasProperty("jcr:lastModified"))).reduce(i18node, (n1, n2) -> (JCRNodeWrapper)ThrowingSupplier.unchecked(() -> n1.getProperty("jcr:lastModified").getLong() > n2.getProperty("jcr:lastModified").getLong() ? n1 : n2).get());
            Calendar date = max.getProperty("jcr:lastModified").getDate();
            return ISO8601.format((Calendar)date);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GraphQLName(value="languagesToTranslate")
    @GraphQLDescription(value="Check if the given locales need translation, by comparing last modifications dates with already existing translations")
    public List<String> getLanguagesToTranslate(@GraphQLName(value="languagesTranslated") @GraphQLDescription(value="The translated languages") List<String> languagesTranslated, @GraphQLName(value="languagesToCheck") @GraphQLDescription(value="The languages to check") List<String> languagesToCheck) {
        ArrayList<String> toBeTranslated = new ArrayList<String>();
        try {
            if (CollectionUtils.isEmpty(languagesToCheck) || CollectionUtils.isEmpty(languagesTranslated) || this.node.getI18Ns().getSize() <= 0L) {
                return toBeTranslated;
            }
            Optional lastTranslatedDate = languagesTranslated.stream().map(LocaleUtils::toLocale).filter(ThrowingPredicate.unchecked(localeTranslated -> this.node.hasI18N(localeTranslated))).map(ThrowingFunction.unchecked(localeTranslated -> this.node.getI18N(localeTranslated).getProperty("jcr:lastModified").getLong())).max(Long::compareTo);
            if (lastTranslatedDate.isPresent()) {
                for (String languageToCheck : languagesToCheck) {
                    try {
                        Node translationNode = this.node.getI18N(LocaleUtils.toLocale((String)languageToCheck));
                        if (translationNode.getProperty("jcr:lastModified").getLong() >= (Long)lastTranslatedDate.get()) continue;
                        toBeTranslated.add(languageToCheck);
                    }
                    catch (ItemNotFoundException e) {
                        toBeTranslated.add(languageToCheck);
                    }
                }
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return toBeTranslated;
    }

    @Override
    @GraphQLName(value="translationLanguages")
    @GraphQLDescription(value="Returns languages of available translations for this node")
    public List<String> getTranslationLanguages(@GraphQLName(value="isActiveOnly") @GraphQLDescription(value="Optional: Return languages only if it is active for the site") Boolean isActiveOnly) {
        List<String> translations = new ArrayList<String>();
        try {
            NodeIterator it = this.node.getI18Ns();
            while (it.hasNext()) {
                Node langNode = it.nextNode();
                String lang = langNode.getProperty("jcr:language").getString();
                translations.add(lang);
            }
            if (isActiveOnly != null && isActiveOnly.booleanValue()) {
                JCRSiteNode site = this.node.getResolveSite();
                Set inactiveLangs = site.getInactiveLanguages();
                translations = translations.stream().filter(t -> !inactiveLangs.contains(t)).collect(Collectors.toList());
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return translations;
    }

    @Override
    @GraphQLDescription(value="Get information on the operations that can be done on this node")
    public GqlOperationsSupport getOperationsSupport() {
        return new GqlOperationsSupport(this);
    }

    @Override
    @GraphQLDescription(value="Get ACL info for this node")
    public GqlAcl getAcl() {
        return new GqlAcl(this.node);
    }

    @Override
    @GraphQLDescription(value="Get node URL")
    public String getUrl() {
        return this.node.getUrl();
    }

    @Override
    @GraphQLDescription(value="Get node thumbnail URL")
    public String getThumbnailUrl(@GraphQLName(value="name") @GraphQLDescription(value="Thumbnail name") String name) {
        return this.node.getThumbnailUrl(name);
    }

    @Override
    @GraphQLName(value="usages")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    @GraphQLNonNull
    @GraphQLDescription(value="GraphQL representations of the reference properties that target the current JCR Node")
    public DXPaginatedData<GqlUsage> getUsages(@GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, @GraphQLName(value="fieldSorter") @GraphQLDescription(value="Sort by graphQL fields values") FieldSorterInput fieldSorter, DataFetchingEnvironment environment) {
        PaginationHelper.Arguments arguments;
        LinkedList<GqlUsage> references;
        block6: {
            references = new LinkedList<GqlUsage>();
            arguments = PaginationHelper.parseArguments(environment);
            try {
                this.collectUsages(this.node.getWeakReferences(), references, environment);
            }
            catch (UnsupportedRepositoryOperationException | ConstraintViolationException e) {
                return null;
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
            try {
                this.collectUsages(this.node.getReferences(), references, environment);
            }
            catch (RepositoryException e) {
                if (e instanceof UnsupportedRepositoryOperationException) break block6;
                throw new RuntimeException(e);
            }
        }
        List<GqlUsage> result = FilterHelper.filterConnection(references, fieldFilter, environment);
        if (fieldSorter != null) {
            result.sort(SorterHelper.getFieldComparator(fieldSorter, FieldEvaluator.forConnection(environment)));
        }
        return PaginationHelper.paginate(result, u -> PaginationHelper.encodeCursor(u.getNode().getUuid()), arguments);
    }

    @Override
    @GraphQLNonNull
    @GraphQLName(value="isExternal")
    @GraphQLDescription(value="true if node is under a mounted node")
    public boolean isExternal() {
        return !this.node.getProvider().isDefault();
    }

    private void collectUsages(PropertyIterator references, Collection<GqlUsage> gqlReferences, DataFetchingEnvironment environment) throws RepositoryException {
        while (references.hasNext()) {
            JCRPropertyWrapper reference = (JCRPropertyWrapper)references.nextProperty();
            JCRNodeWrapper referencingNode = reference.getParent();
            if (!PermissionHelper.hasPermission(referencingNode, environment)) continue;
            String name = reference.getName();
            String locale = reference.getLocale();
            if (referencingNode.isNodeType("jnt:translation")) {
                referencingNode = referencingNode.getParent();
            } else if (referencingNode.isNodeType("jnt:referenceInField")) {
                String s = referencingNode.getProperty("j:fieldName").getValue().getString();
                referencingNode = referencingNode.getParent();
                NodeIterator it = referencingNode.getI18Ns();
                while (it.hasNext()) {
                    Node langNode = it.nextNode();
                    String lang = langNode.getProperty("jcr:language").getString();
                    if (!s.endsWith("_" + lang)) continue;
                    locale = lang;
                    name = StringUtils.substringBeforeLast((String)s, (String)("_" + lang));
                    break;
                }
            }
            GqlJcrNode gqlReferencingNode = SpecializedTypesHandler.getNode(referencingNode);
            GqlJcrProperty gqlReference = gqlReferencingNode.getProperty(name, locale, false);
            gqlReferences.stream().filter(gqlUsage -> gqlUsage.getNode().getUuid().equals(gqlReferencingNode.getUuid())).findFirst().orElseGet(() -> {
                GqlUsage usage = new GqlUsage(gqlReferencingNode);
                gqlReferences.add(usage);
                return usage;
            }).addUsage(gqlReference);
        }
    }
}

