/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrPropertyType;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrUnresolvedNodeReferenceException;
import org.jahia.modules.graphql.provider.dxm.node.SpecializedTypesHandler;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.renderer.ChoiceListRenderer;
import org.jahia.services.content.nodetypes.renderer.ChoiceListRendererService;
import org.jahia.utils.EncryptionUtils;
import org.jahia.utils.LanguageCodeConverters;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;

@GraphQLName(value="JCRProperty")
@GraphQLDescription(value="GraphQL representation of a JCR property.")
public class GqlJcrProperty {
    private JCRPropertyWrapper property;
    private GqlJcrNode node;

    public GqlJcrProperty(JCRPropertyWrapper property, GqlJcrNode node) {
        this.property = property;
        this.node = node;
    }

    public JCRPropertyWrapper getProperty() {
        return this.property;
    }

    @GraphQLField
    @GraphQLName(value="name")
    @GraphQLNonNull
    @GraphQLDescription(value="The name of the JCR property")
    public String getName() {
        try {
            return this.property.getName();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="path")
    @GraphQLNonNull
    @GraphQLDescription(value="The path of the JCR property")
    public String getPath() {
        try {
            return this.property.getPath();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="type")
    @GraphQLNonNull
    @GraphQLDescription(value="The type of the JCR property")
    public GqlJcrPropertyType getType() {
        try {
            return GqlJcrPropertyType.fromValue(this.property.getType());
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="internationalized")
    @GraphQLNonNull
    @GraphQLDescription(value="Whether the property is internationalized")
    public boolean isInternationalized() {
        ExtendedPropertyDefinition propertyDefinition;
        try {
            propertyDefinition = this.node.getNode().getApplicablePropertyDefinition(this.getName(), this.property.getType(), this.property.isMultiple());
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
        return propertyDefinition.isInternationalized();
    }

    @GraphQLField
    @GraphQLName(value="language")
    @GraphQLDescription(value="The language the property value was obtained in for internationalized properties; null for non-internationalized ones")
    public String getLanguage() {
        try {
            return this.property.getLocale();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="value")
    @GraphQLDescription(value="The value of the JCR property as a String in case the property is single-valued, null otherwise")
    public String getValue() {
        try {
            if (this.property.isMultiple()) {
                return null;
            }
            return this.property.getValue().getString();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="notZonedDateValue")
    @GraphQLDescription(value="The value of the JCR property casted as date and returned in this string format: [yyyy-MM-dd'T'HH:mm:ss.SSS] in case the property is single-valued, null otherwise")
    public String getNotZonedDateValue() {
        try {
            if (this.property.isMultiple() || this.property.getType() != 5) {
                return null;
            }
            SimpleDateFormat defaultDataFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            return defaultDataFormat.format(this.property.getValue().getTime());
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="decryptedValue")
    @GraphQLDescription(value="The decrypted value of the JCR encrypted property as a String in case the property is single-valued, null otherwise")
    public String getDecryptedValue() throws RepositoryException {
        try {
            if (this.property.isMultiple()) {
                return null;
            }
            return EncryptionUtils.passwordBaseDecrypt((String)this.property.getValue().getString());
        }
        catch (EncryptionOperationNotPossibleException e) {
            return null;
        }
    }

    @GraphQLField
    @GraphQLName(value="values")
    @GraphQLDescription(value="The values of the JCR property as Strings in case the property is multiple-valued, null otherwise")
    public List<String> getValues() {
        try {
            if (!this.property.isMultiple()) {
                return null;
            }
            JCRValueWrapper[] values = this.property.getValues();
            ArrayList<String> result = new ArrayList<String>(values.length);
            for (JCRValueWrapper value : values) {
                result.add(value.getString());
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="notZonedDateValues")
    @GraphQLDescription(value="The values of the JCR property casted as date and returned in this string format: [yyyy-MM-dd'T'HH:mm:ss.SSS] in case the property is multiple-valued, null otherwise")
    public List<String> getNotZonedDateValues() {
        try {
            if (!this.property.isMultiple() || this.property.getType() != 5) {
                return null;
            }
            JCRValueWrapper[] notZonedDateValues = this.property.getValues();
            ArrayList<String> result = new ArrayList<String>(notZonedDateValues.length);
            SimpleDateFormat defaultDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            for (JCRValueWrapper value : notZonedDateValues) {
                result.add(defaultDateFormat.format(value.getDate().getTime()));
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="decryptedValues")
    @GraphQLDescription(value="The decrypted values of the JCR encrypted property as a Strings in case the property is multiple-valued, null otherwise")
    public List<String> getDecryptedValues() throws RepositoryException {
        try {
            if (!this.property.isMultiple()) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            for (JCRValueWrapper value : this.property.getValues()) {
                result.add(EncryptionUtils.passwordBaseDecrypt((String)value.getString()));
            }
            return result;
        }
        catch (EncryptionOperationNotPossibleException e) {
            return Collections.emptyList();
        }
    }

    @GraphQLField
    @GraphQLName(value="longValue")
    @GraphQLDescription(value="The value of the JCR property as a Long in case the property is single-valued, null otherwise")
    public Long getLongValue() {
        try {
            if (this.property.isMultiple()) {
                return null;
            }
            return this.property.getValue().getLong();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="size")
    @GraphQLDescription(value="The binary size of the JCR node as a Long, null otherwise")
    public Long getSize() {
        try {
            if (this.property.isMultiple() && this.property.getType() != 2) {
                return null;
            }
            return this.property.getBinary().getSize();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="longValues")
    @GraphQLDescription(value="The values of the JCR property as Longs in case the property is multiple-valued, null otherwise")
    public List<Long> getLongValues() {
        try {
            if (!this.property.isMultiple()) {
                return null;
            }
            JCRValueWrapper[] values = this.property.getValues();
            ArrayList<Long> result = new ArrayList<Long>(values.length);
            for (JCRValueWrapper value : values) {
                result.add(value.getLong());
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="floatValue")
    @GraphQLDescription(value="The value of the JCR property as a Float in case the property is single-valued, null otherwise")
    public Double getFloatValue() {
        try {
            if (this.property.isMultiple()) {
                return null;
            }
            return this.property.getValue().getDouble();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="floatValues")
    @GraphQLDescription(value="The values of the JCR property as Floats in case the property is multiple-valued, null otherwise")
    public List<Double> getFloatValues() {
        try {
            if (!this.property.isMultiple()) {
                return null;
            }
            JCRValueWrapper[] values = this.property.getValues();
            ArrayList<Double> result = new ArrayList<Double>(values.length);
            for (JCRValueWrapper value : values) {
                result.add(value.getDouble());
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="refNode")
    @GraphQLDescription(value="GraphQL representation of the node this property references in case the property is single-valued, null otherwise")
    public GqlJcrNode getRefNode() throws GqlJcrUnresolvedNodeReferenceException {
        try {
            if (this.property.isMultiple() || this.property.getType() != 9 && this.property.getType() != 10 && this.property.getType() != 1) {
                return null;
            }
            return this.getRefNode(this.property.getValue());
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="booleanValue")
    @GraphQLDescription(value="The value of the JCR property as a Boolean in case the property is single-valued, null otherwise")
    public Boolean getBooleanValue() {
        try {
            if (this.property.isMultiple()) {
                return null;
            }
            return this.property.getValue().getBoolean();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="choicelistValue")
    @GraphQLDescription(value="The value of the JCR property rendered by the specified choicelist renderer in case the property is single-valued, null otherwise")
    public String getChoicelistValue(@GraphQLName(value="renderer") @GraphQLDescription(value="The choicelist renderer name to be used") String renderer, @GraphQLName(value="language") @GraphQLDescription(value="The language") String language) {
        try {
            if (this.property.isMultiple()) {
                return null;
            }
            Locale locale = LanguageCodeConverters.languageCodeToLocale((String)language);
            ChoiceListRenderer choiceListRenderer = (ChoiceListRenderer)ChoiceListRendererService.getInstance().getRenderers().get(renderer);
            return choiceListRenderer.getStringRendering(locale, (ExtendedPropertyDefinition)this.property.getDefinition(), (Object)this.property.getValue());
        }
        catch (RepositoryException e) {
            try {
                return this.property.getValue().getString();
            }
            catch (RepositoryException ex) {
                throw new DataFetchingException(e);
            }
        }
    }

    @GraphQLField
    @GraphQLName(value="choicelistValues")
    @GraphQLDescription(value="The value of the JCR property rendered by the specified choicelist renderer in case the property is multiple-valued, null otherwise")
    public List<String> getChoicelistValues(@GraphQLName(value="renderer") @GraphQLDescription(value="The choicelist renderer name to be used") String renderer, @GraphQLName(value="language") @GraphQLDescription(value="The language") String language) {
        try {
            if (!this.property.isMultiple()) {
                return null;
            }
            Locale locale = LanguageCodeConverters.languageCodeToLocale((String)language);
            ChoiceListRenderer choiceListRenderer = (ChoiceListRenderer)ChoiceListRendererService.getInstance().getRenderers().get(renderer);
            JCRValueWrapper[] values = this.property.getValues();
            ArrayList<String> result = new ArrayList<String>(values.length);
            for (JCRValueWrapper value : values) {
                result.add(choiceListRenderer.getStringRendering(locale, (ExtendedPropertyDefinition)this.property.getDefinition(), (Object)value));
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="booleanValues")
    @GraphQLDescription(value="The values of the JCR property as Booleans in case the property is multiple-valued, null otherwise")
    public List<Boolean> getBooleanValues() {
        try {
            if (!this.property.isMultiple()) {
                return null;
            }
            JCRValueWrapper[] values = this.property.getValues();
            ArrayList<Boolean> result = new ArrayList<Boolean>(values.length);
            for (JCRValueWrapper value : values) {
                result.add(value.getBoolean());
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="refNodes")
    @GraphQLDescription(value="GraphQL representations of the nodes this property references in case the property is multiple-valued, null otherwise")
    public List<GqlJcrNode> getRefNodes() throws GqlJcrUnresolvedNodeReferenceException {
        try {
            if (!this.property.isMultiple() || this.property.getType() != 9 && this.property.getType() != 10 && this.property.getType() != 1) {
                return null;
            }
            JCRValueWrapper[] values = this.property.getValues();
            ArrayList<GqlJcrNode> result = new ArrayList<GqlJcrNode>(values.length);
            for (JCRValueWrapper value : values) {
                result.add(this.getRefNode(value));
            }
            return result;
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="node")
    @GraphQLNonNull
    @GraphQLDescription(value="The GraphQL representation of the JCR node the property belongs to.")
    public GqlJcrNode getNode() {
        return this.node;
    }

    private GqlJcrNode getRefNode(JCRValueWrapper value) throws RepositoryException {
        JCRNodeWrapper refNode;
        try {
            refNode = value.getNode();
        }
        catch (ValueFormatException e) {
            throw new GqlJcrUnresolvedNodeReferenceException("The '" + this.property.getName() + "' property is not of a reference type", e);
        }
        return refNode == null ? null : SpecializedTypesHandler.getNode(refNode);
    }
}

