/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.services.content.JCRNodeWrapper;

@GraphQLDescription(value="Possible operations on a node")
public class GqlOperationsSupport {
    private GqlJcrNode node;

    public GqlOperationsSupport(GqlJcrNode node) {
        this.node = node;
    }

    public GqlJcrNode getNode() {
        return this.node;
    }

    @GraphQLField
    @GraphQLDescription(value="Can node be marked for deletion")
    public boolean getMarkForDeletion() {
        try {
            return this.node.getNode().canMarkForDeletion();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLDescription(value="Can node be locked")
    public boolean getLock() {
        try {
            JCRNodeWrapper jcrNodeWrapper = this.node.getNode();
            return jcrNodeWrapper.getSession().getProviderSession(jcrNodeWrapper.getProvider()).getRepository().getDescriptorValue("option.locking.supported").getBoolean();
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }
}

