/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.nodetype.ConstraintViolationException;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.GqlConstraintViolationException;
import org.jahia.services.content.CompositeConstraintViolationException;
import org.jahia.services.content.NodeConstraintViolationException;
import org.jahia.services.content.PropertyConstraintViolationException;

public class NodeMutationConstraintViolationHandler {
    public static BaseGqlClientException transformException(Throwable e) {
        if (e instanceof NodeConstraintViolationException) {
            return new GqlConstraintViolationException(e, NodeMutationConstraintViolationHandler.buildExtensions(Collections.singletonList(NodeMutationConstraintViolationHandler.extractConstraintViolationError((NodeConstraintViolationException)e))));
        }
        if (e instanceof CompositeConstraintViolationException) {
            return new GqlConstraintViolationException(e, NodeMutationConstraintViolationHandler.buildExtensions(NodeMutationConstraintViolationHandler.extractConstraintViolationErrors((CompositeConstraintViolationException)e)));
        }
        return new DataFetchingException(e);
    }

    private static Map<String, Object> buildExtensions(List<Map<String, Object>> constraintViolations) {
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        extensions.put("constraintViolations", constraintViolations);
        return extensions;
    }

    private static Map<String, Object> extractConstraintViolationError(NodeConstraintViolationException violationException) {
        HashMap<String, Object> constraintViolation = new HashMap<String, Object>();
        if (violationException instanceof PropertyConstraintViolationException) {
            constraintViolation.put("propertyName", ((PropertyConstraintViolationException)violationException).getDefinition().getName());
        }
        constraintViolation.put("nodePath", violationException.getPath());
        constraintViolation.put("constraintMessage", violationException.getConstraintMessage());
        constraintViolation.put("locale", violationException.getLocale() != null ? violationException.getLocale().toString() : null);
        return constraintViolation;
    }

    private static List<Map<String, Object>> extractConstraintViolationErrors(CompositeConstraintViolationException violationExceptions) {
        ArrayList<Map<String, Object>> constraintViolations = new ArrayList<Map<String, Object>>();
        for (ConstraintViolationException violationException : violationExceptions.getErrors()) {
            if (!(violationException instanceof NodeConstraintViolationException)) continue;
            constraintViolations.add(NodeMutationConstraintViolationHandler.extractConstraintViolationError((NodeConstraintViolationException)violationException));
        }
        return constraintViolations;
    }
}

