/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.nodetype;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrItemDefinition;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrNodeType;
import org.jahia.services.content.nodetypes.ExtendedNodeDefinition;

@GraphQLName(value="JCRNodeDefinition")
@GraphQLDescription(value="GraphQL representation of a JCR node definition")
public class GqlJcrNodeDefinition
implements GqlJcrItemDefinition {
    private ExtendedNodeDefinition definition;

    public GqlJcrNodeDefinition(ExtendedNodeDefinition definition) {
        this.definition = definition;
    }

    @Override
    @GraphQLName(value="name")
    @GraphQLNonNull
    @GraphQLDescription(value="Gets the name of the child item.")
    public String getName() {
        return this.definition.getName();
    }

    @Override
    @GraphQLNonNull
    @GraphQLDescription(value="Reports whether the item is mandatory. A mandatory item is one that, if its parent node exists, must also exist.")
    public boolean isMandatory() {
        return this.definition.isMandatory();
    }

    @Override
    @GraphQLNonNull
    @GraphQLDescription(value="Reports whether the item is to be automatically created when its parent node is created.")
    public boolean isAutoCreated() {
        return this.definition.isAutoCreated();
    }

    @Override
    @GraphQLNonNull
    @GraphQLDescription(value="Reports whether the child item is protected.")
    public boolean isProtected() {
        return this.definition.isProtected();
    }

    @Override
    @GraphQLNonNull
    @GraphQLDescription(value="Reports whether the child item is hidden from UI.")
    public boolean isHidden() {
        return this.definition.isHidden();
    }

    @Override
    @GraphQLName(value="declaringNodeType")
    @GraphQLNonNull
    @GraphQLDescription(value="Gets the node type that contains the declaration of this definition.")
    public GqlJcrNodeType getDeclaringNodeType() {
        return new GqlJcrNodeType(this.definition.getDeclaringNodeType());
    }

    @GraphQLField
    @GraphQLName(value="requiredPrimaryType")
    @GraphQLDescription(value="Gets the minimum set of primary node types that the child node must have.")
    public List<GqlJcrNodeType> getRequiredPrimaryType() {
        return Arrays.stream(this.definition.getRequiredPrimaryTypes()).map(GqlJcrNodeType::new).collect(Collectors.toList());
    }

    @GraphQLField
    @GraphQLName(value="defaultPrimaryType")
    @GraphQLDescription(value="Gets the default primary node type that will be assigned to the child node if it is created without an explicitly specified primary node type.")
    public GqlJcrNodeType getDefaultPrimaryType() {
        return new GqlJcrNodeType(this.definition.getDefaultPrimaryType());
    }

    @GraphQLField
    @GraphQLNonNull
    @GraphQLDescription(value="Reports whether this child node can have same-name siblings. In other words, whether the parent node can have more than one child node of this name.")
    public boolean allowsSameNameSiblings() {
        return this.definition.allowsSameNameSiblings();
    }
}

