/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.nodetype;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrNode;
import org.jahia.modules.graphql.provider.dxm.nodetype.NodeTypesListInput;
import org.jahia.modules.graphql.provider.dxm.predicate.MulticriteriaEvaluation;
import org.jahia.modules.graphql.provider.dxm.predicate.PredicateHelper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.sites.JahiaSitesService;
import pl.touk.throwing.ThrowingPredicate;

public final class NodeTypeHelper {
    private static final Predicate<ExtendedNodeType> PREDICATE_IS_ABSTARCT = nodeType -> nodeType.isAbstract();
    private static final Predicate<ExtendedNodeType> PREDICATE_IS_MIXIN = nodeType -> nodeType.isMixin();

    private static Predicate<ExtendedNodeType> getFilterPredicate(NodeTypesListInput input) {
        if (input == null) {
            return PredicateHelper.truePredicate();
        }
        LinkedList predicates = new LinkedList();
        if (!input.getIncludeAbstract().booleanValue()) {
            predicates.add(PREDICATE_IS_ABSTARCT.negate());
        }
        if (!input.getIncludeMixins().booleanValue()) {
            predicates.add(PREDICATE_IS_MIXIN.negate());
        }
        if (!input.getIncludeNonMixins().booleanValue()) {
            predicates.add(PREDICATE_IS_MIXIN);
        }
        if (input.getExcludeTypes() != null && !input.getExcludeTypes().isEmpty()) {
            predicates.add(NodeTypeHelper.getTypesPredicate(new HashSet<String>(input.getExcludeTypes()), input.getConsiderSubTypes()).negate());
        }
        if (input.getIncludeTypes() != null && !input.getIncludeTypes().isEmpty()) {
            predicates.add(NodeTypeHelper.getTypesPredicate(new HashSet<String>(input.getIncludeTypes()), input.getConsiderSubTypes()));
        }
        return predicates.isEmpty() ? PredicateHelper.truePredicate() : PredicateHelper.allPredicates(predicates);
    }

    public static Predicate<ExtendedNodeType> getTypesPredicate(GqlJcrNode.NodeTypesInput typesFilter) {
        Predicate<Object> typesPredicate;
        if (typesFilter == null) {
            typesPredicate = PredicateHelper.truePredicate();
        } else {
            LinkedList typePredicates = new LinkedList();
            for (String typeFilter : typesFilter.getTypes()) {
                typePredicates.add(ThrowingPredicate.unchecked(extendedNodeType -> extendedNodeType.isNodeType(typeFilter)));
            }
            typesPredicate = PredicateHelper.getCombinedPredicate(typePredicates, typesFilter.getMulticriteriaEvaluation(), MulticriteriaEvaluation.ANY);
        }
        return typesPredicate;
    }

    private static Set<String> getModulesForSite(String siteKey) throws RepositoryException {
        JCRSiteNode site = JahiaSitesService.getInstance().getSiteByKey(siteKey, JCRSessionFactory.getInstance().getCurrentUserSession("default"));
        return site.getInstalledModulesWithAllDependencies();
    }

    public static Stream<ExtendedNodeType> getNodeTypes(NodeTypesListInput input) throws RepositoryException {
        return NodeTypeHelper.getStream(input).filter(NodeTypeHelper.getFilterPredicate(input));
    }

    private static Stream<ExtendedNodeType> getStream(NodeTypesListInput input) throws RepositoryException {
        List<String> modules = null;
        if (input != null) {
            List<String> inputModules = input.getModules();
            String inputSiteKey = input.getSiteKey();
            if (inputModules != null && inputSiteKey != null) {
                throw new IllegalArgumentException("Either a site key or a list of modules can be specified, but not both");
            }
            if (inputModules != null) {
                modules = inputModules;
            } else if (inputSiteKey != null) {
                modules = new LinkedList<String>(NodeTypeHelper.getModulesForSite(inputSiteKey));
                modules.add("system-jahia");
            }
        }
        NodeTypeRegistry registry = NodeTypeRegistry.getInstance();
        NodeTypeRegistry.JahiaNodeTypeIterator it = modules != null ? registry.getAllNodeTypes(modules) : registry.getAllNodeTypes();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    private static Predicate<ExtendedNodeType> getTypesPredicate(Set<String> nodeTypes, boolean considerSubTypes) {
        return nodeTypes == null || nodeTypes.isEmpty() ? PredicateHelper.truePredicate() : nodeType -> NodeTypeHelper.isNodeType(nodeType, nodeTypes, considerSubTypes);
    }

    private static boolean isNodeType(ExtendedNodeType nodeType, Set<String> nodeTypes, boolean considerSubTypes) {
        if (!considerSubTypes) {
            return nodeTypes.contains(nodeType.getName());
        }
        for (String nt : nodeTypes) {
            if (!nodeType.isNodeType(nt)) continue;
            return true;
        }
        return false;
    }

    private NodeTypeHelper() {
    }
}

