/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.nodetype;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.annotations.annotationTypes.GraphQLTypeExtension;
import graphql.annotations.connection.GraphQLConnection;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.stream.Stream;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrQuery;
import org.jahia.modules.graphql.provider.dxm.nodetype.GqlJcrNodeType;
import org.jahia.modules.graphql.provider.dxm.nodetype.NodeTypeHelper;
import org.jahia.modules.graphql.provider.dxm.nodetype.NodeTypesListInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldEvaluator;
import org.jahia.modules.graphql.provider.dxm.predicate.FieldFiltersInput;
import org.jahia.modules.graphql.provider.dxm.predicate.FilterHelper;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedData;
import org.jahia.modules.graphql.provider.dxm.relay.DXPaginatedDataConnectionFetcher;
import org.jahia.modules.graphql.provider.dxm.relay.PaginationHelper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;

@GraphQLTypeExtension(value=GqlJcrQuery.class)
public class NodeTypeJCRQueryExtensions {
    @GraphQLField
    @GraphQLName(value="nodeTypeByName")
    @GraphQLDescription(value="Get a node type by its name")
    public static GqlJcrNodeType getNodeTypeByName(@GraphQLNonNull @GraphQLName(value="name") @GraphQLDescription(value="Node type name") String name) {
        try {
            return new GqlJcrNodeType(NodeTypeRegistry.getInstance().getNodeType(name));
        }
        catch (NoSuchNodeTypeException e) {
            throw new DataFetchingException(e);
        }
    }

    @GraphQLField
    @GraphQLName(value="nodeTypesByNames")
    @GraphQLDescription(value="Get multiple node types by their names")
    public static Collection<GqlJcrNodeType> getNodeTypesByNames(@GraphQLNonNull @GraphQLName(value="names") @GraphQLDescription(value="Node type names") Collection<String> names) {
        LinkedHashSet<GqlJcrNodeType> result = new LinkedHashSet<GqlJcrNodeType>(names.size());
        for (String name : names) {
            ExtendedNodeType nodeType;
            try {
                nodeType = NodeTypeRegistry.getInstance().getNodeType(name);
            }
            catch (NoSuchNodeTypeException e) {
                throw new DataFetchingException(e);
            }
            result.add(new GqlJcrNodeType(nodeType));
        }
        return result;
    }

    @GraphQLField
    @GraphQLName(value="nodeTypes")
    @GraphQLDescription(value="Get a list of nodetypes based on specified parameter")
    @GraphQLConnection(connectionFetcher=DXPaginatedDataConnectionFetcher.class)
    public static DXPaginatedData<GqlJcrNodeType> getNodeTypes(@GraphQLName(value="filter") @GraphQLDescription(value="Filter on node type") NodeTypesListInput input, @GraphQLName(value="fieldFilter") @GraphQLDescription(value="Filter by graphQL fields values") FieldFiltersInput fieldFilter, DataFetchingEnvironment environment) {
        try {
            PaginationHelper.Arguments arguments = PaginationHelper.parseArguments(environment);
            Stream<Object> mapped = NodeTypeHelper.getNodeTypes(input).map(GqlJcrNodeType::new).filter(FilterHelper.getFieldPredicate(fieldFilter, FieldEvaluator.forConnection(environment)));
            return PaginationHelper.paginate(mapped, GqlJcrNodeType::getName, arguments);
        }
        catch (RepositoryException e) {
            throw new DataFetchingException(e);
        }
    }
}

