/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.nodetype;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import java.util.List;
import org.jahia.modules.graphql.provider.dxm.BaseGqlClientException;
import org.jahia.modules.graphql.provider.dxm.node.GqlJcrWrongInputException;

@GraphQLDescription(value="Input for nodetypes list")
public class NodeTypesListInput {
    private List<String> modules;
    private Boolean includeMixins;
    private Boolean includeNonMixins;
    private String siteKey;
    private Boolean includeAbstract;
    private List<String> includeTypes;
    private Boolean considerSubTypes;
    private List<String> excludeTypes;

    public NodeTypesListInput(@GraphQLName(value="siteKey") String siteKey, @GraphQLName(value="modules") List<String> modules, @GraphQLName(value="includeMixins") Boolean includeMixins, @GraphQLName(value="includeNonMixins") Boolean includeNonMixins, @GraphQLName(value="includeAbstract") Boolean includeAbstract, @GraphQLName(value="includeTypes") List<String> includeTypes, @GraphQLName(value="excludeTypes") List<String> excludeTypes, @GraphQLName(value="considerSubTypes") Boolean considerSubTypes) throws BaseGqlClientException {
        if (modules != null && siteKey != null) {
            throw new GqlJcrWrongInputException("Either a site key or a list of modules can be specified, but not both");
        }
        this.siteKey = siteKey;
        this.modules = modules;
        this.includeMixins = includeMixins;
        this.includeNonMixins = includeNonMixins;
        this.includeAbstract = includeAbstract;
        this.includeTypes = includeTypes;
        this.excludeTypes = excludeTypes;
        this.considerSubTypes = considerSubTypes;
    }

    @GraphQLField
    @GraphQLName(value="modules")
    @GraphQLDescription(value="Filter on nodetypes defined in these modules")
    public List<String> getModules() {
        return this.modules;
    }

    @GraphQLField
    @GraphQLName(value="includeMixins")
    @GraphQLDescription(value="Include mixin types (default true)")
    public Boolean getIncludeMixins() {
        return this.includeMixins != null ? this.includeMixins : true;
    }

    @GraphQLField
    @GraphQLName(value="includeNonMixins")
    @GraphQLDescription(value="Include non mixin types (default true)")
    public Boolean getIncludeNonMixins() {
        return this.includeNonMixins != null ? this.includeNonMixins : true;
    }

    @GraphQLField
    @GraphQLName(value="siteKey")
    @GraphQLDescription(value="Consider only nodetypes for the specified site")
    public String getSiteKey() {
        return this.siteKey;
    }

    @GraphQLField
    @GraphQLName(value="includeAbstract")
    @GraphQLDescription(value="Include abstract types (default true)")
    public Boolean getIncludeAbstract() {
        return this.includeAbstract != null ? this.includeAbstract : true;
    }

    @GraphQLField
    @GraphQLName(value="includeTypes")
    @GraphQLDescription(value="Only include types specified by this list (also considering sub-types, if considerSubTypes is true)")
    public List<String> getIncludeTypes() {
        return this.includeTypes;
    }

    @GraphQLField
    @GraphQLName(value="considerSubTypes")
    @GraphQLDescription(value="Consider sub-types when checking for included/excluded nodetypes (default true)")
    public Boolean getConsiderSubTypes() {
        return this.considerSubTypes != null ? this.considerSubTypes : true;
    }

    @GraphQLField
    @GraphQLName(value="excludeTypes")
    @GraphQLDescription(value="Exclude the types, specified by this list (also considering sub-types, if considerSubTypes is true)")
    public List<String> getExcludeTypes() {
        return this.excludeTypes;
    }
}

