/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.modules.graphql.provider.dxm.osgiconfig;

import graphql.annotations.annotationTypes.GraphQLDescription;
import java.io.IOException;
import javax.inject.Inject;
import org.jahia.modules.graphql.provider.dxm.DXGraphQLFieldCompleter;
import org.jahia.modules.graphql.provider.dxm.DataFetchingException;
import org.jahia.modules.graphql.provider.dxm.osgi.annotations.GraphQLOsgiService;
import org.jahia.modules.graphql.provider.dxm.osgiconfig.GqlValueMutation;
import org.jahia.services.modulemanager.spi.Config;
import org.jahia.services.modulemanager.spi.ConfigService;
import org.jahia.services.modulemanager.util.PropertiesValues;

@GraphQLDescription(value="Mutation for OSGi configuration")
public class GqlConfigurationMutation
extends GqlValueMutation
implements DXGraphQLFieldCompleter {
    private Config configuration = null;
    @Inject
    @GraphQLOsgiService
    private ConfigService configService;

    public GqlConfigurationMutation(Config configuration) {
        super(null);
        this.configuration = configuration;
    }

    @Override
    protected PropertiesValues getPropertiesValues() {
        if (this.propertiesValues == null) {
            this.propertiesValues = this.configuration.getValues();
        }
        return super.getPropertiesValues();
    }

    @Override
    public void completeField() {
        if (this.configuration != null) {
            try {
                this.configService.storeConfig(this.configuration);
            }
            catch (IOException e) {
                throw new DataFetchingException(e);
            }
        }
    }
}

